/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.encoding;

import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encoder;
import fr.dyade.aaa.common.encoding.Utf8;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class EncodableHelper {
    static Logger logger = Debug.getLogger(EncodableHelper.class.getName());
    public static final String ENCODING_CHARSET_PROPERTY = "fr.dyade.aaa.common.encoding.charset";
    public static final String ENCODING_USE_JVM_CHARSET_PROPERTY = "fr.dyade.aaa.common.encoding.useJVMcharset";
    public static final String ENCODING_CHARSET_DFLT = "UTF-8";
    static final Charset charset = Configuration.getBoolean("fr.dyade.aaa.common.encoding.useJVMcharset") ? Charset.defaultCharset() : Charset.forName(Configuration.getProperty("fr.dyade.aaa.common.encoding.charset", "UTF-8"));
    private static final boolean multibyte = charset.newEncoder().maxBytesPerChar() > 1.0f;
    private static final boolean utf8 = "UTF-8".equals(charset.name());

    public static final int getStringEncodedSize(String s) {
        if (!multibyte) {
            return 4 + s.length();
        }
        if (utf8) {
            return 4 + Utf8.encodedLength(s);
        }
        return 4 + s.getBytes().length;
    }

    public static final int getNullableStringEncodedSize(String s) {
        int res = 1;
        if (s != null) {
            res += EncodableHelper.getStringEncodedSize(s);
        }
        return res;
    }

    public static final int getByteArrayEncodedSize(byte[] byteArray) {
        return 4 + byteArray.length;
    }

    public static final int getNullableByteArrayEncodedSize(byte[] byteArray) {
        int res = 1;
        if (byteArray != null) {
            res += 4 + byteArray.length;
        }
        return res;
    }

    public static final int getNullableByteArrayEncodedSize(byte[] byteArray, int length) {
        int res = 1;
        if (byteArray != null) {
            res += 4 + length;
        }
        return res;
    }

    public static int getEncodedSize(Properties properties) throws Exception {
        int res = 4;
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            res += EncodableHelper.getStringEncodedSize((String)entry.getKey());
            res += EncodableHelper.getStringEncodedSize((String)entry.getValue());
        }
        return res;
    }

    public static void encodeProperties(Properties properties, Encoder encoder) throws Exception {
        encoder.encodeUnsignedInt(properties.size());
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            encoder.encodeString((String)entry.getKey());
            encoder.encodeString((String)entry.getValue());
        }
    }

    public static Properties decodeProperties(Decoder decoder) throws Exception {
        Properties properties = new Properties();
        int size = decoder.decodeUnsignedInt();
        for (int i = 0; i < size; ++i) {
            String key = decoder.decodeString();
            String value = decoder.decodeString();
            properties.put(key, value);
        }
        return properties;
    }

    static {
        logger.log(BasicLevel.INFO, "Encodable configuration: " + charset.displayName() + ", multibyte=" + multibyte + ", utf8=" + utf8);
    }
}

