/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.encoding;

import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encodable;
import fr.dyade.aaa.common.encoding.EncodableFactory;
import fr.dyade.aaa.common.encoding.EncodableHelper;
import fr.dyade.aaa.common.encoding.Encoder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class EncodedString
implements Serializable,
Encodable {
    private String string;
    private byte[] encodedString;

    public EncodedString() {
    }

    public EncodedString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public void writeTo(DataOutputStream os) throws IOException {
        if (this.encodedString == null) {
            this.encodedString = this.string.getBytes(EncodableHelper.charset);
        }
        os.writeInt(this.encodedString.length);
        os.write(this.encodedString);
    }

    public void readFrom(DataInputStream is) throws IOException {
        int length = is.readInt();
        this.encodedString = new byte[length];
        is.readFully(this.encodedString);
        this.string = new String(this.encodedString, EncodableHelper.charset);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.string);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.string = in.readUTF();
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncodedString) {
            return ((EncodedString)obj).string.equals(this.string);
        }
        return this.string.equals(obj);
    }

    public String toString() {
        return this.string;
    }

    @Override
    public int getEncodableClassId() {
        return 0;
    }

    @Override
    public int getEncodedSize() {
        return EncodableHelper.getStringEncodedSize(this.string);
    }

    @Override
    public void encode(Encoder encoder) throws Exception {
        if (this.encodedString == null) {
            this.encodedString = this.string.getBytes(EncodableHelper.charset);
        }
        encoder.encodeByteArray(this.encodedString);
    }

    @Override
    public void decode(Decoder decoder) throws Exception {
        this.encodedString = decoder.decodeByteArray();
        this.string = new String(this.encodedString, EncodableHelper.charset);
    }

    public static class Factory
    implements EncodableFactory {
        @Override
        public Encodable createEncodable() {
            return new EncodedString();
        }
    }
}

