/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.net;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.net.ServerSocketFactory13;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class ServerSocketFactory {
    static Logger logger = Debug.getLogger(ServerSocketFactory.class.getName());
    public static final String DefaultFactory = ServerSocketFactory13.class.getName();

    public static final ServerSocketFactory getDefaultFactory() {
        ServerSocketFactory serverSocketFactory = null;
        try {
            Class<?> factoryClass = Class.forName(DefaultFactory);
            Method method = factoryClass.getMethod("getFactory", null);
            serverSocketFactory = (ServerSocketFactory)method.invoke(null, (Object[])null);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, "Unable to instantiate default SocketFactory: " + DefaultFactory, exc);
        }
        return serverSocketFactory;
    }

    public static final ServerSocketFactory getFactory(String ssfcn) {
        ServerSocketFactory serverSocketFactory = null;
        try {
            Class<?> factoryClass = Class.forName(ssfcn);
            Method method = factoryClass.getMethod("getFactory", null);
            serverSocketFactory = (ServerSocketFactory)method.invoke(null, (Object[])null);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, "Use default SocketFactory, unable to instantiate : " + ssfcn, exc);
            serverSocketFactory = ServerSocketFactory.getDefaultFactory();
        }
        return serverSocketFactory;
    }

    public abstract ServerSocket createServerSocket(int var1, int var2) throws IOException;

    public abstract ServerSocket createServerSocket(int var1, int var2, InetAddress var3) throws IOException;
}

