/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.jul;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggingFactory;
import org.objectweb.util.monolog.jul.ExtendedFormatter;
import org.objectweb.util.monolog.jul.LogFormatter;
import org.objectweb.util.monolog.jul.SimpleLevel;
import org.objectweb.util.monolog.jul.SimpleLogger;

public class SimpleLoggingFactory
implements LoggingFactory {
    private static boolean debug = Boolean.getBoolean("org.objectweb.util.monolog.debug");
    private static final String HANDLERS = "handlers";
    private static final String LEVEL = ".level";
    private static final String LOGGER = "logger.";
    private static final String FORMAT = ".format";
    private static String OldLogFormatter = "org.objectweb.util.monolog.api.LogFormatter";
    private static final String CONSOLE_HANDLER = "java.util.logging.ConsoleHandler";
    private static final String FILE_HANDLER = "java.util.logging.FileHandler";
    private static final String MEMORY_HANDLER = "java.util.logging.MemoryHandler";
    private static final String SOCKET_HANDLER = "java.util.logging.SocketHandler";
    private static Properties props = new Properties();
    private static HashMap<String, java.util.logging.Logger> sloggers = new HashMap();

    @Override
    public Logger getLogger(String topic) {
        return new SimpleLogger(topic);
    }

    @Override
    public Level getFatalLevel() {
        return new SimpleLevel("FATAL", java.util.logging.Level.SEVERE.intValue());
    }

    @Override
    public Level getErrorLevel() {
        return new SimpleLevel("ERROR", 950);
    }

    @Override
    public Level getWarnLevel() {
        return new SimpleLevel("WARN", java.util.logging.Level.WARNING.intValue());
    }

    @Override
    public Level getInfoLevel() {
        return new SimpleLevel("INFO", java.util.logging.Level.INFO.intValue());
    }

    @Override
    public Level getDebugLevel() {
        return new SimpleLevel("DEBUG", java.util.logging.Level.FINEST.intValue());
    }

    @Override
    public Level parse(String name) {
        return new SimpleLevel(name, java.util.logging.Level.parse(name).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void initialize(String debugDir, String debugFileName) {
        block22: {
            block21: {
                if (SimpleLoggingFactory.debug) {
                    System.err.println("LoggerFactory.initialize: " + debugDir + "/" + debugFileName);
                }
                debugFile = null;
                configStream = null;
                debugFile = debugDir != null ? new File(debugDir, debugFileName) : new File(debugFileName);
                try {
                    if (!debugFile.exists() || !debugFile.isFile() || debugFile.length() == 0L) {
                        throw new IOException();
                    }
                    configStream = new FileInputStream(debugFile);
                }
                catch (IOException exc) {
                    if (!SimpleLoggingFactory.debug) break block21;
                    System.err.println("Unable to find \"" + debugFile.getPath() + "\": " + exc.getMessage());
                }
            }
            if (configStream == null) {
                configStream = SimpleLoggingFactory.class.getClassLoader().getResourceAsStream(debugFileName);
            }
            if (configStream != null) {
                try {
                    SimpleLoggingFactory.configure(configStream);
                    if (SimpleLoggingFactory.debug) {
                        System.err.println("Monolog initialized");
                    }
                    return;
                }
                catch (Throwable exc) {
                    System.err.println("Unable to configure Monolog from file: " + exc.getMessage());
                    if (!SimpleLoggingFactory.debug) ** GOTO lbl41
                    exc.printStackTrace();
                }
                finally {
                    try {
                        configStream.close();
                    }
                    catch (IOException exc) {}
                }
            } else {
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (Throwable exc) {
                    System.err.println("Unable to configure Monolog: " + exc.getMessage());
                    if (!SimpleLoggingFactory.debug) break block22;
                    exc.printStackTrace();
                }
            }
        }
        java.util.logging.Logger.getLogger("").setLevel(java.util.logging.Level.SEVERE);
    }

    private static void setFilter(Handler handler, String classname) {
        try {
            if (debug) {
                System.err.println("Set handler filter:" + handler + " -> " + classname);
            }
            Class<?> clz = Class.forName(classname);
            Filter filter = (Filter)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            handler.setFilter(filter);
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Error setting filter for " + handler.getClass().getName() + ", class not found: " + classname);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exc) {
            System.err.println("Error setting filter for " + handler.getClass().getName() + ": " + exc.getMessage());
        }
    }

    private static void setFormatter(Handler handler, String classname) {
        block11: {
            if (OldLogFormatter.equals(classname)) {
                System.err.println("Classname \"" + OldLogFormatter + "\" is deprecated, you should use \"" + LogFormatter.class.getName() + "\" instead.\nThis class will be removed in future.");
                classname = LogFormatter.class.getName();
            }
            try {
                Formatter formatter;
                block10: {
                    String format;
                    Class<?> clz;
                    if (debug) {
                        System.err.println("Set handler formatter:" + handler + " -> " + classname);
                    }
                    if ((formatter = (Formatter)(clz = Class.forName(classname)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof ExtendedFormatter && (format = props.getProperty(handler.getClass().getName() + FORMAT)) != null) {
                        if (debug) {
                            System.err.println("Use specific format: " + format);
                        }
                        try {
                            ((ExtendedFormatter)((Object)formatter)).setFormat(format);
                        }
                        catch (Exception exc) {
                            System.err.println("Bad format property, use default: " + exc.getMessage());
                            if (!debug) break block10;
                            exc.printStackTrace();
                        }
                    }
                }
                handler.setFormatter(formatter);
            }
            catch (ClassNotFoundException exc) {
                System.err.println("Error setting formatter for " + handler.getClass().getName() + ", class not found: " + classname);
                if (debug) {
                    exc.printStackTrace();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exc) {
                System.err.println("Error setting formatter for " + handler.getClass().getName() + ": " + exc.getMessage());
                if (!debug) break block11;
                exc.printStackTrace();
            }
        }
    }

    private static Integer getInteger(String name, String dflt) {
        String value = props.getProperty(name, dflt);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static Handler createHandler(String classname, Properties props) throws Exception {
        Handler handler = null;
        Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(classname);
        if (CONSOLE_HANDLER.equals(classname)) {
            handler = (Handler)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        } else if (FILE_HANDLER.equals(classname)) {
            Integer limit = SimpleLoggingFactory.getInteger(classname + ".limit", "0");
            Integer count = SimpleLoggingFactory.getInteger(classname + ".count", "1");
            String pattern = props.getProperty(classname + ".pattern", "\"%h/java%u.log\"");
            Boolean append = Boolean.valueOf(props.getProperty(classname + ".append", "false"));
            handler = (Handler)clz.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE).newInstance(pattern, limit, count, append);
        } else if (MEMORY_HANDLER.equals(classname)) {
            Integer size = SimpleLoggingFactory.getInteger(classname + ".size", "1000");
            String push = props.getProperty(classname + ".push", "SEVERE");
            String target = props.getProperty(classname + ".target");
            if (target == null) {
                throw new Exception("Cannot instantiate MemoryHandler without target.");
            }
            handler = (Handler)clz.getDeclaredConstructor(String.class, Integer.TYPE, java.util.logging.Level.class).newInstance(target, size, java.util.logging.Level.parse(push));
        } else if (SOCKET_HANDLER.equals(classname)) {
            String host = props.getProperty(classname + ".host");
            Integer port = SimpleLoggingFactory.getInteger(classname + "port", null);
            if (host == null || port == null) {
                throw new Exception("Cannot instantiate SocketHandler, host and/or port should be defined.");
            }
            handler = (Handler)clz.getDeclaredConstructor(String.class, Integer.TYPE).newInstance(host, port);
        } else {
            handler = (Handler)clz.newInstance();
            System.err.println("Warning: " + classname + " not handled, use default properties.");
        }
        String value = props.getProperty(classname + LEVEL);
        if (value != null) {
            if (debug) {
                System.err.println("Set handler level:" + classname + " -> " + value);
            }
            handler.setLevel(java.util.logging.Level.parse(value));
        }
        if ((value = props.getProperty(classname + ".filter")) != null) {
            SimpleLoggingFactory.setFilter(handler, value);
        }
        if ((value = props.getProperty(classname + ".formatter")) != null) {
            SimpleLoggingFactory.setFormatter(handler, value);
        }
        if ((value = props.getProperty(classname + ".encoding")) != null) {
            if (debug) {
                System.err.println("Set handler encoding:" + classname + " -> " + value);
            }
            try {
                handler.setEncoding(value);
            }
            catch (Exception exc) {
                System.err.println("Error setting encoding for " + classname + ": " + exc.getMessage());
            }
        }
        return handler;
    }

    private static boolean isHandlerName(String name, Vector<String> handlers) {
        for (String handler : handlers) {
            if (!name.equals(handler)) continue;
            return true;
        }
        return false;
    }

    private static void configure(InputStream is) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        props.clear();
        Vector<String> handlers = null;
        Vector<String> loggers = new Vector<String>();
        Vector<String> levels = new Vector<String>();
        Properties config = new Properties();
        if (debug) {
            System.err.println("Monolog.configure");
        }
        int linenb = 1;
        block16: while (true) {
            try {
                String line = reader.readLine();
                if (line == null) break;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                int idx = line.indexOf(61);
                if (idx == -1) {
                    throw new Exception("Cannot parse line " + linenb);
                }
                String name = line.substring(0, idx).trim();
                String value = line.substring(idx + 1).trim();
                props.setProperty(name, value);
                if (debug) {
                    System.err.println("line: " + linenb + "read: ##" + name + "##=##" + value + "##");
                }
                if (name.equals(HANDLERS)) {
                    String[] classes;
                    if (handlers == null) {
                        handlers = new Vector<String>();
                    }
                    String[] stringArray = classes = value.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block16;
                        String cn = stringArray[n2];
                        if (debug) {
                            System.err.println("handler: " + cn);
                        }
                        handlers.add(cn.trim());
                        ++n2;
                    }
                }
                if (handlers == null) {
                    throw new Exception("Handlers definition should be first [line #" + linenb + "].");
                }
                if (name.endsWith(LEVEL)) {
                    if (name.startsWith(LOGGER)) {
                        name = name.substring(7);
                    }
                    if ((name = name.substring(0, name.length() - 6)).isEmpty()) {
                        if (debug) {
                            System.err.println("Set root logger: " + value);
                        }
                        java.util.logging.Logger.getLogger("").setLevel(java.util.logging.Level.parse(value));
                        continue;
                    }
                    if (debug) {
                        System.err.println("Set logger: " + name + "=" + value);
                    }
                    loggers.add(name);
                    levels.add(value);
                    continue;
                }
                if (!name.endsWith(FORMAT)) continue;
                config.put(name, value);
                continue;
            }
            catch (IOException exc) {
                throw new Exception("Error reading configuration: " + exc.getMessage());
            }
            finally {
                ++linenb;
                continue;
            }
            break;
        }
        LogManager.getLogManager().reset();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            config.store(out, "");
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        for (String name : handlers) {
            if (debug) {
                System.err.println("Creates handler: " + name);
            }
            Handler handler = SimpleLoggingFactory.createHandler(name, props);
            java.util.logging.Logger.getLogger("").addHandler(handler);
        }
        for (int i = 0; i < loggers.size(); ++i) {
            String name = (String)loggers.get(i);
            if (SimpleLoggingFactory.isHandlerName(name, handlers)) continue;
            if (debug) {
                System.err.println("Configure logger: " + name + "=" + (String)levels.get(i));
            }
            java.util.logging.Level level = java.util.logging.Level.parse((String)levels.get(i));
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
            sloggers.put(name, logger);
            logger.setLevel(level);
            if (!debug) continue;
            System.err.println("Configure logger: " + logger + " || " + logger.getParent() + " / " + logger.getUseParentHandlers());
        }
        for (String name : loggers) {
            java.util.logging.Level level;
            java.util.logging.Logger logger;
            if (debug) {
                System.err.println("##############################");
            }
            if ((logger = java.util.logging.Logger.getLogger(name)) == null) {
                if (!debug) continue;
                System.err.println("## No logger found for " + name);
                continue;
            }
            if (debug) {
                System.err.println("## " + logger + " || " + sloggers.get(name));
            }
            if ((level = logger.getLevel()) == null) {
                if (!debug) continue;
                System.err.println("## No level found for " + name);
                continue;
            }
            if (!debug) continue;
            System.err.println("## " + name + " -> " + level);
        }
    }
}

