/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util.management;

import fr.dyade.aaa.common.stream.StreamUtil;
import fr.dyade.aaa.util.management.MXServer;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class MXWrapper {
    public static final String NO_JMX = "JoramNoJMX";
    private static MXServer mxserver = null;

    public static String objectName(String domain, String name) {
        return new StringBuffer().append(domain).append(':').append(name).toString();
    }

    public static void registerMBean(Object bean, String domain, String name) throws Exception {
        MXWrapper.registerMBean(bean, MXWrapper.objectName(domain, name));
    }

    public static void registerMBean(Object bean, String fullName) throws Exception {
        if (mxserver != null) {
            mxserver.registerMBean(bean, fullName);
        }
    }

    public static void unregisterMBean(String domain, String name) throws Exception {
        MXWrapper.unregisterMBean(MXWrapper.objectName(domain, name));
    }

    public static void unregisterMBean(String fullName) throws Exception {
        if (mxserver != null) {
            mxserver.unregisterMBean(fullName);
        }
    }

    public static void setMXServer(MXServer server) {
        mxserver = server;
    }

    public static Object getAttribute(String objectName, String attribute) throws Exception {
        if (mxserver != null) {
            return mxserver.getAttribute(objectName, attribute);
        }
        return null;
    }

    public Map<String, Object> getAttributes(String objectName, String[] attributes) throws Exception {
        if (mxserver != null) {
            return mxserver.getAttributes(objectName, attributes);
        }
        return null;
    }

    public static Set<String> queryNames(String objectName) throws Exception {
        if (mxserver != null) {
            return mxserver.queryNames(objectName);
        }
        return null;
    }

    public static List<String> getAttributeNames(String mBean) throws Exception {
        if (mxserver != null) {
            return mxserver.getAttributeNames(mBean);
        }
        return null;
    }

    public static Hashtable<String, Object> dumpAttributes(String[] list) {
        return MXWrapper.dumpAttributes(list, false);
    }

    public static Hashtable<String, Object> dumpAttributes(String[] list, boolean streamable) {
        Hashtable<String, Object> records = new Hashtable<String, Object>();
        for (int i = 0; i < list.length; ++i) {
            int idx = list[i].indexOf(40);
            String name = list[i].substring(0, idx);
            String atts = list[i].substring(idx + 1, list[i].indexOf(41));
            Set<String> mBeans = null;
            try {
                mBeans = MXWrapper.queryNames(name);
            }
            catch (Exception exc) {
                records.put(name + "+" + atts, exc.getMessage());
                continue;
            }
            if (mBeans == null) continue;
            for (String mBean : mBeans) {
                StringTokenizer st = new StringTokenizer(atts, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals("*")) {
                        try {
                            List<String> attributes = MXWrapper.getAttributeNames(mBean);
                            if (attributes == null) continue;
                            for (int j = 0; j < attributes.size(); ++j) {
                                String attname = attributes.get(j);
                                try {
                                    Object value = MXWrapper.getAttribute(mBean, attname);
                                    if (value != null && StreamUtil.isStreamable(value)) {
                                        records.put(mBean + "+" + attname, value);
                                        continue;
                                    }
                                    records.put(mBean + "+" + attname, "not streamable");
                                    continue;
                                }
                                catch (Exception exc) {
                                    records.put(mBean + "+" + attname, exc.getMessage());
                                }
                            }
                            continue;
                        }
                        catch (Exception exc) {
                            records.put(mBean + ";*", exc.getMessage());
                            continue;
                        }
                    }
                    String attname = token.trim();
                    try {
                        Object value = MXWrapper.getAttribute(mBean, attname);
                        if (value != null && StreamUtil.isStreamable(value)) {
                            records.put(mBean + "+" + attname, value);
                            continue;
                        }
                        records.put(mBean + "+" + attname, "not streamable");
                    }
                    catch (Exception exc) {
                        records.put(mBean + "+" + attname, exc.getMessage());
                    }
                }
            }
        }
        return records;
    }

    static {
        if (!Boolean.getBoolean(NO_JMX)) {
            try {
                mxserver = (MXServer)Class.forName(System.getProperty("MXServer", "com.scalagent.jmx.JMXServer")).newInstance();
            }
            catch (Exception exc) {
                mxserver = null;
            }
        }
    }
}

