/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import fr.dyade.aaa.common.Debug;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class Pool {
    int elementCount = 0;
    Object[] elementData = null;
    private Logger logmon = null;
    private long cpt1;
    private long cpt2;
    private long alloc;
    private long free;
    private long min;
    private long max;
    private String name;
    private String logmsg;

    public Pool(String name, int capacity) {
        this.name = name;
        this.logmsg = name + ".Pool: ";
        this.elementData = new Object[capacity];
        this.logmon = Debug.getLogger(this.getClass().getName() + "." + this.getName());
        this.logmon.log(BasicLevel.INFO, this.logmsg + capacity);
    }

    public String getName() {
        return this.name;
    }

    public final synchronized void freeElement(Object obj) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.logmsg + "freeElement " + obj);
        }
        if (this.elementCount == this.elementData.length) {
            ++this.free;
            return;
        }
        this.elementData[this.elementCount] = obj;
        ++this.elementCount;
        if ((long)this.elementCount > this.max) {
            this.max = this.elementCount;
        }
    }

    public final synchronized Object allocElement() throws Exception {
        if (this.elementCount == 0) {
            ++this.alloc;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, this.logmsg + "allocElement <new>");
            }
            throw new Exception();
        }
        --this.elementCount;
        Object obj = this.elementData[this.elementCount];
        this.elementData[this.elementCount] = null;
        if ((long)this.elementCount < this.min) {
            this.min = this.elementCount;
        }
        ++this.cpt1;
        this.cpt2 += (long)this.elementCount;
        if ((this.cpt1 & 0xFFFFFL) == 0L && this.logmon.isLoggable(BasicLevel.INFO)) {
            this.logmon.log(BasicLevel.INFO, this.logmsg + this.cpt2 / this.cpt1 + "/" + this.elementCount + ", " + this.min + "/" + this.max + ", " + this.alloc + ", " + this.free);
            this.alloc = 0L;
            this.free = 0L;
            this.min = this.elementData.length;
            this.max = 0L;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.logmsg + "allocElement " + obj);
        }
        return obj;
    }
}

