/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import fr.dyade.aaa.common.EmptyQueueException;
import fr.dyade.aaa.common.StoppedQueueException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class Queue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Object> elements = new Vector<Object>();
    private boolean stopping;
    private boolean closed;

    public synchronized boolean search(Comparator<Object> c, Object o2) {
        for (Object o1 : this.elements) {
            if (c.compare(o1, o2) != 0) continue;
            return true;
        }
        return false;
    }

    public Queue() {
        this.start();
    }

    public synchronized void push(Object item) {
        if (this.stopping) {
            throw new StoppedQueueException();
        }
        this.elements.add(item);
        this.notify();
    }

    public synchronized Object get() throws InterruptedException {
        while (this.size() == 0 && !this.closed) {
            this.wait();
        }
        if (this.closed) {
            throw new InterruptedException();
        }
        return this.elements.get(0);
    }

    public synchronized Object get(long timeout) throws InterruptedException {
        if (this.size() == 0 && !this.closed) {
            this.wait(timeout);
        }
        if (this.closed) {
            throw new InterruptedException();
        }
        if (this.size() > 0) {
            return this.elements.get(0);
        }
        return null;
    }

    public synchronized Object pop() {
        if (this.size() == 0) {
            throw new EmptyQueueException();
        }
        Object obj = this.elements.get(0);
        this.elements.remove(0);
        if (this.stopping && this.size() == 0) {
            this.notify();
        }
        return obj;
    }

    public synchronized Object getAndPop() throws InterruptedException {
        while (this.size() == 0 && !this.closed) {
            this.wait();
        }
        if (this.closed) {
            throw new InterruptedException();
        }
        Object obj = this.elements.get(0);
        this.elements.remove(0);
        if (this.stopping && this.size() == 0) {
            this.notify();
        }
        return obj;
    }

    public void start() {
        this.stopping = false;
        this.closed = false;
    }

    public synchronized void stop() throws InterruptedException {
        this.stopping = true;
        if (this.size() != 0) {
            this.wait();
        }
    }

    public synchronized void close() {
        this.stopping = true;
        this.closed = true;
        this.notifyAll();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void clear() {
        this.elements.clear();
    }

    public int size() {
        return this.elements.size();
    }

    public synchronized String list() {
        if (this.elements.isEmpty()) {
            return "";
        }
        StringBuilder strbuf = new StringBuilder();
        for (int i = 0; i < this.elements.size(); ++i) {
            strbuf.append(this.elements.get(i)).append(',');
        }
        return strbuf.toString();
    }
}

