/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.crypto;

import fr.dyade.aaa.common.crypto.Crypto;
import fr.dyade.aaa.common.crypto.CryptoTool;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;

public class AESGCMTools
extends CryptoTool {
    private static final int GCM_TAG_LENGTH = 128;
    private String algorithm = null;
    private GCMParameterSpec iv = null;

    public AESGCMTools(String password, String salt, String nonce, int iterationCount, int keyLength) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this("AES/GCM/NoPadding", password, salt, nonce, iterationCount, keyLength);
    }

    public AESGCMTools(String algorithm, String password, String salt, String nonce, int iterationCount, int keyLength) throws NoSuchAlgorithmException, InvalidKeySpecException {
        super(password, salt, iterationCount, keyLength);
        this.algorithm = algorithm;
        this.iv = new GCMParameterSpec(128, nonce.getBytes());
    }

    @Override
    Cipher getCipher(int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(mode, (Key)this.key, this.iv);
        return cipher;
    }

    @Override
    Cipher getCipher(int mode, byte[] nonce) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(mode, (Key)this.key, new GCMParameterSpec(128, nonce));
        return cipher;
    }

    public static Crypto createCrypto(String algorithm, String password, String salt, String iv, int iterationCount, int keyLength) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new AESGCMTools(algorithm, password, salt, iv, iterationCount, keyLength);
    }
}

