/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.crypto;

import fr.dyade.aaa.common.crypto.Crypto;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class CryptoTool
implements Crypto {
    protected SecretKey key = null;

    protected CryptoTool(String password, String salt, int iterationCount, int keyLength) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), iterationCount, keyLength);
        byte[] secret = factory.generateSecret(keySpec).getEncoded();
        this.key = new SecretKeySpec(secret, "AES");
    }

    abstract Cipher getCipher(int var1) throws GeneralSecurityException;

    abstract Cipher getCipher(int var1, byte[] var2) throws GeneralSecurityException;

    @Override
    public byte[] encrypt(byte[] clearText) throws GeneralSecurityException {
        return this.getCipher(1).doFinal(clearText);
    }

    @Override
    public byte[] encrypt(byte[] clearText, byte[] nonce) throws GeneralSecurityException {
        return this.getCipher(1, nonce).doFinal(clearText);
    }

    @Override
    public byte[] decrypt(byte[] cipherText) throws GeneralSecurityException {
        return this.getCipher(2).doFinal(cipherText);
    }

    @Override
    public byte[] decrypt(byte[] cipherText, byte[] nonce) throws GeneralSecurityException {
        return this.getCipher(2, nonce).doFinal(cipherText);
    }
}

