/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.Strings;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class DumpAttributes {
    public static final Logger logger = Debug.getLogger(DumpAttributes.class.getName());

    static void addRecord(StringBuilder strbuf, String mbean, String att, Object value) {
        strbuf.append(mbean).append(':').append(att).append('=');
        Strings.toString(strbuf, value);
        strbuf.append('\n');
    }

    public static StringBuilder dumpAllStackTraces(StringBuilder dump) {
        Map<Thread, StackTraceElement[]> stacktraces = Thread.getAllStackTraces();
        for (Thread thread : stacktraces.keySet()) {
            StackTraceElement[] stacktrace;
            Thread.State state = thread.getState();
            dump.append(String.format("\"%s\" %s prio=%d tid=%d nid=1 %s\njava.lang.Thread.State: %s", thread.getName(), thread.isDaemon() ? "daemon" : "", thread.getPriority(), thread.getId(), Thread.State.WAITING.equals((Object)state) ? "in Object.wait()" : state.name().toLowerCase(), state.equals((Object)Thread.State.WAITING) ? "WAITING (on object monitor)" : state));
            for (StackTraceElement stackTraceElement : stacktrace = stacktraces.get(thread)) {
                dump.append("\n\tat ").append(stackTraceElement);
            }
            dump.append("\n---\n");
        }
        return dump;
    }

    public static StringBuilder dumpAttributes(String name, StringBuilder strbuf) {
        Set<String> mBeans = null;
        try {
            mBeans = MXWrapper.queryNames(name);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, "DumpAttributes.dumpAttributes, bad name: " + name, exc);
            return strbuf;
        }
        if (mBeans != null) {
            for (String mBean : mBeans) {
                try {
                    List<String> attributes = MXWrapper.getAttributeNames(mBean);
                    if (attributes == null) continue;
                    for (int i = 0; i < attributes.size(); ++i) {
                        String attname = attributes.get(i);
                        try {
                            DumpAttributes.addRecord(strbuf, mBean, attname, MXWrapper.getAttribute(mBean, attname));
                            continue;
                        }
                        catch (Exception exc) {
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, "DumpAttributes.dumpAttributes, bad attribute : " + mBean + ":" + attname, exc);
                                continue;
                            }
                            logger.log(BasicLevel.WARN, "DumpAttributes.dumpAttributes, bad attribute : " + mBean + ":" + attname);
                        }
                    }
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.ERROR, "DumpAttributes.dumpAttributes", exc);
                }
            }
        }
        return strbuf;
    }
}

