/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.net;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class SocketAddress {
    private String hostname;
    private InetAddress addr;
    private int port;

    public SocketAddress(String hostname, int port) {
        this.hostname = hostname;
        try {
            this.addr = InetAddress.getByName(this.hostname);
        }
        catch (UnknownHostException exc) {
            this.addr = null;
        }
        this.port = port;
    }

    public InetAddress resetAddr() {
        try {
            this.addr = InetAddress.getByName(this.getHostname());
        }
        catch (UnknownHostException exc) {
            this.addr = null;
        }
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SocketAddress)) {
            return false;
        }
        SocketAddress sa = (SocketAddress)obj;
        return this.hostname.equals(sa.hostname) && this.addr != null && this.addr.equals(sa.addr) && this.port == sa.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addr == null ? 0 : this.addr.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("(").append(super.toString());
        strBuf.append(",hostname=").append(this.hostname);
        strBuf.append(",port=").append(this.port);
        strBuf.append(",addr=").append(this.addr);
        strBuf.append(")");
        return strBuf.toString();
    }
}

