/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.jul;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import org.objectweb.util.monolog.jul.ExtendedFormatter;
import org.objectweb.util.monolog.jul.LogRecord;

class LogFormatter
extends Formatter
implements ExtendedFormatter {
    private static final String FORMAT_PROP_KEY = "org.objectweb.util.monolog.jul.LogFormatter.format";
    private static final String OLD_FORMAT_PROP_KEY = "org.objectweb.util.monolog.api.LogFormatter.format";
    private static final String DEFAULT_FORMAT = "%1$s %7$s %8$s [%4$s.%5$s(%6$s)] %12$s: %10$s%13$s%n";
    private String format = LogManager.getLogManager().getProperty("org.objectweb.util.monolog.jul.LogFormatter.format");
    private static final DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");

    public LogFormatter() {
        if (this.format == null) {
            this.format = LogManager.getLogManager().getProperty(OLD_FORMAT_PROP_KEY);
            if (this.format != null) {
                System.err.println("Property \"org.objectweb.util.monolog.api.LogFormatter.format\" is deprecated, you should use \"org.objectweb.util.monolog.jul.LogFormatter.format\" instead.\nThe old property will be removed in future.");
            }
        }
        if (this.format != null) {
            try {
                this.validateFormat(this.format);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Bad format property, use default: " + e.getMessage());
                this.format = DEFAULT_FORMAT;
            }
        } else {
            System.err.println("No format property, use default");
            this.format = DEFAULT_FORMAT;
        }
    }

    @Override
    public String format(java.util.logging.LogRecord record) {
        Date date = new Date(record.getMillis());
        String source = "";
        String fullSource = record.getSourceClassName();
        if (fullSource == null) {
            fullSource = "";
        } else {
            int idx = fullSource.lastIndexOf(46);
            source = idx == -1 ? fullSource : fullSource.substring(idx + 1);
        }
        String method = record.getSourceMethodName();
        if (method == null) {
            method = "";
        }
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        Object threadName = "T" + record.getThreadID();
        Object lineNumber = "";
        if (record instanceof LogRecord) {
            LogRecord r = (LogRecord)record;
            threadName = r.getThreadName();
            lineNumber = "" + r.getSourceLineNumber();
        }
        return String.format(this.format, df.format(date), date, fullSource, source, method, lineNumber, record.getLoggerName(), record.getLevel().getName(), record.getLevel().getLocalizedName(), message, record.getThreadID(), threadName, throwable);
    }

    private void validateFormat(String f) throws IllegalArgumentException {
        String.format(this.format, new Date(), "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", 11, "12", "13");
    }

    @Override
    public void setFormat(String f) throws IllegalArgumentException {
        this.validateFormat(f);
        this.format = f;
    }
}

