/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.osgi;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.AgentServerActivator;
import fr.dyade.aaa.common.Debug;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator,
AgentServerActivator {
    public static final Logger logmon = Debug.getLogger((String)Activator.class.getName());
    public static final String AGENT_SERVER_ID_PROPERTY = "fr.dyade.aaa.agent.AgentServer.id";
    public static final String AGENT_SERVER_STORAGE_PROPERTY = "fr.dyade.aaa.agent.AgentServer.storage";
    public static final String OSGI_EXIT_PROPERTY = "fr.dyade.aaa.osgi.exit";
    public static BundleContext context;

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        short sid = this.getShortProperty(AGENT_SERVER_ID_PROPERTY, (short)0);
        String path = this.getProperty(AGENT_SERVER_STORAGE_PROPERTY, "s" + sid);
        try {
            AgentServer.activator = this;
            AgentServer.init((short)sid, (String)path, null);
        }
        catch (Exception exc) {
            if (Boolean.parseBoolean(context.getProperty(OSGI_EXIT_PROPERTY))) {
                context.getBundle(0L).stop();
                return;
            }
            throw exc;
        }
        try {
            String errStr = AgentServer.start();
            if (errStr == null) {
                System.out.println(AgentServer.getName() + " started: " + "OK");
            } else {
                System.out.println(AgentServer.getName() + " started: " + "ERROR");
                System.out.print(errStr);
            }
        }
        catch (Exception exc) {
            if (Boolean.parseBoolean(context.getProperty(OSGI_EXIT_PROPERTY))) {
                context.getBundle(0L).stop();
                return;
            }
            throw exc;
        }
    }

    public void stop(BundleContext context) throws Exception {
        AgentServer.stop();
        AgentServer.reset();
        AgentServer.activator = null;
        Activator.context = null;
        if (Boolean.parseBoolean(context.getProperty(OSGI_EXIT_PROPERTY))) {
            context.getBundle(0L).stop();
        }
    }

    private short getShortProperty(String propName, short defaultValue) {
        String propValue = context.getProperty(propName);
        if (propValue != null) {
            return Short.parseShort(propValue);
        }
        return defaultValue;
    }

    private String getProperty(String propName, String defaultValue) {
        String propValue = context.getProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        return defaultValue;
    }

    public void shutdown() throws Exception {
        if (context != null) {
            context.getBundle(0L).stop();
        }
    }
}

