/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentEngineContext;
import fr.dyade.aaa.agent.AgentFactory;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.encoding.EncodableFactory;
import fr.dyade.aaa.common.encoding.EncodableFactoryRepository;
import java.io.IOException;

class AgentEngineContextImpl
implements AgentEngineContext {
    private static EncodableFactory messageFactory = EncodableFactoryRepository.getFactory((Integer)65536);

    AgentEngineContextImpl() {
    }

    @Override
    public Agent createAgentFactory() throws IOException {
        AgentFactory factory = new AgentFactory(AgentId.factoryId);
        factory.save();
        return factory;
    }

    @Override
    public void initializeAgent(AgentId id, Agent agent) throws Exception {
        agent.id = id;
        agent.deployed = true;
        agent.agentInitialize(true);
    }

    @Override
    public void directSendTo(AgentId to, Notification not) {
        Channel.channel.directSendTo(AgentId.localId, to, not);
    }

    @Override
    public void initAgentLogger(Agent agent) throws Exception {
        if (agent.logmon == null) {
            agent.logmon = Debug.getLogger((String)Agent.class.getName());
        }
    }

    @Override
    public Agent loadAgent(AgentId id) throws IOException, ClassNotFoundException {
        return Agent.load(id);
    }

    @Override
    public void setAgentLast(Agent ag, long last) {
        ag.last = last;
    }

    @Override
    public void initializeReloadedAgent(Agent agent) throws Exception {
        agent.agentInitialize(false);
    }

    @Override
    public void setSaveAgent(Agent agent) {
        agent.setSave();
    }

    @Override
    public void saveAgent(Agent agent) throws IOException {
        agent.save();
    }

    @Override
    public Message createMessage(AgentId from, AgentId to, Notification not) {
        Message msg = (Message)messageFactory.createEncodable();
        msg.from = from;
        msg.to = to;
        if (not != null) {
            msg.not = not;
            msg.not.detached = not.detached;
            msg.not.messageId = not.messageId;
        }
        return msg;
    }

    @Override
    public void deleteMessage(Message msg) {
        msg.delete();
        msg.free();
    }

    @Override
    public AgentId getLocalAgentId() {
        return AgentId.localId;
    }

    @Override
    public void incReactNumber(Agent ag) {
        ++ag.reactNb;
    }

    @Override
    public void validateChannel() {
        Channel.validate();
    }

    @Override
    public void checkMessageFrom(Message msg) {
        if (msg.from == null) {
            msg.from = AgentId.localId;
        }
    }

    @Override
    public MessageConsumer getConsumer(short id) throws UnknownServerException {
        return AgentServer.getConsumer(id);
    }

    @Override
    public void channelPost(Message msg) throws Exception {
        Channel.post(msg);
    }

    @Override
    public void saveChannel() throws IOException {
        Channel.save();
    }

    @Override
    public void stampAndSave(Message msg, int stamp) throws IOException {
        msg.source = AgentServer.getServerId();
        msg.dest = AgentServer.getServerId();
        msg.stamp = stamp;
        msg.save();
    }
}

