/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BufferedMessageInputStream;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageOutputStream;
import fr.dyade.aaa.agent.Network;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.UDPNetworkMBean;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class UDPNetwork
extends Network
implements UDPNetworkMBean {
    static final int DATAGRAM_MAX_SIZE = 8000;
    private NetServerIn netServerIn = null;
    private NetServerOut netServerOut = null;
    private Hashtable<SocketAddress, ServerInfo> serversInfo = new Hashtable();
    WatchDog watchDog = null;
    private DatagramSocket socket;
    private int socketReceiveBufferSize = -1;
    private int socketSendBufferSize = -1;

    @Override
    public boolean isRunning() {
        return this.netServerIn != null && this.netServerIn.isRunning() && this.netServerOut != null && this.netServerOut.isRunning() && this.watchDog != null && this.watchDog.isRunning();
    }

    @Override
    public void init(String name, int port, short[] servers) throws Exception {
        super.init(name, port, servers);
        this.watchDog = new WatchDog(this.getName(), this.logmon);
    }

    @Override
    public void start() throws Exception {
        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", starting");
        if (this.netServerIn == null) {
            this.netServerIn = new NetServerIn(this.getName(), this.logmon);
        }
        if (this.netServerOut == null) {
            this.netServerOut = new NetServerOut(this.getName(), this.logmon);
        }
        if (!this.netServerIn.isRunning()) {
            this.netServerIn.start();
        }
        if (!this.netServerOut.isRunning()) {
            this.netServerOut.start();
        }
        this.watchDog.start();
        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", started");
    }

    @Override
    public void stop() {
        if (this.netServerIn != null) {
            this.netServerIn.stop();
        }
        if (this.netServerOut != null) {
            this.netServerOut.stop();
        }
        if (this.watchDog != null) {
            this.watchDog.stop();
        }
        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", stopped");
    }

    private String getMBeanName(String socketAddress) {
        return new StringBuffer().append("server=").append(AgentServer.getName()).append(",cons=").append(this.name).append(",serverDest=#").append(socketAddress).toString();
    }

    @Override
    public int getSocketReceiveBufferSize() throws SocketException {
        return this.socketReceiveBufferSize;
    }

    @Override
    public int getSocketSendBufferSize() throws SocketException {
        return this.socketSendBufferSize;
    }

    final class WatchDog
    extends Daemon {
        private Object lock;
        private boolean force;

        WatchDog(String name, Logger logmon) {
            super(name + ".watchdog", logmon);
            this.force = false;
            this.lock = new Object();
            this.logmon = logmon;
        }

        protected void close() {
        }

        protected void shutdown() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeup(boolean forced) {
            this.force = forced;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.running) {
                        block34: {
                            try {
                                this.lock.wait(UDPNetwork.this.WDActivationPeriod);
                                if (!this.logmon.isLoggable(BasicLevel.DEBUG)) break block34;
                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", activated, force=" + this.force);
                            }
                            catch (InterruptedException exc) {
                                continue;
                            }
                        }
                        boolean hasBeenForced = this.force;
                        this.force = false;
                        if (!this.running) break;
                        Enumeration enuAddr = UDPNetwork.this.serversInfo.keys();
                        long currentTimeMillis = System.currentTimeMillis();
                        while (enuAddr.hasMoreElements()) {
                            SocketAddress addr = (SocketAddress)enuAddr.nextElement();
                            ServerInfo servInfo = (ServerInfo)UDPNetwork.this.serversInfo.get(addr);
                            Object object2 = servInfo.lock;
                            synchronized (object2) {
                                if (!(hasBeenForced || servInfo.retry < UDPNetwork.this.WDNbRetryLevel1 || servInfo.retry < UDPNetwork.this.WDNbRetryLevel2 && servInfo.lastMsgSentDate + UDPNetwork.this.WDRetryPeriod2 < currentTimeMillis || servInfo.lastMsgSentDate + UDPNetwork.this.WDRetryPeriod3 < currentTimeMillis)) {
                                    continue;
                                }
                                if (!servInfo.messagesToAck.isEmpty()) {
                                    if (servInfo.lastMsgSentNumber == servInfo.messagesToAck.getFirst().msg.stamp) {
                                        ++servInfo.retry;
                                        if (servInfo.retry > 4) {
                                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", connection lost with the server.");
                                            }
                                            servInfo.handshaken = false;
                                        }
                                    } else {
                                        servInfo.lastMsgSentNumber = servInfo.messagesToAck.getFirst().msg.stamp;
                                    }
                                }
                                if (!servInfo.handshaken) {
                                    try {
                                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", watchdog send handshake.");
                                        }
                                        ((UDPNetwork)UDPNetwork.this).netServerOut.messageOutputStream.handShake(addr);
                                        servInfo.lastMsgSentDate = currentTimeMillis;
                                    }
                                    catch (IOException exc) {
                                        this.logmon.log(BasicLevel.ERROR, this.getName() + ", watchdog ack ", (Throwable)exc);
                                    }
                                    continue;
                                }
                                if (!hasBeenForced && currentTimeMillis - servInfo.lastMsgSentDate < UDPNetwork.this.WDActivationPeriod / 2L) {
                                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", watchdog don't send ack: last message sent recently");
                                    }
                                    continue;
                                }
                                if (servInfo.messagesToAck.isEmpty()) {
                                    if (currentTimeMillis - servInfo.lastMsgReceivedDate > UDPNetwork.this.WDActivationPeriod * 2L) {
                                        continue;
                                    }
                                    try {
                                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", watchdog send ack.");
                                        }
                                        ((UDPNetwork)UDPNetwork.this).netServerOut.messageOutputStream.writeAck(servInfo.lastPacketAck, addr);
                                    }
                                    catch (IOException exc) {
                                        this.logmon.log(BasicLevel.ERROR, this.getName() + ", watchdog ack ", (Throwable)exc);
                                    }
                                    continue;
                                }
                                if (!hasBeenForced && currentTimeMillis - servInfo.lastMsgSentDate < UDPNetwork.this.WDActivationPeriod - 100L) {
                                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", watchdog don't re-send: last message sent recently");
                                    }
                                    continue;
                                }
                                Iterator iterMessages = servInfo.messagesToAck.iterator();
                                while (iterMessages.hasNext()) {
                                    try {
                                        MessageAndIndex msgi = (MessageAndIndex)iterMessages.next();
                                        ((UDPNetwork)UDPNetwork.this).netServerOut.reSendMessageOutputStream.writeMessage(servInfo, addr, msgi.index, msgi.msg, currentTimeMillis);
                                        if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                                        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", re-send message " + msgi.msg);
                                    }
                                    catch (IOException exc) {
                                        this.logmon.log(BasicLevel.ERROR, this.getName() + ", re send error ", (Throwable)exc);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException rexc) {
                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", re send error ", (Throwable)rexc);
            }
        }
    }

    final class NetworkInputStream
    extends BufferedMessageInputStream {
        NetworkInputStream(InputStream is) {
            this.in = is;
        }

        @Override
        protected void readHeader() throws IOException {
        }
    }

    final class MessageBuilder
    extends Daemon {
        private ServerInfo servInfo;
        private NetworkInputStream pipeIn;
        private OutputStream pipeOut;

        public MessageBuilder(ServerInfo info, Logger logmon) throws IOException {
            super(UDPNetwork.this.name + ".MessageBuilder", logmon);
            this.servInfo = info;
            PipedInputStream is = new PipedInputStream();
            this.pipeIn = new NetworkInputStream(is);
            this.pipeOut = new PipedOutputStream(is);
        }

        public void feed(DatagramPacket packet) throws IOException {
            this.pipeOut.write(packet.getData(), packet.getOffset() + 8, packet.getLength() - 8);
            this.pipeOut.flush();
        }

        public void run() {
            try {
                while (this.running) {
                    try {
                        Message message = null;
                        this.canStop = true;
                        try {
                            message = this.pipeIn.readMessage();
                        }
                        catch (IOException ioe) {
                            if (this.logmon.isLoggable(BasicLevel.WARN)) {
                                this.logmon.log(BasicLevel.WARN, this.getName() + ", interrupted: ", (Throwable)ioe);
                            }
                            break;
                        }
                        this.canStop = false;
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", msg received " + message);
                        }
                        UDPNetwork.this.deliver(message);
                        this.servInfo.lastPacketAck = this.servInfo.lastPacketReceived;
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, this.getName(), (Throwable)exc);
                        break;
                    }
                }
            }
            finally {
                this.finish();
            }
        }

        protected void close() {
            try {
                this.pipeIn.close();
                this.pipeOut.close();
            }
            catch (IOException exc) {
                this.logmon.log(BasicLevel.ERROR, this.getName(), (Throwable)exc);
            }
        }

        protected void shutdown() {
            this.close();
        }
    }

    final class DatagramOutputStream
    extends MessageOutputStream {
        private int datagramStamp;
        private int size;
        private SocketAddress serverAddr;
        private ServerInfo serverInfo;
        private byte[] ackBuf;
        private byte[] handshakeBuf;

        DatagramOutputStream() throws IOException {
            super(8000);
            this.ackBuf = new byte[10];
            this.handshakeBuf = new byte[10];
            this.count = 8;
            this.handshakeBuf[4] = 0;
            this.handshakeBuf[5] = 0;
            this.handshakeBuf[6] = 0;
            this.handshakeBuf[7] = 1;
            this.handshakeBuf[8] = (byte)(UDPNetwork.this.sid >>> 8);
            this.handshakeBuf[9] = (byte)(UDPNetwork.this.sid >>> 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeMessage(SocketAddress addr, Message msg, long currentTimeMillis) throws IOException {
            ServerInfo serverInfo;
            if (UDPNetwork.this.serversInfo.get(addr) == null) {
                serverInfo = new ServerInfo();
                try {
                    MXWrapper.registerMBean((Object)serverInfo, (String)"AgentServer", (String)UDPNetwork.this.getMBeanName(addr.toString().replace(':', '#')));
                }
                catch (Exception exc) {
                    DatagramOutputStream.getLogger().log(BasicLevel.ERROR, UDPNetwork.this.getName() + " jmx failed", (Throwable)exc);
                }
                UDPNetwork.this.serversInfo.put(addr, serverInfo);
                if (DatagramOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    DatagramOutputStream.getLogger().log(BasicLevel.DEBUG, UDPNetwork.this.getName() + ", starting handshake.");
                }
                this.handShake(addr);
            } else {
                serverInfo = (ServerInfo)UDPNetwork.this.serversInfo.get(addr);
            }
            Object object = serverInfo.lock;
            synchronized (object) {
                this.size = 0;
                this.writeMessage(serverInfo, addr, serverInfo.nextPacketNumber, msg, currentTimeMillis);
                serverInfo.messagesToAck.addLast(new MessageAndIndex(msg, serverInfo.nextPacketNumber, this.size));
                serverInfo.nextPacketNumber = this.datagramStamp;
            }
            this.serverInfo = null;
        }

        void writeAck(int ackNumber, SocketAddress addr) throws IOException {
            this.ackBuf[0] = (byte)(ackNumber >>> 24);
            this.ackBuf[1] = (byte)(ackNumber >>> 16);
            this.ackBuf[2] = (byte)(ackNumber >>> 8);
            this.ackBuf[3] = (byte)(ackNumber >>> 0);
            if (ackNumber == 1) {
                int boot = UDPNetwork.this.getBootTS();
                this.ackBuf[4] = (byte)(boot >>> 24);
                this.ackBuf[5] = (byte)(boot >>> 16);
                this.ackBuf[6] = (byte)(boot >>> 8);
                this.ackBuf[7] = (byte)(boot >>> 0);
                this.ackBuf[8] = (byte)(UDPNetwork.this.sid >>> 8);
                this.ackBuf[9] = (byte)(UDPNetwork.this.sid >>> 0);
            } else {
                this.ackBuf[4] = 0;
                this.ackBuf[5] = 0;
                this.ackBuf[6] = 0;
                this.ackBuf[7] = 0;
                this.ackBuf[8] = 0;
                this.ackBuf[9] = 0;
            }
            UDPNetwork.this.socket.send(new DatagramPacket(this.ackBuf, this.ackBuf.length, addr));
        }

        @Override
        public void write(int b) throws IOException {
            this.buf[this.count] = (byte)b;
            ++this.count;
            if (this.count == 8000) {
                this.sendPacket();
            }
        }

        private void sendPacket() throws IOException {
            this.buf[0] = (byte)(this.serverInfo.lastPacketAck >>> 24);
            this.buf[1] = (byte)(this.serverInfo.lastPacketAck >>> 16);
            this.buf[2] = (byte)(this.serverInfo.lastPacketAck >>> 8);
            this.buf[3] = (byte)(this.serverInfo.lastPacketAck >>> 0);
            this.buf[4] = (byte)(this.datagramStamp >>> 24);
            this.buf[5] = (byte)(this.datagramStamp >>> 16);
            this.buf[6] = (byte)(this.datagramStamp >>> 8);
            this.buf[7] = (byte)(this.datagramStamp >>> 0);
            ++this.datagramStamp;
            ++this.size;
            if (this.serverInfo.handshaken) {
                UDPNetwork.this.socket.send(new DatagramPacket(this.buf, this.count, this.serverAddr));
            }
            this.count = 8;
        }

        void writeMessage(ServerInfo serverInfo, SocketAddress addr, int startIndex, Message msg, long currentTimeMillis) throws IOException {
            this.serverAddr = addr;
            this.datagramStamp = startIndex;
            this.serverInfo = serverInfo;
            this.writeMessage(msg, currentTimeMillis);
            this.sendPacket();
            serverInfo.lastMsgSentDate = currentTimeMillis;
        }

        void handShake(SocketAddress addr) throws IOException {
            int boot = UDPNetwork.this.getBootTS();
            this.handshakeBuf[0] = (byte)(boot >>> 24);
            this.handshakeBuf[1] = (byte)(boot >>> 16);
            this.handshakeBuf[2] = (byte)(boot >>> 8);
            this.handshakeBuf[3] = (byte)(boot >>> 0);
            UDPNetwork.this.socket.send(new DatagramPacket(this.handshakeBuf, this.handshakeBuf.length, addr));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int sizeMax = this.buf.length - this.count;
            if (len > sizeMax) {
                System.arraycopy(b, off, this.buf, this.count, sizeMax);
                this.count = this.buf.length;
                this.sendPacket();
                this.write(b, off + sizeMax, len - sizeMax);
                return;
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }

        @Override
        protected void writeHeader() {
        }
    }

    final class NetServerOut
    extends Daemon {
        DatagramOutputStream messageOutputStream;
        DatagramOutputStream reSendMessageOutputStream;

        protected NetServerOut(String name, Logger logmon) throws Exception {
            super(name + ".NetServerOut", logmon);
            this.messageOutputStream = null;
            this.reSendMessageOutputStream = null;
        }

        protected void close() {
        }

        protected void shutdown() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msg = null;
            ServerDesc server = null;
            try {
                try {
                    this.messageOutputStream = new DatagramOutputStream();
                    this.reSendMessageOutputStream = new DatagramOutputStream();
                }
                catch (IOException exc) {
                    this.logmon.log(BasicLevel.FATAL, this.getName() + ", cannot start.");
                    this.finish();
                    return;
                }
                while (this.running) {
                    this.canStop = true;
                    try {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", waiting message");
                        }
                        msg = UDPNetwork.this.qout.get();
                    }
                    catch (InterruptedException exc) {
                        if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", interrupted");
                        continue;
                    }
                    this.canStop = false;
                    if (msg == null) continue;
                    ExpiredNot expiredNot = null;
                    try {
                        short msgto = msg.getDest();
                        server = AgentServer.getServerDesc(msgto);
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", try to send message:" + msg + "/" + msgto);
                        }
                        if (msg.not.expiration > 0L && msg.not.expiration < System.currentTimeMillis()) {
                            if (msg.not.deadNotificationAgentId != null) {
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, this.getName() + ": forward expired notification1 " + msg.from + ", " + msg.not + " to " + msg.not.deadNotificationAgentId);
                                }
                                expiredNot = new ExpiredNot(msg.not, msg.from, msg.to);
                            } else if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ": removes expired notification " + msg.from + ", " + msg.not);
                            }
                        } else {
                            this.messageOutputStream.writeMessage(new InetSocketAddress(server.getAddr(), server.getPort()), msg, System.currentTimeMillis());
                        }
                    }
                    catch (UnknownServerException exc) {
                        this.logmon.log(BasicLevel.ERROR, this.getName() + ", can't send message: " + msg, (Throwable)exc);
                    }
                    catch (IOException exc) {
                        this.logmon.log(BasicLevel.ERROR, this.getName() + ", can't send message: " + msg, (Throwable)exc);
                    }
                    AgentServer.getTransaction().begin();
                    if (expiredNot != null) {
                        Channel.post(Message.alloc(AgentId.localId, msg.not.deadNotificationAgentId, expiredNot));
                        Channel.validate();
                    }
                    UDPNetwork.this.qout.pop();
                    AgentServer.getTransaction().commit(true);
                }
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.FATAL, this.getName() + ", unrecoverable exception", (Throwable)exc);
                AgentServer.stop(false);
            }
            finally {
                this.finish();
            }
        }
    }

    final class NetServerIn
    extends Daemon {
        final byte[] buf;
        final DatagramPacket packet;

        protected NetServerIn(String name, Logger logmon) throws IOException {
            super(name + ".NetServerIn", logmon);
            this.buf = new byte[8000];
            this.packet = new DatagramPacket(this.buf, this.buf.length);
            UDPNetwork.this.socket = new DatagramSocket(UDPNetwork.this.port);
            UDPNetwork.this.socket.setReceiveBufferSize(AgentServer.getInteger("UDPReceiveBufferSize", 0x100000));
            UDPNetwork.this.socket.setSendBufferSize(AgentServer.getInteger("UDPSendBufferSize", 8192));
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, this.getName() + ", socket buffer sizes: Receive:" + UDPNetwork.this.socket.getReceiveBufferSize() + " Send:" + UDPNetwork.this.socket.getSendBufferSize());
            }
            UDPNetwork.this.socketReceiveBufferSize = UDPNetwork.this.socket.getReceiveBufferSize();
            UDPNetwork.this.socketSendBufferSize = UDPNetwork.this.socket.getSendBufferSize();
        }

        protected void close() {
            UDPNetwork.this.socket.close();
        }

        protected void shutdown() {
            Enumeration enumSrvInfo = UDPNetwork.this.serversInfo.elements();
            while (enumSrvInfo.hasMoreElements()) {
                ServerInfo srvInfo = (ServerInfo)enumSrvInfo.nextElement();
                if (srvInfo.messageIncomingBuilder == null) continue;
                srvInfo.messageIncomingBuilder.shutdown();
            }
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (this.running) {
                    try {
                        this.canStop = true;
                        try {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", waiting messages");
                            }
                            UDPNetwork.this.socket.receive(this.packet);
                        }
                        catch (SocketException exc) {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", waiting messages has been interrupted ", (Throwable)exc);
                            }
                            if (!this.running || !UDPNetwork.this.socket.isClosed()) continue;
                            UDPNetwork.this.socket = new DatagramSocket(UDPNetwork.this.port);
                            UDPNetwork.this.socket.setReceiveBufferSize(UDPNetwork.this.socketReceiveBufferSize);
                            UDPNetwork.this.socket.setSendBufferSize(UDPNetwork.this.socketSendBufferSize);
                            if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", socket reinitialized: buffer sizes: Receive:" + UDPNetwork.this.socket.getReceiveBufferSize() + " Send:" + UDPNetwork.this.socket.getSendBufferSize());
                            continue;
                        }
                        this.canStop = false;
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", received message from:  " + this.packet.getAddress() + ":" + this.packet.getPort());
                        }
                        SocketAddress socketAddress = this.packet.getSocketAddress();
                        ServerInfo srvInfo = (ServerInfo)UDPNetwork.this.serversInfo.get(socketAddress);
                        if (srvInfo == null) {
                            srvInfo = new ServerInfo();
                            try {
                                MXWrapper.registerMBean((Object)srvInfo, (String)"AgentServer", (String)UDPNetwork.this.getMBeanName(socketAddress.toString().replace(':', '#')));
                            }
                            catch (Exception exc) {
                                this.logmon.log(BasicLevel.ERROR, this.getName() + " jmx failed", (Throwable)exc);
                            }
                            UDPNetwork.this.serversInfo.put(socketAddress, srvInfo);
                        }
                        int ackUpTo = ((this.buf[0] & 0xFF) << 24) + ((this.buf[1] & 0xFF) << 16) + ((this.buf[2] & 0xFF) << 8) + ((this.buf[3] & 0xFF) << 0);
                        int packetNumber = ((this.buf[4] & 0xFF) << 24) + ((this.buf[5] & 0xFF) << 16) + ((this.buf[6] & 0xFF) << 8) + ((this.buf[7] & 0xFF) << 0);
                        if (ackUpTo == 1) {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, "Handshake response received " + ackUpTo);
                            }
                            this.cleanServerInfo(srvInfo, packetNumber);
                            UDPNetwork.this.watchDog.wakeup(true);
                            continue;
                        }
                        if (packetNumber == 1) {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, "Handshake received, send handshake response ");
                            }
                            this.cleanServerInfo(srvInfo, ackUpTo);
                            ((UDPNetwork)UDPNetwork.this).netServerOut.messageOutputStream.writeAck(1, socketAddress);
                            continue;
                        }
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", packet received " + packetNumber + ", ack up to " + ackUpTo);
                        }
                        boolean isNack = false;
                        if (ackUpTo < 0) {
                            ackUpTo = -ackUpTo - 1;
                            isNack = true;
                        }
                        AgentServer.getTransaction().begin();
                        Object object = srvInfo.lock;
                        synchronized (object) {
                            while (!srvInfo.messagesToAck.isEmpty() && srvInfo.messagesToAck.getFirst().index + srvInfo.messagesToAck.getFirst().size - 1 <= ackUpTo) {
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, this.getName() + ", clean message " + srvInfo.messagesToAck.getFirst().msg);
                                }
                                MessageAndIndex msgi = srvInfo.messagesToAck.removeFirst();
                                msgi.msg.delete();
                                msgi.msg.free();
                            }
                        }
                        AgentServer.getTransaction().commit(true);
                        if (isNack) {
                            UDPNetwork.this.watchDog.wakeup(true);
                        }
                        if (this.packet.getLength() <= 25) continue;
                        srvInfo.lastMsgReceivedDate = System.currentTimeMillis();
                        if (packetNumber != srvInfo.lastPacketReceived + 1) {
                            if (packetNumber <= srvInfo.lastPacketReceived) {
                                if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", Already received packet " + packetNumber + "-> Ignored");
                                continue;
                            }
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", Missing packet " + (srvInfo.lastPacketReceived + 1));
                            }
                            if (srvInfo.lastPacketAck == -(srvInfo.lastPacketReceived + 1)) continue;
                            if (this.logmon.isLoggable(BasicLevel.WARN)) {
                                this.logmon.log(BasicLevel.WARN, this.getName() + ", Send NACK " + (srvInfo.lastPacketReceived + 1));
                            }
                            ++srvInfo.nackCount;
                            srvInfo.lastPacketAck = -(srvInfo.lastPacketReceived + 1);
                            ((UDPNetwork)UDPNetwork.this).netServerOut.messageOutputStream.writeAck(srvInfo.lastPacketAck, socketAddress);
                            continue;
                        }
                        ++srvInfo.lastPacketReceived;
                        if (srvInfo.messageIncomingBuilder == null || !srvInfo.messageIncomingBuilder.isRunning()) {
                            srvInfo.messageIncomingBuilder = new MessageBuilder(srvInfo, this.logmon);
                            srvInfo.messageIncomingBuilder.start();
                        }
                        srvInfo.messageIncomingBuilder.feed(this.packet);
                    }
                    catch (Exception ioe) {
                        this.logmon.log(BasicLevel.ERROR, this.getName(), (Throwable)ioe);
                    }
                }
                return;
            }
            finally {
                this.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanServerInfo(ServerInfo srvInfo, int bootstamp) throws IOException, Exception {
            if (srvInfo.messageIncomingBuilder != null) {
                srvInfo.messageIncomingBuilder.shutdown();
            }
            srvInfo.messageIncomingBuilder = new MessageBuilder(srvInfo, this.logmon);
            short remotesid = (short)(((this.buf[8] & 0xF) << 8) + ((this.buf[9] & 0xF) << 0));
            Object object = srvInfo.lock;
            synchronized (object) {
                srvInfo.handshaken = true;
                srvInfo.lastPacketReceived = 1;
                srvInfo.nextPacketNumber = 2;
                srvInfo.lastPacketAck = 0;
                srvInfo.retry = 1;
                int diff = 0;
                if (srvInfo.messagesToAck.size() > 0) {
                    MessageAndIndex msgi = srvInfo.messagesToAck.getFirst();
                    diff = msgi.index - 2;
                }
                Iterator iterMessages = srvInfo.messagesToAck.iterator();
                MessageAndIndex msgi = null;
                long currentTimeMillis = System.currentTimeMillis();
                while (iterMessages.hasNext()) {
                    msgi = (MessageAndIndex)iterMessages.next();
                    if (msgi.msg.not.expiration > 0L && msgi.msg.not.expiration < currentTimeMillis) {
                        if (msgi.msg.not.deadNotificationAgentId != null) {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ": forward expired notification1 " + msgi.msg.from + ", " + msgi.msg.not + " to " + msgi.msg.not.deadNotificationAgentId);
                            }
                            AgentServer.getTransaction().begin();
                            Channel.post(Message.alloc(AgentId.localId, msgi.msg.not.deadNotificationAgentId, new ExpiredNot(msgi.msg.not, msgi.msg.from, msgi.msg.to)));
                            Channel.validate();
                            AgentServer.getTransaction().commit(true);
                        } else if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ": removes expired notification " + msgi.msg.from + ", " + msgi.msg.not);
                        }
                        iterMessages.remove();
                        diff += msgi.size;
                    }
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, "Changed index " + msgi.index + "->" + (msgi.index - diff) + " " + msgi.msg);
                    }
                    msgi.index -= diff;
                }
                if (msgi != null) {
                    srvInfo.nextPacketNumber = msgi.index + msgi.size;
                }
            }
            UDPNetwork.this.testBootTS(remotesid, bootstamp);
        }
    }

    final class MessageAndIndex {
        Message msg;
        int index;
        int size;

        public MessageAndIndex(Message msg, int index, int size) {
            this.msg = msg;
            this.index = index;
            this.size = size;
        }
    }

    public static interface ServerInfoMBean {
        public int getNextPacketNumber();

        public int getLastPacketReceived();

        public int getLastPacketAck();

        public int getNbWaitingAckMessages();

        public long getLastMsgReceivedDate();

        public long getLastMsgSentDate();

        public int getNackCount();
    }

    final class ServerInfo
    implements ServerInfoMBean {
        int nextPacketNumber = 2;
        int lastPacketReceived = 1;
        int lastPacketAck = 0;
        MessageBuilder messageIncomingBuilder;
        LinkedList<MessageAndIndex> messagesToAck = new LinkedList();
        boolean handshaken = false;
        long lastMsgReceivedDate;
        long lastMsgSentDate;
        int retry;
        int lastMsgSentNumber;
        int nackCount;
        Object lock = new Object();

        ServerInfo() {
        }

        @Override
        public int getNextPacketNumber() {
            return this.nextPacketNumber;
        }

        @Override
        public int getLastPacketReceived() {
            return this.lastPacketReceived;
        }

        @Override
        public int getLastPacketAck() {
            return this.lastPacketAck;
        }

        @Override
        public int getNbWaitingAckMessages() {
            return this.messagesToAck.size();
        }

        @Override
        public long getLastMsgReceivedDate() {
            return this.lastMsgReceivedDate;
        }

        @Override
        public long getLastMsgSentDate() {
            return this.lastMsgSentDate;
        }

        @Override
        public int getNackCount() {
            return this.nackCount;
        }
    }
}

