/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Timer;
import java.util.TimerTask;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class WakeUpTask
extends TimerTask {
    private static final Logger logger = Debug.getLogger((String)WakeUpTask.class.getName());
    private AgentId destId;
    private Class<?> wakeUpNot;
    private boolean schedule;

    public WakeUpTask(AgentId id, Class<?> wakeUpNotClass, long period) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Create new wake up task, period=" + period);
        }
        this.schedule = false;
        this.destId = id;
        this.wakeUpNot = wakeUpNotClass;
        this.schedule(period);
    }

    @Override
    public void run() {
        try {
            Channel.sendTo(this.destId, (Notification)this.wakeUpNot.newInstance());
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, "--- " + this, (Throwable)exc);
        }
    }

    private void schedule(long period) {
        block5: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Schedule wake up task, period=" + period);
            }
            if (period > 0L) {
                try {
                    Timer timer = AgentServer.getTimer();
                    if (!this.schedule) {
                        timer.schedule((TimerTask)this, period, period);
                        this.schedule = true;
                    }
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block5;
                    logger.log(BasicLevel.WARN, "--- " + this, (Throwable)exc);
                }
            }
        }
    }
}

