/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util.backup;

import fr.dyade.aaa.common.BinaryDump;
import fr.dyade.aaa.util.backup.BackupRecord;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Pattern;

public class RestoreFile
extends RandomAccessFile
implements Closeable {
    private int nbRecords = this.readInt();
    private int nbRead = 0;
    public static final String HELP_CMD = "help";
    public static final String LIST_CMD = "list";
    public static final String EXTRACT_CMD = "extract";
    public static final String DUMP_CMD = "dump";
    public static final String EXTRACT_DIRECTORY = "EXTRACT_DIRECTORY";
    public static final String FILTER_PROPERTY = "FILTER";

    public int getNbRecords() {
        return this.nbRecords;
    }

    public RestoreFile(File file) throws IOException {
        super(file, "r");
        if (this.nbRecords < 0) {
            throw new IOException("Backup file is not finalized");
        }
    }

    public BackupRecord getNextRecord() throws IOException {
        BackupRecord record = null;
        if (this.nbRead < this.nbRecords) {
            ++this.nbRead;
            record = new BackupRecord();
            record.dirName = this.readUTF();
            if (record.dirName.length() == 0) {
                record.dirName = null;
            }
            record.name = this.readUTF();
            int length = this.readInt();
            record.value = new byte[length];
            this.readFully(record.value);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void list(File file, Pattern filter) throws IOException {
        try (RestoreFile restoreFile = null;){
            restoreFile = new RestoreFile(file);
            System.out.println("| RestoreFile: " + restoreFile.nbRecords + "\n+---");
            BackupRecord record = restoreFile.getNextRecord();
            while (record != null) {
                if (filter == null || filter.matcher(record.getName()).matches()) {
                    System.out.println("| " + record);
                }
                record = restoreFile.getNextRecord();
            }
            System.out.println("+---");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File backupFile, Pattern filter, File extractDir) throws IOException {
        try (RestoreFile restoreFile = null;){
            restoreFile = new RestoreFile(backupFile);
            System.out.println("| RestoreFile: " + restoreFile.nbRecords + "\n+---");
            BackupRecord record = restoreFile.getNextRecord();
            while (record != null) {
                if (filter == null || filter.matcher(record.getName()).matches()) {
                    System.out.println("| Restores " + record.getPathname());
                    File dir = extractDir;
                    if (record.dirName != null && !(dir = new File(extractDir, record.dirName)).mkdirs()) {
                        throw new IOException("can't create directory " + record.dirName);
                    }
                    File file = new File(dir, record.name);
                    try (RandomAccessFile raf = null;){
                        raf = new RandomAccessFile(file, "rw");
                        raf.write(record.value);
                    }
                }
                record = restoreFile.getNextRecord();
            }
            System.out.println("+---");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(File file, Pattern filter) throws IOException {
        try (RestoreFile restoreFile = null;){
            restoreFile = new RestoreFile(file);
            System.out.println("| RestoreFile: " + restoreFile.nbRecords);
            BackupRecord record = restoreFile.getNextRecord();
            while (record != null) {
                if (filter == null || filter.matcher(record.getName()).matches()) {
                    System.out.println("+---\n| Dumps " + record.getPathname());
                    System.out.print(BinaryDump.dump((byte[])record.getValue(), (long)0L, (int)0));
                }
                record = restoreFile.getNextRecord();
            }
            System.out.println("+---");
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            RestoreFile.usage();
            return;
        }
        String command = args[0];
        if (!(LIST_CMD.equals(command) || EXTRACT_CMD.equals(command) || DUMP_CMD.equals(command))) {
            RestoreFile.usage();
            return;
        }
        String fname = args[1];
        String dpath = System.getProperty(EXTRACT_DIRECTORY);
        Pattern filter = null;
        String regexp = System.getProperty(FILTER_PROPERTY);
        if (regexp != null && !regexp.isEmpty()) {
            filter = Pattern.compile(regexp);
        }
        if (LIST_CMD.equals(command)) {
            try {
                RestoreFile.list(new File(fname), filter);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        } else if (EXTRACT_CMD.equals(command)) {
            try {
                File dir;
                if (dpath == null) {
                    dir = new File(".");
                } else {
                    dir = new File(dpath);
                    if (dir.exists()) {
                        if (!dir.isDirectory()) {
                            throw new IOException(dpath + " is not a directory");
                        }
                    } else if (!dir.mkdirs()) {
                        throw new IOException("can not create directory " + dpath);
                    }
                }
                RestoreFile.extract(new File(fname), filter, dir);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        } else if (DUMP_CMD.equals(command)) {
            try {
                RestoreFile.dump(new File(fname), filter);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
    }

    public static void usage() {
        System.out.println("usage:\njava -DEXTRACT_DIRECTORY=<path> -DSILENT=true -jar backuptool.jar\n  [help|list|extract|dump] <path to backup file>\n");
        System.err.println("Options and parameters, set by Java environment variable (\"-Dproperty=value\" in\ncommand line):");
        System.err.println("  - EXTRACT_DIRECTORY: Path to directory where to restore the data. If it is not\n    defined uses the current directory.");
        System.err.println("  - FILTER: Regular expression allowing to filter objets. If it is not\n    defined all objects are processed by the command.");
        System.err.println("\nCommands:\n  - help: prints the usage message.\n  - list: lists the objects contained in the backup file.\n  - extract: extracts the objects contained in the backup file.\n  - dump: dumps the objects contained in the backup file.\n");
    }
}

