/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentEngine;
import fr.dyade.aaa.agent.AgentEngineContextImpl;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.CheckServerListener;
import fr.dyade.aaa.agent.CheckServerTask;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.Network;
import fr.dyade.aaa.agent.SCServer;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.ServerUpdate;
import fr.dyade.aaa.agent.ServersHT;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.agent.SimpleNetwork;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNat;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import fr.dyade.aaa.agent.conf.Log;
import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.encoding.EncodableFactory;
import fr.dyade.aaa.common.encoding.EncodableFactoryRepository;
import fr.dyade.aaa.util.Transaction;
import fr.dyade.aaa.util.backup.BackupRecord;
import fr.dyade.aaa.util.backup.RestoreFile;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggingFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public final class AgentServer {
    private static Logger logmon = Debug.getLogger((String)AgentServer.class.getName());
    public static final short NULL_ID = -1;
    public static final String ADMIN_DOMAIN = "D0";
    public static final String ADMIN_SERVER = "s0";
    public static final int ENCODABLE_CLASS_ID_AREA = 65536;
    public static final int MESSAGE_CLASS_ID = 65536;
    public static final String UPDATE_CONF_TX_NAME = "updatecfg";
    public static final String BACKUP_FILE = "BACKUP_FILE";
    public static final String DEFAULT_BACKUP_FILE = "backup.tbck";
    public static ServerUpdate updatecfg;
    public static String defaultConfig;
    public static final String CFG_ADMINUID_PROPERTY = "fr.dyade.aaa.agent.A3CONF_ADMINUID";
    public static final String CFG_ADMINPWD_PROPERTY = "fr.dyade.aaa.agent.A3CONF_ADMINPWD";
    public static final String CFG_JMS_PORT_PROPERTY = "fr.dyade.aaa.agent.A3CONF_JMS_PORT";
    public static final int CFG_JMS_PORT_DFLT = 16010;
    public static final String CFG_MIN_JORAM_PORT_PROPERTY = "fr.dyade.aaa.agent.A3CONF_MIN_JMS_PORT";
    public static final int CFG_MIN_JORAM_PORT_DFLT = 16000;
    public static final String CFG_MAX_JORAM_PORT_PROPERTY = "fr.dyade.aaa.agent.A3CONF_MAX_JMS_PORT";
    public static final int CFG_MAX_JORAM_PORT_DFLT = 16100;
    public static final String CFG_JNDI_PORT_PROPERTY = "fr.dyade.aaa.agent.A3CONF_JNDI_PORT";
    public static final int CFG_JNDI_PORT_DFLT = 16400;
    private static short serverId;
    public static BundleContext context;
    public static final String CFG_DIR_PROPERTY = "fr.dyade.aaa.agent.A3CONF_DIR";
    public static final String DEFAULT_CFG_DIR;
    public static final String CFG_FILE_PROPERTY = "fr.dyade.aaa.agent.A3CONF_FILE";
    public static final String DEFAULT_CFG_FILE = "a3servers.xml";
    public static final String USE_DEFAULT_CONFIG_PROPERTY = "fr.dyade.aaa.agent.useDefaultConfiguration";
    public static final String DEFAULT_USE_DEFAULT_CONFIG = "true";
    public static final String DEFAULT_SER_CFG_FILE = "a3cmlconfig";
    public static final String CFG_NAME_PROPERTY = "fr.dyade.aaa.agent.A3CONF_NAME";
    public static final String DEFAULT_CFG_NAME = "default";
    public static final String A3CMLWRP_PROPERTY = "fr.dyade.aaa.agent.A3CMLWrapper";
    public static final String DEFAULT_A3CMLWRP = "fr.dyade.aaa.agent.conf.A3CMLSaxWrapper";
    public static final String CFG_CHECK_PERIOD_PROPERTY = "fr.dyade.aaa.agent.check.period";
    static CheckServerTask checkServerTask;
    static ThreadGroup tgroup;
    static AgentEngine engine;
    static Transaction transaction;
    private static Hashtable<String, MessageConsumer> consumers;
    private static Timer timer;
    private static A3CMLConfig a3config;
    private static String name;
    private static ServersHT servers;
    private static Status status;
    private static ServerLock lock;
    public static final long startDate;
    public static final String CFG_EXIT_ON_SERVICE_FAILURE_PROPERTY = "fr.dyade.aaa.agent.exitOnServiceFailure";
    public static final String OKSTRING = "OK";
    public static final String ERRORSTRING = "ERROR";
    public static final String ENDSTRING = "END";

    public static void setDefaultConfig(int sid) {
        AgentServer.setDefaultConfig(sid, null, null, null, 0, 0);
    }

    public static void setDefaultConfig(int sid, String host, String adminuid, String adminpwd, int joram, int jndi) {
        AgentServer.setDefaultConfig(sid, host, adminuid, adminpwd, joram, jndi, null);
    }

    public static void setDefaultConfig(int sid, String host, String adminuid, String adminpwd, int joram, int jndi, Properties props) {
        StringBuffer strbuf = new StringBuffer();
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                host = "localhost";
            }
        }
        if (adminuid == null) {
            adminuid = System.getProperty(CFG_ADMINUID_PROPERTY, "root");
        }
        if (adminpwd == null) {
            adminpwd = System.getProperty(CFG_ADMINPWD_PROPERTY, adminuid);
        }
        if (joram == 0) {
            joram = Integer.getInteger(CFG_JMS_PORT_PROPERTY, 16010);
        }
        if (jndi == 0) {
            jndi = Integer.getInteger(CFG_JNDI_PORT_PROPERTY, 16400);
        }
        strbuf.append("<config>\n");
        if (props != null) {
            if (props.getProperty("Transaction") == null) {
                props.setProperty("Transaction", "fr.dyade.aaa.ext.NGTransaction");
            }
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                strbuf.append("<property name=\"").append(key).append("\" value=\"").append(props.getProperty(key)).append("\"/>\n");
            }
        } else {
            strbuf.append("<property name=\"Transaction\" value=\"fr.dyade.aaa.ext.NGTransaction\"/>\n<server id=\"").append(sid).append("\" name=\"S").append(sid).append("\" hostname=\"").append(host).append("\">\n");
        }
        if (joram > 0) {
            strbuf.append("<service class=\"org.objectweb.joram.mom.proxies.ConnectionManager\" args=\"").append(adminuid).append(' ').append(adminpwd).append("\"/>\n<service class=\"org.objectweb.joram.mom.proxies.tcp.TcpProxyService\" args=\"").append(joram).append("\"/>\n");
        } else if (joram == -1) {
            strbuf.append("<!-- No Joram/JMS service -->\n");
        } else if (joram == -2) {
            strbuf.append("<service class=\"org.objectweb.joram.mom.proxies.ConnectionManager\" args=\"").append(adminuid).append(' ').append(adminpwd).append("\"/>\n");
        } else if (joram == -2) {
            int min = Integer.getInteger(CFG_MIN_JORAM_PORT_PROPERTY, 16000);
            int max = Integer.getInteger(CFG_MAX_JORAM_PORT_PROPERTY, 16100);
            joram = min + new Random().nextInt(max - min);
            strbuf.append("<service class=\"org.objectweb.joram.mom.proxies.ConnectionManager\" args=\"").append(adminuid).append(' ').append(adminpwd).append("\"/>\n<service class=\"org.objectweb.joram.mom.proxies.tcp.TcpProxyService\" args=\"").append(joram).append("\"/>\n");
        }
        if (jndi > 0) {
            strbuf.append("<service class=\"fr.dyade.aaa.jndi2.server.JndiServer\" args=\"").append(jndi).append("\"/>\n");
        }
        strbuf.append("</server>\n</config>\n");
        defaultConfig = strbuf.toString();
    }

    public static void setDefaultConfig(String config) {
        defaultConfig = config;
    }

    static void shutdown() {
        if (context == null) {
            return;
        }
        try {
            context.getBundle(0L).stop();
        }
        catch (BundleException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.WARN, AgentServer.getName() + ", shutdown error.", (Throwable)exc);
            }
            logmon.log(BasicLevel.WARN, AgentServer.getName() + ", shutdown error: " + (Object)((Object)exc));
        }
    }

    public static void registerCheckServerListener(CheckServerListener listener) {
        if (checkServerTask == null) {
            logmon.log(BasicLevel.ERROR, AgentServer.getName() + " cannot register CheckServerListener.");
        }
        checkServerTask.registerListener(listener);
    }

    public static void unregisterCheckServerListener(CheckServerListener listener) {
        if (checkServerTask == null) {
            logmon.log(BasicLevel.ERROR, AgentServer.getName() + " cannot unregister CheckServerListener.");
        }
        checkServerTask.unregisterListener(listener);
    }

    public static ThreadGroup getThreadGroup() {
        return tgroup;
    }

    public static AgentEngine getEngine() {
        return engine;
    }

    public static boolean isEngineThread() {
        return engine.isEngineThread();
    }

    public static void resetEngineAverageLoad() {
        AgentServer.getEngine().resetAverageLoad();
    }

    public static float getEngineAverageLoad1() {
        return AgentServer.getEngine().getAverageLoad1();
    }

    public static float getEngineAverageLoad5() {
        return AgentServer.getEngine().getAverageLoad5();
    }

    public static float getEngineAverageLoad15() {
        return AgentServer.getEngine().getAverageLoad15();
    }

    public static int getEngineLoad() {
        return AgentServer.getEngine().getNbWaitingMessages();
    }

    public static boolean isAgentProfiling() {
        return engine.isAgentProfiling();
    }

    public static void setAgentProfiling(boolean agentProfiling) {
        engine.setAgentProfiling(agentProfiling);
    }

    public static long getReactTime() {
        return engine.getReactTime();
    }

    public static long getCommitTime() {
        return engine.getCommitTime();
    }

    public static Transaction getTransaction() {
        return transaction;
    }

    public static void addConsumer(String domain, MessageConsumer cons) throws Exception {
        block3: {
            if (consumers.containsKey(domain)) {
                throw new Exception("Consumer for domain " + domain + " already exist");
            }
            consumers.put(domain, cons);
            try {
                MXWrapper.registerMBean((Object)cons, (String)"AgentServer", (String)("server=" + AgentServer.getName() + ",cons=" + cons.getName()));
            }
            catch (Exception exc) {
                if (!logmon.isLoggable(BasicLevel.DEBUG)) break block3;
                logmon.log(BasicLevel.WARN, AgentServer.getName() + " jmx failed", (Throwable)exc);
            }
        }
    }

    static Enumeration<MessageConsumer> getConsumers() {
        if (consumers == null) {
            return null;
        }
        return consumers.elements();
    }

    public static MessageConsumer getConsumer(String domain) throws Exception {
        if (!consumers.containsKey(domain)) {
            throw new Exception("Unknown consumer for domain " + domain);
        }
        return consumers.get(domain);
    }

    public static void removeConsumer(String domain) {
        block3: {
            MessageConsumer cons = consumers.remove(domain);
            if (cons != null) {
                cons.stop();
                try {
                    MXWrapper.unregisterMBean((String)"AgentServer", (String)("server=" + AgentServer.getName() + ",cons=" + cons.getName()));
                }
                catch (Exception exc) {
                    if (!logmon.isLoggable(BasicLevel.DEBUG)) break block3;
                    logmon.log(BasicLevel.WARN, AgentServer.getName() + " jmx failed", (Throwable)exc);
                }
            }
        }
    }

    public static final synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("a3rtTimer");
        }
        return timer;
    }

    public static final void setConfig(A3CMLConfig a3config) throws Exception {
        AgentServer.setConfig(a3config, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setConfig(A3CMLConfig a3config, boolean force) throws Exception {
        if (!force) {
            Status status = AgentServer.status;
            synchronized (status) {
                if (AgentServer.status.value != 0) {
                    throw new Exception("cannot set config, bad status: " + AgentServer.getStatusInfo());
                }
            }
        }
        AgentServer.a3config = a3config;
    }

    public static final A3CMLConfig getConfig() throws Exception {
        if (a3config == null) {
            throw new Exception("Server not configured");
        }
        return a3config;
    }

    public static A3CMLConfig getAppConfig(String[] domains) throws Exception {
        return AgentServer.getConfig().getDomainConfig(domains);
    }

    public static final short getServerId() {
        return serverId;
    }

    public static final String getName() {
        return name;
    }

    public static final String getServerName() {
        try {
            return AgentServer.getConfig().getServerNameById(AgentServer.getServerId());
        }
        catch (Exception e) {
            return AgentServer.getName();
        }
    }

    public static short getServerIdByName(String name) throws Exception {
        return AgentServer.getConfig().getServerIdByName(name);
    }

    public static String getProperty(String key) {
        return Configuration.getProperty((String)key);
    }

    public static String getProperty(String key, String value) {
        return Configuration.getProperty((String)key, (String)value);
    }

    public static Integer getInteger(String key) {
        return Configuration.getInteger((String)key);
    }

    public static Integer getInteger(String key, int value) {
        return Configuration.getInteger((String)key, (int)value);
    }

    public static Long getLong(String key) {
        return Configuration.getLong((String)key);
    }

    public static Long getLong(String key, long value) {
        return Configuration.getLong((String)key, (long)value);
    }

    public static boolean getBoolean(String key) {
        return Configuration.getBoolean((String)key);
    }

    public static void addServerDesc(ServerDesc desc) throws Exception {
        if (desc == null) {
            return;
        }
        servers.put(desc);
    }

    public static ServerDesc removeServerDesc(short sid) throws Exception {
        return servers.remove(sid);
    }

    public static Enumeration<ServerDesc> elementsServerDesc() {
        return servers.elements();
    }

    public static Enumeration<Short> getServersIds() {
        return servers.keys();
    }

    static final int getServerNb() {
        return servers.size();
    }

    public static final ServerDesc getServerDesc(short sid) throws UnknownServerException {
        ServerDesc serverDesc = servers.get(sid);
        if (serverDesc == null) {
            throw new UnknownServerException("Unknow server id. #" + sid);
        }
        return serverDesc;
    }

    static final MessageConsumer getConsumer(short sid) throws UnknownServerException {
        return AgentServer.getServerDesc(sid).getDomain();
    }

    public static final String getHostname(short sid) throws UnknownServerException {
        return AgentServer.getServerDesc(sid).getHostname();
    }

    static final ServiceDesc[] getServices() throws UnknownServerException {
        return AgentServer.getServerDesc((short)AgentServer.getServerId()).services;
    }

    public static final String getServiceArgs(short sid, String classname) throws Exception {
        return AgentServer.getConfig().getServiceArgs(sid, classname);
    }

    public static final String getServiceArgs(String hostname, String classname) throws Exception {
        return AgentServer.getConfig().getServiceArgsHost(hostname, classname);
    }

    private static void configure() throws Exception {
        A3CMLServer root = AgentServer.getConfig().getServer(serverId);
        servers = new ServersHT();
        ServerDesc local = new ServerDesc(root.sid, root.name, root.hostname, -1);
        servers.put(local);
        AgentServer.getConfig().configure(root);
        AgentServer.createConsumers(root);
        Enumeration<A3CMLServer> s = AgentServer.getConfig().servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = s.nextElement();
            if (server.sid == root.sid) continue;
            ServerDesc desc = AgentServer.createServerDesc(server);
            AgentServer.addServerDesc(desc);
        }
        AgentServer.initServices(root, local);
        local.setDomain(engine);
    }

    private static void createConsumers(A3CMLServer root) throws Exception {
        consumers = new Hashtable();
        String cname = "fr.dyade.aaa.agent.Engine";
        cname = AgentServer.getProperty("Engine", cname);
        Class<?> eclass = Class.forName(cname);
        engine = (AgentEngine)eclass.newInstance();
        AgentServer.addConsumer("local", engine);
        Enumeration<A3CMLNetwork> n = root.networks.elements();
        while (n.hasMoreElements()) {
            A3CMLNetwork network = n.nextElement();
            A3CMLDomain domain = AgentServer.getConfig().getDomain(network.domain);
            try {
                Network consumer = (Network)Class.forName(domain.network).newInstance();
                consumer.init(domain.name, network.port, domain.getServersId());
                AgentServer.addConsumer(network.domain, consumer);
            }
            catch (ClassNotFoundException exc) {
                throw exc;
            }
            catch (InstantiationException exc) {
                throw exc;
            }
            catch (IllegalAccessException exc) {
                throw exc;
            }
        }
    }

    public static void initServerDesc(ServerDesc desc, A3CMLServer server) throws Exception {
        desc.gateway = server.gateway;
        if (desc.gateway == -1 || desc.gateway == server.sid) {
            desc.gateway = server.sid;
            desc.updateSockAddr(desc.getHostname(), server.port);
            A3CMLServer current = AgentServer.getConfig().getServer(AgentServer.getServerId());
            if (current.containsNat(server.sid)) {
                A3CMLNat nat = current.getNat(server.sid);
                desc.updateSockAddr(nat.host, nat.port);
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, AgentServer.getName() + " : NAT sDesc = " + desc);
                }
            }
        }
        desc.setDomain(AgentServer.getConsumer(server.domain));
    }

    private static ServerDesc createServerDesc(A3CMLServer server) throws Exception {
        if (!server.visited) {
            throw new Exception(server + " inaccessible");
        }
        ServerDesc desc = new ServerDesc(server.sid, server.name, server.hostname, -1);
        AgentServer.initServerDesc(desc, server);
        AgentServer.initServices(server, desc);
        return desc;
    }

    private static void initServices(A3CMLServer server, ServerDesc desc) throws Exception {
        if (server.services != null) {
            ServiceDesc[] services = new ServiceDesc[server.services.size()];
            int idx = 0;
            Enumeration<A3CMLService> x = server.services.elements();
            while (x.hasMoreElements()) {
                A3CMLService service = x.nextElement();
                services[idx++] = new ServiceDesc(service.classname, service.args);
                Class.forName(service.classname);
            }
            desc.services = services;
        }
    }

    private static void setProperties(short sid) throws Exception {
        A3CMLServer server;
        if (a3config == null) {
            return;
        }
        if (AgentServer.a3config.properties != null) {
            Enumeration<A3CMLProperty> e = AgentServer.a3config.properties.elements();
            while (e.hasMoreElements()) {
                A3CMLProperty p = e.nextElement();
                Configuration.putProperty((String)p.name, (String)p.value);
                if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                logmon.log(BasicLevel.DEBUG, AgentServer.getName() + " : Adds global property: " + p.name + " = " + p.value);
            }
        }
        if ((server = a3config.getServer(sid)) != null && server.properties != null) {
            Enumeration<A3CMLProperty> e = server.properties.elements();
            do {
                A3CMLProperty p = e.nextElement();
                Configuration.putProperty((String)p.name, (String)p.value);
                if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                logmon.log(BasicLevel.DEBUG, AgentServer.getName() + " : Adds server property: " + p.name + " = " + p.value);
            } while (e.hasMoreElements());
        }
    }

    public static int getStatus() {
        return AgentServer.status.value;
    }

    public static String getStatusInfo() {
        return Status.info[AgentServer.status.value];
    }

    public static int init(String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception("usage: java <main> sid storage");
        }
        short sid = -1;
        try {
            sid = (short)Integer.parseInt(args[0]);
        }
        catch (NumberFormatException exc) {
            throw new Exception("usage: java <main> sid storage");
        }
        String path = args[1];
        AgentServer.init(sid, path, null);
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(boolean force) {
        if (force) {
            Status status = AgentServer.status;
            synchronized (status) {
                if (AgentServer.status.value != 6) {
                    logmon.log(BasicLevel.WARN, AgentServer.getName() + ", reset force status: " + AgentServer.getStatusInfo());
                }
                AgentServer.status.value = 6;
            }
        }
        AgentServer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        block18: {
            block17: {
                Status status = AgentServer.status;
                synchronized (status) {
                    if (AgentServer.status.value == 0) {
                        logmon.log(BasicLevel.INFO, AgentServer.getName() + ", already reseted.");
                        return;
                    }
                    if (AgentServer.status.value != 6) {
                        logmon.log(BasicLevel.WARN, AgentServer.getName() + ", cannot reset, bad status: " + AgentServer.getStatusInfo());
                        return;
                    }
                    AgentServer.status.value = 7;
                }
                Enumeration<MessageConsumer> e = AgentServer.getConsumers();
                if (e != null) {
                    while (e.hasMoreElements()) {
                        MessageConsumer cons = e.nextElement();
                        try {
                            MXWrapper.unregisterMBean((String)"AgentServer", (String)("server=" + AgentServer.getName() + ",cons=" + cons.getName()));
                        }
                        catch (Exception exc) {
                            if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                            logmon.log(BasicLevel.WARN, AgentServer.getName() + ", jmx failed: server=" + AgentServer.getName() + ",cons=" + cons.getName(), (Throwable)exc);
                        }
                    }
                    consumers = null;
                }
                try {
                    MXWrapper.unregisterMBean((String)"AgentServer", (String)("server=" + AgentServer.getName() + ",cons=Transaction"));
                }
                catch (Exception exc) {
                    if (!logmon.isLoggable(BasicLevel.DEBUG)) break block17;
                    logmon.log(BasicLevel.WARN, AgentServer.getName() + ", jmx failed: server=" + AgentServer.getName() + ",cons=Transaction", (Throwable)exc);
                }
            }
            if (transaction != null) {
                transaction.close();
            }
            transaction = null;
            lock.close();
            lock = null;
            try {
                MXWrapper.unregisterMBean((String)"AgentServer", (String)("server=" + AgentServer.getName()));
            }
            catch (Exception exc) {
                if (!logmon.isLoggable(BasicLevel.DEBUG)) break block18;
                logmon.log(BasicLevel.WARN, AgentServer.getName() + " jmx failed: server=" + AgentServer.getName(), (Throwable)exc);
            }
        }
        a3config = null;
        Status status = AgentServer.status;
        synchronized (status) {
            AgentServer.status.value = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int externalUpdateConfFromFile(String serverConfigFilePath, String serverDataDirPath) throws Exception {
        ServerLock lock = null;
        File dir = new File(serverDataDirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            logmon.log(BasicLevel.WARN, "Transactional persistence not initialized");
            return -1;
        }
        File lockfile = new File(serverDataDirPath, "lock");
        try {
            try {
                lock = new ServerLock(lockfile);
            }
            catch (Exception exc) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, "AgentServer.updateConf(): It seems that this server is running, try to remove the lock file: " + lockfile.getCanonicalPath(), (Throwable)exc);
                } else {
                    logmon.log(BasicLevel.FATAL, "AgentServer.updateConf(): It seems that this server is running, try to remove the lock file: " + lockfile.getCanonicalPath());
                }
                throw new IOException("Server is running (lock file already existing)");
            }
            int n = AgentServer.updateConfFromFile(serverConfigFilePath, serverDataDirPath);
            return n;
        }
        finally {
            lock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int externalUpdateConfFromString(String serverConfig, String serverDataDirPath) throws Exception {
        ServerLock lock = null;
        File dir = new File(serverDataDirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            logmon.log(BasicLevel.WARN, "Transactional persistence not initialized");
            return -1;
        }
        File lockfile = new File(serverDataDirPath, "lock");
        try {
            try {
                lock = new ServerLock(lockfile);
            }
            catch (Exception exc) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, "AgentServer.updateConf(): It seems that this server is running, try to remove the lock file: " + lockfile.getCanonicalPath(), (Throwable)exc);
                } else {
                    logmon.log(BasicLevel.FATAL, "AgentServer.updateConf(): It seems that this server is running, try to remove the lock file: " + lockfile.getCanonicalPath());
                }
                throw new IOException("Server is running (lock file already existing)");
            }
            int n = AgentServer.updateConfFromString(serverConfig, serverDataDirPath);
            return n;
        }
        finally {
            lock.close();
        }
    }

    public static int updateConfFromFile(String serverConfigFilePath, String serverDataDirPath) throws Exception {
        A3CMLConfig a3cmlConfig = null;
        try (FileReader reader = new FileReader(new File(serverConfigFilePath));){
            a3cmlConfig = A3CML.getConfig(reader);
        }
        return AgentServer.updateConf(a3cmlConfig, serverDataDirPath);
    }

    public static int updateConfFromString(String serverConfig, String serverDataDirPath) throws Exception {
        A3CMLConfig a3cmlConfig = A3CML.getConfig(new StringReader(serverConfig));
        return AgentServer.updateConf(a3cmlConfig, serverDataDirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int updateConf(A3CMLConfig a3cmlConfig, String serverDataDirPath) throws Exception {
        block32: {
            File dir = new File(serverDataDirPath);
            if (dir.exists() && dir.isDirectory()) {
                Status status = AgentServer.status;
                synchronized (status) {
                    if (AgentServer.status.value != 0) {
                        throw new Exception("Cannot update configuration, bad status: " + AgentServer.getStatusInfo());
                    }
                    AgentServer.status.value = 8;
                }
                try {
                    File tfc = new File(dir, "TFC");
                    if (tfc.exists()) {
                        Transaction transaction;
                        Properties props = new Properties();
                        Hashtable<String, A3CMLProperty> properties = a3cmlConfig.properties;
                        Set<Map.Entry<String, A3CMLProperty>> set = properties.entrySet();
                        for (Map.Entry<String, A3CMLProperty> e : set) {
                            if (!e.getKey().startsWith("Transaction.")) continue;
                            props.put(e.getValue().name, e.getValue().value);
                        }
                        File tpf = new File(dir, "TPF");
                        try (FileOutputStream fos = null;){
                            fos = new FileOutputStream(tpf);
                            props.storeToXML(fos, "Transaction properties");
                        }
                        try (FilterInputStream dis = null;){
                            dis = new DataInputStream(new FileInputStream(tfc));
                            String tname = ((DataInputStream)dis).readUTF();
                            transaction = (Transaction)Class.forName(tname).newInstance();
                        }
                        try {
                            transaction.init(serverDataDirPath);
                        }
                        catch (IOException exc) {
                            throw new Exception("Failed to start transaction manager", exc);
                        }
                        transaction.begin();
                        ServerUpdate updatecfg = new ServerUpdate();
                        transaction.save(updatecfg, UPDATE_CONF_TX_NAME);
                        transaction.save(a3cmlConfig, DEFAULT_SER_CFG_FILE);
                        transaction.commit(true);
                        transaction.stop();
                        logmon.log(BasicLevel.INFO, "Configuration updated.");
                        break block32;
                    }
                    logmon.log(BasicLevel.WARN, "Transactional persistence not initialized #1");
                    int n = -1;
                    return n;
                }
                finally {
                    status = AgentServer.status;
                    synchronized (status) {
                        AgentServer.status.value = 0;
                    }
                }
            }
            logmon.log(BasicLevel.WARN, "Transactional persistence not initialized #2");
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreServer(String fname) throws IOException {
        try (RandomAccessFile restoreFile = null;){
            File backupFile = new File(fname);
            if (!(backupFile.exists() && backupFile.isFile() && backupFile.canRead())) {
                throw new IOException(fname + " should be an existing file with read rigths.");
            }
            restoreFile = new RestoreFile(backupFile);
            logmon.log(BasicLevel.WARN, AgentServer.getName() + " restore from " + fname + ": " + ((RestoreFile)restoreFile).getNbRecords() + " records.");
            AgentServer.getTransaction().begin();
            BackupRecord record = ((RestoreFile)restoreFile).getNextRecord();
            while (record != null) {
                logmon.log(BasicLevel.WARN, AgentServer.getName() + " restore dirName=" + record.getDirName() + ", name =" + record.getName());
                AgentServer.getTransaction().createByteArray(record.getValue(), record.getDirName(), record.getName());
                record = ((RestoreFile)restoreFile).getNextRecord();
            }
            AgentServer.getTransaction().commit(true);
            logmon.log(BasicLevel.WARN, AgentServer.getName() + " restored from " + fname + ": " + ((RestoreFile)restoreFile).getNbRecords() + " records.");
        }
    }

    public static void init(short sid, String path, LoggingFactory loggerFactory) throws Exception {
        AgentServer.init(sid, path, false, loggerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(short sid, String path, boolean update, LoggingFactory loggerFactory) throws Exception {
        long dterr;
        name = new StringBuffer("AgentServer#").append(sid).toString();
        if (loggerFactory != null) {
            System.err.println("AgentServer.init: Could not set logger factory.");
        }
        if ((logmon = Debug.getLogger((String)(AgentServer.class.getName() + ".#" + sid))).isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.INFO, AgentServer.getName() + ", init()", (Throwable)new Exception());
        } else {
            logmon.log(BasicLevel.INFO, AgentServer.getName() + ", init()");
        }
        File dataDir = new File(path);
        if (!(dataDir.exists() && dataDir.isDirectory() || dataDir.mkdirs())) {
            logmon.log(BasicLevel.FATAL, "AgentServer.init(), Cannot creates storage directory: " + path);
            throw new IOException("Cannot creates storage directory: " + path);
        }
        File lockfile = new File(dataDir, "lock");
        try {
            lock = new ServerLock(lockfile);
        }
        catch (IOException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.FATAL, "AgentServer.init(): It seems that this server is already running, try to remove the lock file: " + lockfile.getCanonicalPath(), (Throwable)exc);
            } else {
                logmon.log(BasicLevel.FATAL, "AgentServer.init(): It seems that this server is already running, try to remove the lock file: " + lockfile.getCanonicalPath());
            }
            throw new IOException("Server is already running (lock file already existing)");
        }
        Status exc = status;
        synchronized (exc) {
            if (AgentServer.status.value == 6) {
                logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", reset configuration");
                AgentServer.reset();
            }
            if (AgentServer.status.value != 0) {
                throw new Exception("cannot initialize, bad status: " + AgentServer.getStatusInfo());
            }
            AgentServer.status.value = 1;
        }
        try {
            block124: {
                block123: {
                    String restoreFile;
                    block122: {
                        block121: {
                            serverId = sid;
                            tgroup = new ThreadGroup(AgentServer.getName()){

                                @Override
                                public void uncaughtException(Thread t, Throwable e) {
                                    if (e instanceof VirtualMachineError) {
                                        if (logmon.isLoggable(BasicLevel.FATAL)) {
                                            logmon.log(BasicLevel.FATAL, "Abnormal termination for " + t.getThreadGroup().getName() + "." + t.getName(), e);
                                            System.exit(-1);
                                        }
                                    } else if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                        logmon.log(BasicLevel.WARN, "Abnormal termination for " + t.getThreadGroup().getName() + "." + t.getName(), e);
                                    } else {
                                        logmon.log(BasicLevel.WARN, "Abnormal termination for " + t.getThreadGroup().getName() + "." + t.getName() + ": " + e.getMessage());
                                    }
                                }
                            };
                            File dir = new File(path);
                            if (dir.exists() && dir.isDirectory()) {
                                File tfc = new File(dir, "TFC");
                                if (tfc.exists()) {
                                    try (FilterInputStream dis = null;){
                                        dis = new DataInputStream(new FileInputStream(tfc));
                                        String tname = ((DataInputStream)dis).readUTF();
                                        transaction = (Transaction)Class.forName(tname).newInstance();
                                    }
                                    try {
                                        transaction.init(path);
                                    }
                                    catch (IOException exc2) {
                                        if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                            logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't start transaction manager", (Throwable)exc2);
                                        }
                                        throw new Exception("Can't start transaction manager: " + exc2.getMessage());
                                    }
                                }
                                logmon.log(BasicLevel.INFO, AgentServer.getName() + ", TFC file does not exist");
                            }
                            if (transaction != null) {
                                block120: {
                                    try {
                                        a3config = A3CMLConfig.load();
                                        logmon.log(BasicLevel.INFO, AgentServer.getName() + ", configuration retrieved from persistence");
                                    }
                                    catch (Exception exc3) {
                                        if (!logmon.isLoggable(BasicLevel.DEBUG)) break block120;
                                        logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", config not found in persistence");
                                    }
                                }
                                updatecfg = (ServerUpdate)transaction.load(UPDATE_CONF_TX_NAME);
                                if (updatecfg != null) {
                                    logmon.log(BasicLevel.WARN, AgentServer.getName() + ", configuration update detected: " + updatecfg.getUpdateDate());
                                    transaction.delete(UPDATE_CONF_TX_NAME);
                                }
                            } else {
                                updatecfg = new ServerUpdate();
                            }
                            if (a3config == null) {
                                try {
                                    a3config = A3CMLConfig.getConfig(DEFAULT_SER_CFG_FILE);
                                    logmon.log(BasicLevel.INFO, AgentServer.getName() + ", serialized a3cmlconfig file loaded");
                                }
                                catch (FileNotFoundException exc4) {
                                    if (!logmon.isLoggable(BasicLevel.DEBUG)) break block121;
                                    logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", serialized a3cmlconfig file not found");
                                }
                            }
                        }
                        if (a3config == null) {
                            try {
                                a3config = A3CML.getXMLConfig();
                                logmon.log(BasicLevel.INFO, AgentServer.getName() + ", XML configuration file loaded");
                            }
                            catch (FileNotFoundException exc5) {
                                if (!logmon.isLoggable(BasicLevel.DEBUG)) break block122;
                                logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", XML configuration not found");
                            }
                        }
                    }
                    if (a3config == null) {
                        boolean useDefaultConfig = Boolean.parseBoolean(System.getProperty(USE_DEFAULT_CONFIG_PROPERTY, DEFAULT_USE_DEFAULT_CONFIG));
                        if (!useDefaultConfig) {
                            throw new FileNotFoundException(AgentServer.getName() + ", no configuration found");
                        }
                        if (defaultConfig == null) {
                            logmon.log(BasicLevel.WARN, AgentServer.getName() + ", no configuration found, generates a default one");
                            AgentServer.setDefaultConfig(sid);
                        }
                        try {
                            if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                                Log.logger.log(BasicLevel.DEBUG, AgentServer.getName() + ", start AgentServer with default configuration: \n" + defaultConfig);
                            }
                            a3config = A3CML.getConfig(new StringReader(defaultConfig));
                            logmon.log(BasicLevel.INFO, AgentServer.getName() + ", use default XML configuration");
                        }
                        catch (Exception exc6) {
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.WARN, AgentServer.getName() + ", bad default XML configuration", (Throwable)exc6);
                            }
                            logmon.log(BasicLevel.WARN, AgentServer.getName() + ", bad default XML configuration: " + exc6.getMessage());
                        }
                    }
                    if (a3config == null) {
                        logmon.log(BasicLevel.WARN, AgentServer.getName() + ", generates a default configuration");
                        A3CMLDomain d = new A3CMLDomain(ADMIN_DOMAIN, SimpleNetwork.class.getName());
                        A3CMLServer s = new A3CMLServer(sid, ADMIN_SERVER, "localhost");
                        s.networks.addElement(new A3CMLNetwork(ADMIN_DOMAIN, 27300));
                        d.addServer(s);
                        a3config = new A3CMLConfig();
                        a3config.addDomain(d);
                        a3config.addServer(s);
                    }
                    AgentServer.setProperties(serverId);
                    if (AgentServer.getProperty("Transaction.UseLockFile") != null) {
                        logmon.log(BasicLevel.WARN, AgentServer.getName() + ", init(): property Transaction.UseLockFile is no longer used.");
                    }
                    if (transaction == null) {
                        try {
                            String tname = AgentServer.getProperty("Transaction", "fr.dyade.aaa.ext.NGTransaction");
                            transaction = (Transaction)Class.forName(tname).newInstance();
                        }
                        catch (Exception exc7) {
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't instantiate transaction manager", (Throwable)exc7);
                            } else {
                                logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't instantiate transaction manager: " + exc7.getMessage());
                            }
                            throw new Exception("Can't instantiate transaction manager");
                        }
                        try {
                            transaction.init(path);
                        }
                        catch (IOException exc8) {
                            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't start transaction manager", (Throwable)exc8);
                            } else {
                                logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't start transaction manager: " + exc8.getMessage());
                            }
                            throw new Exception("Can't start transaction manager");
                        }
                        restoreFile = AgentServer.getProperty(BACKUP_FILE, DEFAULT_BACKUP_FILE);
                        if (new File(restoreFile).exists()) {
                            try {
                                logmon.log(BasicLevel.WARN, AgentServer.getName() + ", server restoring from " + restoreFile);
                                AgentServer.restoreServer(restoreFile);
                                logmon.log(BasicLevel.WARN, AgentServer.getName() + ", server restored.");
                            }
                            catch (IOException exc9) {
                                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                                    logmon.log(BasicLevel.ERROR, AgentServer.getName() + ", cannot be restored from " + restoreFile, (Throwable)exc9);
                                    break block123;
                                }
                                logmon.log(BasicLevel.ERROR, AgentServer.getName() + ", cannot be restored from " + restoreFile + ": " + exc9.getMessage());
                            }
                        }
                    } else {
                        restoreFile = AgentServer.getProperty(BACKUP_FILE, DEFAULT_BACKUP_FILE);
                        if (new File(restoreFile).exists()) {
                            logmon.log(BasicLevel.WARN, AgentServer.getName() + ", cannot be restored from " + restoreFile + ", transaction already initialized.");
                        }
                    }
                }
                try {
                    MXWrapper.registerMBean((Object)transaction, (String)"AgentServer", (String)("server=" + AgentServer.getName() + ",cons=Transaction"));
                }
                catch (Exception exc10) {
                    if (logmon == null) {
                        logmon = Debug.getLogger((String)AgentServer.class.getName());
                    }
                    if (!logmon.isLoggable(BasicLevel.DEBUG)) break block124;
                    logmon.log(BasicLevel.WARN, AgentServer.getName() + " jmx failed", (Throwable)exc10);
                }
            }
            a3config.save();
            if (AgentServer.getProperty("Transaction.UseLockFile") != null) {
                logmon.log(BasicLevel.WARN, AgentServer.getName() + ", init(): property Transaction.UseLockFile is no longer used.");
            }
            try {
                AgentId.init();
            }
            catch (ClassNotFoundException exc11) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't initialize AgentId, bad classpath", (Throwable)exc11);
                } else {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't initialize AgentId, bad classpath: " + exc11.getMessage());
                }
                throw new Exception("Can't initialize AgentId, bad classpath");
            }
            catch (IOException exc12) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't initialize AgentId", (Throwable)exc12);
                } else {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't initialize AgentId: " + exc12.getMessage());
                }
                throw new Exception("Can't initialize AgentId, storage problems");
            }
            try {
                AgentServer.configure();
            }
            catch (Exception exc13) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't configure", (Throwable)exc13);
                } else {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't configure: " + exc13.getMessage());
                }
                throw new Exception("Can't configure server: " + exc13.getMessage());
            }
            try {
                String[] list = transaction.getList("@");
                Vector<MessageConsumer> toValidate = new Vector<MessageConsumer>();
                for (int i = 0; i < list.length; ++i) {
                    Message msg = Message.load(list[i]);
                    if (msg.getSource() == serverId) {
                        try {
                            MessageConsumer cons = AgentServer.getConsumer(msg.getDest());
                            cons.insert(msg);
                            if (toValidate.contains(cons)) continue;
                            toValidate.add(cons);
                        }
                        catch (UnknownServerException exc14) {
                            logmon.log(BasicLevel.ERROR, AgentServer.getName() + ", discard message to unknown server id#" + msg.getDest());
                            msg.delete();
                            msg.free();
                        }
                        catch (NullPointerException exc15) {
                            logmon.log(BasicLevel.ERROR, AgentServer.getName() + ", discard message to unknown server id#" + msg.getDest());
                            msg.delete();
                            msg.free();
                        }
                        catch (ArrayIndexOutOfBoundsException exc16) {
                            logmon.log(BasicLevel.ERROR, AgentServer.getName() + ", discard message to unknown server id#" + msg.getDest());
                            msg.delete();
                            msg.free();
                        }
                        continue;
                    }
                    logmon.log(BasicLevel.ERROR, AgentServer.getName() + ", discard undelivered message from server id#" + msg.getDest());
                    msg.delete();
                }
                for (MessageConsumer cons : toValidate) {
                    cons.validate();
                }
            }
            catch (ClassNotFoundException exc17) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't restore messages", (Throwable)exc17);
                } else {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't restore messages: " + exc17.getMessage());
                }
                throw new Exception("Can't restore messages, bad classpath");
            }
            catch (IOException exc18) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't restore messages", (Throwable)exc18);
                } else {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't restore messages: " + exc18.getMessage());
                }
                throw new Exception("Can't restore messages, storage problems");
            }
            Channel.newInstance();
            try {
                ServiceManager.init();
                logmon.log(BasicLevel.INFO, AgentServer.getName() + ", ServiceManager initialized");
                ServiceDesc[] services = AgentServer.getServices();
                if (services != null) {
                    if (updatecfg != null) {
                        logmon.log(BasicLevel.INFO, AgentServer.getName() + ", Updates ServiceManager");
                        Set<String> list = ServiceManager.listServices();
                        for (int i = 0; i < services.length; ++i) {
                            list.remove(services[i].getClassName());
                            ServiceManager.register(services[i].getClassName(), services[i].getArguments());
                        }
                        for (String scname : list) {
                            ServiceManager.unregister(scname);
                        }
                    }
                } else {
                    logmon.log(BasicLevel.WARN, AgentServer.getName() + ", no services from configuration");
                }
                ServiceManager.save();
            }
            catch (Exception exc19) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't initialize services", (Throwable)exc19);
                } else {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't initialize services: " + exc19.getMessage());
                }
                throw new Exception("Can't initialize services");
            }
            ServiceManager.loadServiceClasses();
            engine.init(new AgentEngineContextImpl());
            logmon.log(BasicLevel.INFO, AgentServer.getName() + ", initialized at " + new Date());
            transaction.begin();
            transaction.commit(true);
            try {
                SCServer bean = new SCServer();
                MXWrapper.registerMBean((Object)bean, (String)"AgentServer", (String)("server=" + AgentServer.getName()));
            }
            catch (Exception exc20) {
                if (logmon == null) {
                    logmon = Debug.getLogger((String)AgentServer.class.getName());
                }
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.WARN, AgentServer.getName() + " jmx failed", (Throwable)exc20);
                }
            }
        }
        catch (Exception exc2) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + " cannot initialize", (Throwable)exc2);
            } else {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + " cannot initialize: " + exc2.getMessage());
            }
            Status status = AgentServer.status;
            synchronized (status) {
                AgentServer.status.value = 0;
            }
            throw exc2;
        }
        catch (Throwable t) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + " cannot initialize", t);
            } else {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + " cannot initialize: " + t.getMessage());
            }
            Status status = AgentServer.status;
            synchronized (status) {
                AgentServer.status.value = 0;
            }
            throw new Exception(t.getMessage());
        }
        if ((dterr = AgentServer.getLong(CFG_CHECK_PERIOD_PROPERTY, -1L).longValue()) > 0L) {
            checkServerTask = new CheckServerTask(dterr);
        }
        Status status = AgentServer.status;
        synchronized (status) {
            AgentServer.status.value = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String start() throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", start()", (Throwable)new Exception());
        } else {
            logmon.log(BasicLevel.INFO, AgentServer.getName() + ", start()");
        }
        Status status = AgentServer.status;
        synchronized (status) {
            if (AgentServer.status.value != 2 && AgentServer.status.value != 6) {
                throw new Exception("cannot start, bad status: " + AgentServer.getStatusInfo());
            }
            AgentServer.status.value = 3;
        }
        StringBuffer errBuf = null;
        try {
            try {
                boolean exitOnServiceFailure = AgentServer.getBoolean(CFG_EXIT_ON_SERVICE_FAILURE_PROPERTY);
                ServiceManager.start(exitOnServiceFailure);
                logmon.log(BasicLevel.INFO, AgentServer.getName() + ", ServiceManager started");
            }
            catch (Exception exc) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't start services", (Throwable)exc);
                } else {
                    logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", can't start services: " + exc.getMessage());
                }
                throw new Exception("Can't start services: " + exc.getMessage());
            }
            if (consumers != null) {
                Enumeration<MessageConsumer> c = AgentServer.getConsumers();
                while (c.hasMoreElements()) {
                    MessageConsumer cons = c.nextElement();
                    if (cons == null) continue;
                    try {
                        cons.start();
                    }
                    catch (IOException exc) {
                        if (errBuf == null) {
                            errBuf = new StringBuffer();
                        }
                        errBuf.append(cons.getName()).append(": ");
                        errBuf.append(exc.getMessage()).append('\n');
                        if (logmon.isLoggable(BasicLevel.DEBUG)) {
                            logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", problem during " + cons.getName() + " starting", (Throwable)exc);
                            continue;
                        }
                        logmon.log(BasicLevel.FATAL, AgentServer.getName() + ", problem during " + cons.getName() + " starting: " + exc.getMessage());
                    }
                }
            }
            logmon.log(BasicLevel.INFO, AgentServer.getName() + ", started at " + new Date());
            transaction.begin();
            transaction.commit(true);
            if (checkServerTask != null) {
                logmon.log(BasicLevel.INFO, AgentServer.getName() + ", schedule checkServer for " + AgentServer.checkServerTask.dtwarn + "ms.");
                AgentServer.getTimer().scheduleAtFixedRate((TimerTask)checkServerTask, AgentServer.checkServerTask.dtwarn, AgentServer.checkServerTask.dtwarn);
            }
        }
        catch (Exception exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + "Cannot start", (Throwable)exc);
            } else {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + "Cannot start: " + exc.getMessage());
            }
            Status status2 = AgentServer.status;
            synchronized (status2) {
                AgentServer.status.value = 6;
            }
            throw exc;
        }
        catch (Throwable t) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + "Cannot start", t);
            } else {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + "Cannot start: " + t.getMessage());
            }
            Status status3 = AgentServer.status;
            synchronized (status3) {
                AgentServer.status.value = 6;
            }
            throw new Exception(t.getMessage());
        }
        Status status4 = AgentServer.status;
        synchronized (status4) {
            AgentServer.status.value = 4;
        }
        if (errBuf == null) {
            return null;
        }
        return errBuf.toString();
    }

    public static void stop(boolean sync) {
        AgentServer.stop(sync, 0L, false);
    }

    public static void stop(boolean sync, long delay, boolean reset) {
        ServerStopper stopper = new ServerStopper(delay, reset);
        if (sync) {
            stopper.run();
        } else {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", stop()", (Throwable)new Exception());
            }
            Thread t = new Thread((Runnable)stopper, "AgentServerStopper");
            t.setDaemon(false);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", stop()", (Throwable)new Exception());
        } else {
            logmon.log(BasicLevel.INFO, AgentServer.getName() + ", stop()");
        }
        Status status = AgentServer.status;
        synchronized (status) {
            if (AgentServer.status.value == 6 || AgentServer.status.value == 0) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, AgentServer.getName() + " not running, status: " + AgentServer.getStatusInfo(), (Throwable)new Exception());
                }
                return;
            }
            if (AgentServer.status.value != 4) {
                logmon.log(BasicLevel.WARN, AgentServer.getName() + " cannot stop, bad status: " + AgentServer.getStatusInfo());
                return;
            }
            AgentServer.status.value = 5;
        }
        try {
            int nbt;
            if (timer != null) {
                timer.cancel();
            }
            if (consumers != null) {
                Enumeration<MessageConsumer> c = AgentServer.getConsumers();
                while (c.hasMoreElements()) {
                    MessageConsumer cons = c.nextElement();
                    if (cons == null) continue;
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", stop " + cons.getName());
                    }
                    cons.stop();
                    if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                    logmon.log(BasicLevel.DEBUG, AgentServer.getName() + ", " + cons.getName() + " stopped");
                }
            }
            ServiceManager.stop();
            while ((nbt = AgentServer.getThreadGroup().activeCount()) != 0) {
                Thread[] tab = new Thread[nbt];
                AgentServer.getThreadGroup().enumerate(tab);
                if (nbt == 1 && tab[0] == Thread.currentThread()) break;
                for (int j = 0; j < tab.length; ++j) {
                    logmon.log(BasicLevel.DEBUG, "[" + tab[j].getName() + ":" + (tab[j].isAlive() ? "alive" : "-") + "/" + (tab[j].isDaemon() ? "daemon" : "-") + "," + tab[j]);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (transaction != null) {
                transaction.stop();
            }
            Runtime.getRuntime().gc();
            logmon.log(BasicLevel.INFO, AgentServer.getName() + ", stopped at " + new Date());
        }
        catch (Throwable t) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + "Cannot stop", t);
            } else {
                logmon.log(BasicLevel.ERROR, AgentServer.getName() + "Cannot stop: " + t.getMessage());
            }
            Status status2 = AgentServer.status;
            synchronized (status2) {
                AgentServer.status.value = 6;
            }
        }
        finally {
            timer = null;
        }
        Status status3 = AgentServer.status;
        synchronized (status3) {
            AgentServer.status.value = 6;
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            AgentServer.init(args);
        }
        catch (Throwable exc) {
            System.out.println(AgentServer.getName() + "initialization failed: " + ERRORSTRING);
            System.out.println(exc.toString());
            System.out.println(ENDSTRING);
            if (logmon == null) {
                logmon = Debug.getLogger((String)AgentServer.class.getName());
            }
            logmon.log(BasicLevel.ERROR, AgentServer.getName() + " initialization failed", exc);
            System.exit(1);
        }
        try {
            String errStr = AgentServer.start();
            if (errStr == null) {
                System.out.println(AgentServer.getName() + " started: " + OKSTRING);
            } else {
                System.out.println(AgentServer.getName() + " started: " + ERRORSTRING);
                System.out.print(errStr);
                System.out.println(ENDSTRING);
            }
        }
        catch (Throwable exc) {
            System.out.println(AgentServer.getName() + " start failed: " + ERRORSTRING);
            System.out.print(exc.toString());
            System.out.println(ENDSTRING);
            if (logmon == null) {
                logmon = Debug.getLogger((String)AgentServer.class.getName());
            }
            logmon.log(BasicLevel.ERROR, AgentServer.getName() + " failed", exc);
            System.exit(1);
        }
    }

    static {
        EncodableFactoryRepository.putFactory((Integer)65536, (EncodableFactory)new Message.Factory());
        updatecfg = null;
        defaultConfig = null;
        serverId = (short)-1;
        DEFAULT_CFG_DIR = null;
        checkServerTask = null;
        tgroup = null;
        engine = null;
        transaction = null;
        consumers = null;
        a3config = null;
        name = null;
        servers = null;
        status = new Status();
        lock = null;
        startDate = System.currentTimeMillis();
    }

    static class ServerStopper
    implements Runnable {
        private long delay;
        private boolean reset;

        ServerStopper(long delay, boolean reset) {
            this.delay = delay;
            this.reset = reset;
        }

        @Override
        public void run() {
            if (this.delay > 0L) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AgentServer.stop();
            if (this.reset) {
                AgentServer.reset();
            }
        }
    }

    static class ServerLock {
        private static Logger logmon = Debug.getLogger((String)AgentServer.class.getName());
        private RandomAccessFile raf;
        private FileLock lock;

        public ServerLock(File file) throws Exception {
            this.raf = new RandomAccessFile(file, "rw");
            this.lock = this.raf.getChannel().tryLock();
            if (this.lock == null) {
                throw new IOException("Cannot acquire lock.");
            }
            file.deleteOnExit();
        }

        public void close() {
            try {
                if (this.lock != null) {
                    this.lock.release();
                }
            }
            catch (IOException exc) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.WARN, "Cannot release AgentServer lock.", (Throwable)exc);
                } else {
                    logmon.log(BasicLevel.WARN, "Cannot release AgentServer lock: " + exc.getMessage());
                }
            }
            finally {
                this.lock = null;
            }
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
            }
            catch (IOException exc) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.WARN, "Cannot close AgentServer lock.", (Throwable)exc);
                } else {
                    logmon.log(BasicLevel.WARN, "Cannot close lock: " + exc.getMessage());
                }
            }
            finally {
                this.raf = null;
            }
        }
    }

    public static class Status {
        public static final int INSTALLED = 0;
        public static final int INITIALIZING = 1;
        public static final int INITIALIZED = 2;
        public static final int STARTING = 3;
        public static final int STARTED = 4;
        public static final int STOPPING = 5;
        public static final int STOPPED = 6;
        public static final int RESETING = 7;
        public static final int UPDATING = 8;
        int value = 0;
        public static String[] info = new String[]{"installed", "initializing", "initialized", "starting", "started", "stopping", "stopped", "reseting"};
    }
}

