/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.HttpNetwork;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.objectweb.util.monolog.api.BasicLevel;

public final class HttpsNetwork
extends HttpNetwork {
    public static final String PASS = "HttpsNetwork.pass";
    public static final String KEYFILE = "HttpsNetwork.keyfile";
    SSLSocketFactory socketFactory = null;
    SSLServerSocketFactory serverSocketFactory = null;

    SSLSocketFactory getSocketFactory() throws IOException {
        if (this.socketFactory == null) {
            try {
                char[] pass = AgentServer.getProperty(PASS, "changeit").toCharArray();
                String keyFile = AgentServer.getProperty(KEYFILE, ".keystore");
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(keyFile), pass);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ks);
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, tmf.getTrustManagers(), null);
                this.socketFactory = ctx.getSocketFactory();
            }
            catch (IOException exc) {
                throw exc;
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.ERROR, this.getName() + ", cannot initialize SSLSocketFactory", (Throwable)exc);
                throw new IOException(exc.getMessage());
            }
        }
        return this.socketFactory;
    }

    SSLServerSocketFactory getServerSocketFactory() throws IOException {
        if (this.serverSocketFactory == null) {
            try {
                char[] pass = AgentServer.getProperty(PASS, "changeit").toCharArray();
                String keyFile = AgentServer.getProperty(KEYFILE, ".keystore");
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(keyFile), pass);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, pass);
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(kmf.getKeyManagers(), null, null);
                this.serverSocketFactory = ctx.getServerSocketFactory();
            }
            catch (IOException exc) {
                throw exc;
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.ERROR, this.getName() + ", cannot initialize SSLServerSocketFactory", (Throwable)exc);
                throw new IOException(exc.getMessage());
            }
        }
        return this.serverSocketFactory;
    }

    @Override
    ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = this.getServerSocketFactory().createServerSocket(port, this.backlog, this.inLocalAddr);
        ((SSLServerSocket)serverSocket).setNeedClientAuth(false);
        return serverSocket;
    }

    @Override
    Socket createSocket(InetAddress addr, int port) throws IOException {
        if (addr == null) {
            throw new UnknownHostException();
        }
        return this.getSocketFactory().createSocket(addr, port, this.outLocalAddr, this.outLocalPort);
    }

    Socket createTunnelSocket(InetAddress host, int port, InetAddress proxy, int proxyport) throws IOException {
        Socket tunnel = new Socket(proxy, proxyport);
        this.doTunnelHandshake(tunnel, host, port);
        SSLSocket socket = (SSLSocket)this.getSocketFactory().createSocket(tunnel, host.getHostName(), port, true);
        socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent event) {
            }
        });
        return socket;
    }

    private void doTunnelHandshake(Socket tunnel, InetAddress host, int port) throws IOException {
        String replyStr;
        byte[] b;
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + host.getHostName() + ":" + port + " HTTP/1.0\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200")) {
            throw new IOException("Unable to tunnel , proxy returns \"" + replyStr + "\"");
        }
    }
}

