/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util.backup;

import fr.dyade.aaa.util.backup.BackupRecord;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BackupFile
extends RandomAccessFile
implements Closeable {
    private int nbRecords;

    public int getNbRecords() {
        return this.nbRecords;
    }

    public BackupFile(File file) throws IOException {
        super(file, "rw");
        this.writeInt(-1);
    }

    public synchronized void backup(BackupRecord record) throws IOException {
        ++this.nbRecords;
        if (record.dirName != null) {
            this.writeUTF(record.dirName);
        } else {
            this.write(BackupRecord.emptyUTFString);
        }
        this.writeUTF(record.name);
        this.writeInt(record.value.length);
        this.write(record.value);
    }

    @Override
    public void close() throws IOException {
        this.seek(0L);
        this.writeInt(this.nbRecords);
        super.close();
    }
}

