/*
 * Copyright (C) 2020 ScalAgent Distributed Technologies
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA.
 *
 * Initial developer(s): ScalAgent Distributed Technologies
 * Contributor(s): 
 */
package fr.dyade.aaa.util;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public abstract class WrappedConnection implements Connection {
	Connection connection;
	
	public WrappedConnection(final Connection connection) {
		this.connection = connection;
	}

	abstract Connection connection() throws SQLException;

	@Override
	public void setAutoCommit(final boolean autoCommit) throws SQLException {
		connection().setAutoCommit(autoCommit);
	}

	@Override
	public void commit() throws SQLException {
		connection().commit();
	}

	@Override
	public void close() throws SQLException {
		connection().close();
	}

	@Override
	public void rollback() throws SQLException {
		connection().rollback();
	}

	@Override
	public void setReadOnly(final boolean readOnly) throws SQLException {
		connection().setReadOnly(readOnly);
	}

	@Override
	public void abort(final Executor executor) throws SQLException {
		connection().abort(executor);
	}

	@Override
	public void setCatalog(final String catalog) throws SQLException {
		connection().setCatalog(catalog);
	}

	@Override
	public void setSchema(final String schema) throws SQLException {
		connection().setSchema(schema);
	}

	@Override
	public void setTransactionIsolation(final int level) throws SQLException {
		connection().setTransactionIsolation(level);
	}

	@Override
	public void setNetworkTimeout(final Executor executor, final int milliseconds) throws SQLException {
		connection().setNetworkTimeout(executor, milliseconds);
	}

	@Override
	public Savepoint setSavepoint() throws SQLException {
		return connection().setSavepoint();
	}

	@Override
	public Savepoint setSavepoint(final String name) throws SQLException {
		return connection().setSavepoint(name);
	}

	@Override
	public void rollback(final Savepoint savepoint) throws SQLException {
		connection().rollback();
	}

	@Override
	public void releaseSavepoint(final Savepoint savepoint) throws SQLException {
		connection().releaseSavepoint(savepoint);
	}

	@Override
	public boolean isWrapperFor(final Class<?> iface) throws SQLException {
		return connection().isWrapperFor(iface);
	}

	@Override
	public Statement createStatement() throws SQLException {
		return connection().createStatement();
	}

	@Override
	public PreparedStatement prepareStatement(final String sql) throws SQLException {
		return connection().prepareStatement(sql);
	}

	@Override
	public CallableStatement prepareCall(final String sql) throws SQLException {
		return connection().prepareCall(sql);
	}

	@Override
	public String nativeSQL(final String sql) throws SQLException {
		return connection().nativeSQL(sql);
	}

	@Override
	public boolean getAutoCommit() throws SQLException {
		return connection().getAutoCommit();
	}

	@Override
	public boolean isClosed() throws SQLException {
		return connection().isClosed();
	}

	@Override
	public DatabaseMetaData getMetaData() throws SQLException {
		return connection().getMetaData();
	}

	@Override
	public boolean isReadOnly() throws SQLException {
		return connection().isReadOnly();
	}

	@Override
	public String getCatalog() throws SQLException {
		return connection().getCatalog();
	}

	@Override
	public int getTransactionIsolation() throws SQLException {
		return connection().getTransactionIsolation();
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		return connection().getWarnings();
	}

	@Override
	public void clearWarnings() throws SQLException {
		connection().clearWarnings();
	}

	@Override
	public Statement createStatement(final int resultSetType, final int resultSetConcurrency) throws SQLException {
		return connection().createStatement(resultSetType, resultSetConcurrency);
	}

	@Override
	public PreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency)
			throws SQLException {
		return connection().prepareStatement(sql, resultSetType, resultSetConcurrency);
	}

	@Override
	public CallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency)
			throws SQLException {
		return connection().prepareCall(sql, resultSetType, resultSetConcurrency);
	}

	@Override
	public Map<String, Class<?>> getTypeMap() throws SQLException {
		return connection().getTypeMap();
	}

	@Override
	public void setTypeMap(final Map<String, Class<?>> map) throws SQLException {
		connection().setTypeMap(map);
	}

	@Override
	public void setHoldability(final int holdability) throws SQLException {
		connection().setHoldability(holdability);
	}

	@Override
	public int getHoldability() throws SQLException {
		return connection().getHoldability();
	}

	@Override
	public Statement createStatement(final int resultSetType, final int resultSetConcurrency,
			final int resultSetHoldability) throws SQLException {
		return connection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	@Override
	public PreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency,
			final int resultSetHoldability) throws SQLException {
		return connection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	@Override
	public CallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency,
			final int resultSetHoldability) throws SQLException {
		return connection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	@Override
	public PreparedStatement prepareStatement(final String sql, final int autoGeneratedKeys) throws SQLException {
		return connection().prepareStatement(sql, autoGeneratedKeys);
	}

	@Override
	public PreparedStatement prepareStatement(final String sql, final int[] columnIndexes) throws SQLException {
		return connection().prepareStatement(sql, columnIndexes);
	}

	@Override
	public PreparedStatement prepareStatement(final String sql, final String[] columnNames) throws SQLException {
		return connection().prepareStatement(sql, columnNames);
	}

	@Override
	public Clob createClob() throws SQLException {
		return connection().createClob();
	}

	@Override
	public Blob createBlob() throws SQLException {
		return connection().createBlob();
	}

	@Override
	public NClob createNClob() throws SQLException {
		return connection().createNClob();
	}

	@Override
	public SQLXML createSQLXML() throws SQLException {
		return connection().createSQLXML();
	}

	@Override
	public boolean isValid(final int timeout) throws SQLException {
		return connection().isValid(timeout);
	}

	@Override
	public void setClientInfo(final String name, final String value) throws SQLClientInfoException {
		try {
      connection().setClientInfo(name, value);
    } catch (SQLException exc) {
      throw new SQLClientInfoException();
    }
	}

	@Override
	public void setClientInfo(final Properties properties) throws SQLClientInfoException {
	  try {
	    connection().setClientInfo(properties);
    } catch (SQLException exc) {
      throw new SQLClientInfoException();
    }
	}

	@Override
	public String getClientInfo(final String name) throws SQLException {
		return connection().getClientInfo(name);
	}

	@Override
	public Properties getClientInfo() throws SQLException {
		return connection().getClientInfo();
	}

	@Override
	public Array createArrayOf(final String typeName, final Object[] elements) throws SQLException {
		return connection().createArrayOf(typeName, elements);
	}

	@Override
	public Struct createStruct(final String typeName, final Object[] attributes) throws SQLException {
		return connection().createStruct(typeName, attributes);
	}

	@Override
	public String getSchema() throws SQLException {
		return connection().getSchema();
	}

	@Override
	public int getNetworkTimeout() throws SQLException {
		return connection().getNetworkTimeout();
	}

	@Override
	public <T> T unwrap(final Class<T> iface) throws SQLException {
		return connection().unwrap(iface);
	}
}