/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentEngine;
import fr.dyade.aaa.agent.AgentEngineContext;
import fr.dyade.aaa.agent.AgentFactory;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.CallbackNotification;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.EngineMBean;
import fr.dyade.aaa.agent.EngineThread;
import fr.dyade.aaa.agent.ExceptionNotification;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.MessageQueue;
import fr.dyade.aaa.agent.MessageVector;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownAgentException;
import fr.dyade.aaa.common.AverageCPUTask;
import fr.dyade.aaa.common.AverageLoadTask;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.Queue;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

class Engine
implements Runnable,
AgentEngine,
EngineMBean {
    protected MessageQueue qin;
    protected volatile boolean isRunning;
    protected volatile boolean canStop;
    private int stamp;
    private byte[] stampBuf = null;
    private boolean modified = false;
    Hashtable<AgentId, Agent> agents;
    long now = 0L;
    int NbMaxAgents = 1000;
    boolean noTxIfTransient;
    Vector<AgentId> fixedAgentIdList = null;
    Agent agent = null;
    Message msg = null;
    EngineThread thread = null;
    static final int RP_EXC_NOT = 0;
    static final int RP_EXIT = 1;
    static final String[] rpStrings = new String[]{"notification", "exit"};
    int recoveryPolicy = 1;
    private String name;
    protected Queue mq;
    private boolean persistentPush;
    protected Logger logmon = null;
    protected boolean needToBeCommited = false;
    protected long timeout = Long.MAX_VALUE;
    public boolean agentProfiling = false;
    private long reactTime = 0L;
    private long commitTime;
    long workInProgress = 0L;
    AverageCPUTask averageCPUTask = null;
    EngineAverageLoadTask averageLoadTask = null;

    @Override
    public long getNbReactions() {
        return this.now;
    }

    @Override
    public int getNbMaxAgents() {
        return this.NbMaxAgents;
    }

    @Override
    public void setNbMaxAgents(int NbMaxAgents) {
        this.NbMaxAgents = NbMaxAgents;
    }

    @Override
    public int getNbAgents() {
        return this.agents.size();
    }

    @Override
    public int getNbMessages() {
        return this.stamp;
    }

    @Override
    public int getNbWaitingMessages() {
        return this.qin.size();
    }

    @Override
    public int getNbFixedAgents() {
        return this.fixedAgentIdList.size();
    }

    @Override
    public boolean isNoTxIfTransient() {
        return this.noTxIfTransient;
    }

    @Override
    public String getRunningAgent() {
        Agent ag = this.agent;
        if (ag != null) {
            return ag.getAgentId();
        }
        return null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDomainName() {
        return "engine";
    }

    static Engine newInstance() throws Exception {
        String cname = "fr.dyade.aaa.agent.Engine";
        cname = AgentServer.getProperty("Engine", cname);
        Class<?> eclass = Class.forName(cname);
        return (Engine)eclass.newInstance();
    }

    @Override
    public final void push(AgentId from, AgentId to, Notification not) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", push(" + from + ", " + to + ", " + not + ")");
        }
        if (to == null || to.isNullId()) {
            return;
        }
        if (not.persistent) {
            this.persistentPush = true;
        }
        this.mq.push((Object)Message.alloc(from, to, not));
    }

    @Override
    public final void push(AgentId to, Notification not) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", push(" + to + ", " + not + ")");
        }
        if (Thread.currentThread() == this.thread) {
            this.push(this.agent.getId(), to, not);
        } else {
            Channel.channel.directSendTo(AgentId.localId, to, not);
        }
    }

    final void dispatch() throws Exception {
        Message msg = null;
        while (!this.mq.isEmpty()) {
            try {
                msg = (Message)this.mq.get();
            }
            catch (InterruptedException exc) {
                continue;
            }
            if (msg.from == null) {
                msg.from = AgentId.localId;
            }
            Channel.post(msg);
            this.mq.pop();
        }
        Channel.save();
    }

    final void clean() {
        this.mq.clear();
    }

    protected Engine() throws Exception {
        this.name = "Engine#" + AgentServer.getServerId();
        this.logmon = Debug.getLogger((String)(Engine.class.getName() + ".#" + AgentServer.getServerId()));
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.getName() + " created [" + this.getClass().getName() + "].");
        }
        this.NbMaxAgents = AgentServer.getInteger("NbMaxAgents", this.NbMaxAgents);
        this.qin = new MessageVector(this.name, AgentServer.getTransaction().isPersistent());
        this.mq = new Queue();
        this.agentProfiling = AgentServer.getBoolean("AgentProfiling");
        String noTxIfTransientValue = AgentServer.getProperty("NoTxIfTransient");
        this.noTxIfTransient = noTxIfTransientValue != null ? Boolean.parseBoolean(noTxIfTransientValue) : true;
        this.isRunning = false;
        this.canStop = false;
        this.thread = null;
        this.needToBeCommited = false;
        this.restore();
        if (this.modified) {
            this.save();
        }
    }

    @Override
    public void init(AgentEngineContext agentEngineContext) throws Exception {
        this.agents = new Hashtable();
        try {
            this.fixedAgentIdList = (Vector)AgentServer.getTransaction().load(this.getName() + ".fixed");
            if (this.fixedAgentIdList == null) {
                this.fixedAgentIdList = new Vector();
                AgentFactory factory = new AgentFactory(AgentId.factoryId);
                this.createAgent(AgentId.factoryId, factory);
                factory.save();
                this.logmon.log(BasicLevel.INFO, this.getName() + ", factory created");
            }
            int i = 0;
            while (i < this.fixedAgentIdList.size()) {
                try {
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", loads fixed agent" + this.fixedAgentIdList.elementAt(i));
                    }
                    this.load(this.fixedAgentIdList.elementAt(i));
                    ++i;
                }
                catch (Exception exc) {
                    this.logmon.log(BasicLevel.ERROR, this.getName() + ", can't restore fixed agent" + this.fixedAgentIdList.elementAt(i), (Throwable)exc);
                    this.fixedAgentIdList.removeElementAt(i);
                }
            }
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.ERROR, this.getName() + ", can't initialize", (Throwable)exc);
            throw exc;
        }
        this.averageLoadTask = new EngineAverageLoadTask(AgentServer.getTimer());
        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", ends");
        Agent[] ag = new Agent[this.agents.size()];
        int i = 0;
        Enumeration<Agent> e = this.agents.elements();
        while (e.hasMoreElements()) {
            ag[i++] = e.nextElement();
        }
        --i;
        while (i >= 0) {
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, "Agent" + ag[i].id + " [" + ag[i].name + "] garbaged");
            }
            this.agents.remove(ag[i].id);
            try {
                this.agent = ag[i];
                ag[i].agentFinalize(false);
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.ERROR, "Agent" + ag[i].id + " [" + ag[i].name + "] error during agentFinalize", (Throwable)exc);
            }
            finally {
                this.agent = null;
            }
            ag[i] = null;
            --i;
        }
    }

    @Override
    public final void createAgent(AgentId id, Agent agent) throws Exception {
        agent.id = id;
        agent.deployed = true;
        agent.agentInitialize(true);
        this.createAgent(agent);
    }

    final void createAgent(Agent agent) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", creates: " + agent);
        }
        if (agent.isFixed()) {
            this.addFixedAgentId(agent.getId());
        }
        if (agent.logmon == null) {
            agent.logmon = Debug.getLogger((String)Agent.class.getName());
        }
        agent.save();
        ++this.now;
        this.garbage();
        this.agents.put(agent.getId(), agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAgent(AgentId id) throws Exception {
        Agent ag;
        Agent old = this.agent;
        try {
            ag = this.load(id);
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", delete Agent" + ag.id + " [" + ag.name + "]");
            }
            AgentServer.getTransaction().delete(ag.id.toString());
        }
        catch (UnknownAgentException exc) {
            this.logmon.log(BasicLevel.ERROR, this.getName() + ", can't delete unknown Agent" + id);
            throw new Exception("Can't delete unknown Agent" + id);
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, this.getName() + ", can't delete Agent" + id, (Throwable)exc);
            throw new Exception("Can't delete Agent" + id);
        }
        if (ag.isFixed()) {
            this.removeFixedAgentId(ag.id);
        }
        this.agents.remove(ag.getId());
        try {
            this.agent = ag;
            ag.agentFinalize(true);
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.ERROR, "Agent" + ag.id + " [" + ag.name + "] error during agentFinalize", (Throwable)exc);
        }
        finally {
            this.agent = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void garbage() {
        if (!AgentServer.getTransaction().isPersistent()) {
            return;
        }
        if (this.agents.size() < this.NbMaxAgents + this.fixedAgentIdList.size()) {
            return;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", garbage: " + this.agents.size() + '/' + this.NbMaxAgents + '+' + this.fixedAgentIdList.size() + ' ' + this.now);
        }
        long deadline = this.now - (long)this.NbMaxAgents;
        Agent[] ag = new Agent[this.agents.size()];
        int i = 0;
        Enumeration<Agent> e = this.agents.elements();
        while (e.hasMoreElements()) {
            ag[i++] = e.nextElement();
        }
        Agent old = this.agent;
        try {
            --i;
            while (i >= 0) {
                if (ag[i].last <= deadline && !ag[i].fixed) {
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, "Agent" + ag[i].id + " [" + ag[i].name + "] garbaged");
                    }
                    this.agents.remove(ag[i].id);
                    try {
                        this.agent = ag[i];
                        ag[i].agentFinalize(false);
                        this.agent = old;
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, "Agent" + ag[i].id + " [" + ag[i].name + "] error during agentFinalize", (Throwable)exc);
                    }
                    ag[i] = null;
                }
                --i;
            }
        }
        finally {
            this.agent = old;
        }
        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", garbage: " + this.agents.size());
    }

    void removeFixedAgentId(AgentId id) throws IOException {
        this.fixedAgentIdList.removeElement(id);
        AgentServer.getTransaction().save(this.fixedAgentIdList, this.getName() + ".fixed");
    }

    void addFixedAgentId(AgentId id) throws IOException {
        this.fixedAgentIdList.addElement(id);
        AgentServer.getTransaction().save(this.fixedAgentIdList, this.getName() + ".fixed");
    }

    AgentId[] getLoadedAgentIdlist() {
        AgentId[] list = new AgentId[this.agents.size()];
        int i = 0;
        Enumeration<Agent> e = this.agents.elements();
        while (e.hasMoreElements()) {
            list[i++] = e.nextElement().id;
        }
        return list;
    }

    @Override
    public String dumpAgent(String id) throws Exception {
        return this.dumpAgent(AgentId.fromString(id));
    }

    @Override
    public String dumpAgent(AgentId id) throws IOException, ClassNotFoundException {
        Agent ag = this.agents.get(id);
        if (ag == null && (ag = Agent.load(id)) == null) {
            return id.toString() + " unknown";
        }
        return ag.toString();
    }

    final Agent load(AgentId id) throws IOException, ClassNotFoundException, Exception {
        ++this.now;
        Agent ag = this.agents.get(id);
        if (ag == null) {
            ag = this.reload(id);
            this.garbage();
        }
        ag.last = this.now;
        return ag;
    }

    final Agent reload(AgentId id) throws IOException, ClassNotFoundException, Exception {
        Agent ag = null;
        ag = Agent.load(id);
        if (ag != null) {
            Agent old = this.agent;
            try {
                this.agent = ag;
                ag.agentInitialize(false);
            }
            catch (Throwable exc) {
                this.logmon.log(BasicLevel.ERROR, this.getName() + "Can't initialize Agent" + ag.id + " [" + ag.name + "]", exc);
                throw new Exception(this.getName() + "Can't initialize Agent" + ag.id);
            }
            finally {
                this.agent = old;
            }
            if (ag.logmon == null) {
                ag.logmon = Debug.getLogger((String)(Agent.class.getName() + ".#" + AgentServer.getServerId()));
            }
            this.agents.put(ag.id, ag);
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, this.getName() + "Agent" + ag.id + " [" + ag.name + "] loaded");
            }
        } else {
            throw new UnknownAgentException(null, id);
        }
        return ag;
    }

    @Override
    public void insert(Message msg) {
        this.qin.insert(msg, this);
    }

    @Override
    public void validate() {
        this.qin.validate();
    }

    @Override
    public void start() {
        if (this.isRunning) {
            return;
        }
        this.thread = new EngineThread(this);
        int priority = AgentServer.getInteger("Engine.threadPriority", 10);
        this.thread.setPriority(priority);
        this.thread.setDaemon(false);
        this.logmon.log(BasicLevel.DEBUG, this.getName() + " starting.");
        String rp = AgentServer.getProperty("Engine.recoveryPolicy");
        if (rp != null) {
            int i = rpStrings.length;
            while (i-- > 0) {
                if (!rp.equals(rpStrings[i])) continue;
                this.recoveryPolicy = i;
                break;
            }
        }
        this.isRunning = true;
        this.canStop = true;
        this.thread.start();
        this.logmon.log(BasicLevel.DEBUG, this.getName() + " started.");
    }

    @Override
    public void stop() {
        this.logmon.log(BasicLevel.DEBUG, this.getName() + ", stops.");
        this.isRunning = false;
        if (this.thread != null) {
            while (this.thread.isAlive()) {
                if (this.canStop && this.thread.isAlive()) {
                    this.thread.interrupt();
                }
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException exc) {}
            }
            this.thread = null;
        }
    }

    @Override
    public MessageQueue getQueue() {
        return this.qin;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void save() throws IOException {
        if (this.modified) {
            this.stampBuf[0] = (byte)(this.stamp >>> 24 & 0xFF);
            this.stampBuf[1] = (byte)(this.stamp >>> 16 & 0xFF);
            this.stampBuf[2] = (byte)(this.stamp >>> 8 & 0xFF);
            this.stampBuf[3] = (byte)(this.stamp & 0xFF);
            AgentServer.getTransaction().saveByteArray(this.stampBuf, this.getName());
            this.modified = false;
        }
    }

    @Override
    public void restore() throws Exception {
        this.stampBuf = AgentServer.getTransaction().loadByteArray(this.getName());
        if (this.stampBuf == null) {
            this.stamp = 0;
            this.stampBuf = new byte[4];
            this.modified = true;
        } else {
            this.stamp = ((this.stampBuf[0] & 0xFF) << 24) + ((this.stampBuf[1] & 0xFF) << 16) + ((this.stampBuf[2] & 0xFF) << 8) + (this.stampBuf[3] & 0xFF);
            this.modified = false;
        }
    }

    @Override
    public void delete() throws IllegalStateException {
        throw new IllegalStateException();
    }

    private final int getStamp() {
        return this.stamp;
    }

    protected final void stamp(Message msg) {
        if (msg.isPersistent()) {
            this.modified = true;
        }
        msg.source = AgentServer.getServerId();
        msg.dest = AgentServer.getServerId();
        msg.stamp = ++this.stamp;
        if (this.stamp == Integer.MAX_VALUE) {
            this.stamp = 0;
        }
    }

    @Override
    public boolean isPrior(Message m1, Message m2) {
        if (m1.getStamp() <= this.stamp && m2.getStamp() <= this.stamp || m1.getStamp() > this.stamp && m2.getStamp() > this.stamp) {
            return m1.getStamp() < m2.getStamp();
        }
        return m1.getStamp() > this.stamp && m2.getStamp() <= this.stamp;
    }

    @Override
    public void post(Message msg) throws Exception {
        this.stamp(msg);
        msg.save();
        this.qin.push(msg);
    }

    @Override
    public void postAndValidate(Message msg) throws Exception {
        this.stamp(msg);
        msg.save();
        this.qin.pushAndValidate(msg);
    }

    @Override
    public boolean isAgentProfiling() {
        return this.agentProfiling;
    }

    @Override
    public void setAgentProfiling(boolean agentProfiling) {
        this.agentProfiling = agentProfiling;
    }

    @Override
    public long getReactTime() {
        return this.reactTime;
    }

    @Override
    public void resetReactTime() {
        this.reactTime = 0L;
    }

    @Override
    public long getCommitTime() {
        return this.commitTime;
    }

    @Override
    public void resetCommitTime() {
        this.commitTime = 0L;
    }

    @Override
    public void resetTimer() {
        this.resetReactTime();
        this.resetCommitTime();
    }

    protected void onTimeOut() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long start = 0L;
            long end = 0L;
            boolean profiling = false;
            this.averageCPUTask = new AverageCPUTask(Thread.currentThread().getId(), 12);
            this.averageCPUTask.start(AgentServer.getTimer());
            block15: while (this.isRunning) {
                CallbackNotification callbackNotification;
                block32: {
                    block31: {
                        this.agent = null;
                        this.canStop = true;
                        try {
                            this.msg = this.qin.get(this.timeout);
                            if (this.msg == null) {
                                this.onTimeOut();
                            }
                        }
                        catch (InterruptedException exc) {}
                        continue;
                        this.canStop = false;
                        if (!this.isRunning) {
                            break;
                        }
                        this.incWorkInProgress();
                        if (this.msg.from == null || this.msg.to == null || this.msg.not == null) {
                            this.logmon.log(BasicLevel.ERROR, AgentServer.getName() + ": Bad message [" + this.msg.from + ", " + this.msg.to + ", " + this.msg.not + ']');
                            this.qin.pop();
                            this.msg.delete();
                            this.msg.free();
                            continue;
                        }
                        callbackNotification = this.msg.getNot() instanceof CallbackNotification ? (CallbackNotification)this.msg.getNot() : null;
                        if (this.msg.not.expiration <= 0L || this.msg.not.expiration >= System.currentTimeMillis()) {
                            try {
                                this.agent = this.load(this.msg.to);
                                break block31;
                            }
                            catch (UnknownAgentException exc) {
                                this.logmon.log(BasicLevel.ERROR, this.getName() + ": Unknown agent, " + this.msg.to + ".react(" + this.msg.from + ", " + this.msg.not + ")");
                                this.agent = null;
                                if (callbackNotification != null) {
                                    callbackNotification.failed(exc);
                                }
                                this.push(AgentId.localId, this.msg.from, new UnknownAgent(this.msg.to, this.msg.not));
                                break block31;
                            }
                            catch (Exception exc) {
                                this.logmon.log(BasicLevel.ERROR, this.getName() + ": Can't load agent, " + this.msg.to + ".react(" + this.msg.from + ", " + this.msg.not + ")", (Throwable)exc);
                                this.agent = null;
                                AgentServer.stop(false);
                                break;
                            }
                        }
                        if (this.msg.not.deadNotificationAgentId != null) {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, this.getName() + ": forward expired notification " + this.msg.from + ", " + this.msg.not + " to " + this.msg.not.deadNotificationAgentId);
                            }
                            ExpiredNot expiredNot = new ExpiredNot(this.msg.not, this.msg.from, this.msg.to);
                            this.push(AgentId.localId, this.msg.not.deadNotificationAgentId, expiredNot);
                        } else if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ": removes expired notification " + this.msg.from + ", " + this.msg.not);
                        }
                    }
                    if (this.agent != null) {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ": " + this.agent + ".react(" + this.msg.from + ", " + this.msg.getStamp() + ", " + this.msg.not + ")");
                        }
                        boolean bl = profiling = this.agentProfiling || this.agent.agentProfiling;
                        if (profiling) {
                            start = System.nanoTime();
                        }
                        boolean bl2 = profiling = this.agentProfiling || this.agent.agentProfiling;
                        if (profiling) {
                            start = System.nanoTime();
                        }
                        try {
                            this.agent.react(this.msg.from, this.msg.not);
                            ++this.agent.reactNb;
                            if (!profiling) break block32;
                            end = System.nanoTime();
                            this.agent.reactTime += end - start;
                            this.reactTime += end - start;
                            start = end;
                        }
                        catch (Exception exc) {
                            this.logmon.log(BasicLevel.ERROR, this.getName() + ": Uncaught exception during react, " + this.agent + ".react(" + this.msg.from + ", " + this.msg.not + ")", (Throwable)exc);
                            switch (this.recoveryPolicy) {
                                default: {
                                    this.abort(exc);
                                    if (callbackNotification == null) continue block15;
                                    callbackNotification.failed(exc);
                                    continue block15;
                                }
                                case 1: 
                            }
                            AgentServer.stop(false);
                            break;
                        }
                    }
                }
                this.commit();
                if (callbackNotification != null) {
                    callbackNotification.done();
                }
                if (!profiling || this.agent == null) continue;
                end = System.nanoTime();
                this.agent.commitTime += end - start;
                this.commitTime += end - start;
            }
        }
        catch (Throwable exc) {
            this.logmon.log(BasicLevel.FATAL, this.getName() + ": Transaction problem", exc);
            this.canStop = false;
            AgentServer.stop(false);
        }
        finally {
            this.terminate();
            this.logmon.log(BasicLevel.DEBUG, this.getName() + " stopped.");
        }
    }

    void commit() throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.getName() + ": commit()");
        }
        if (this.agent != null) {
            this.agent.save();
        }
        if (this.noTxIfTransient && !this.msg.not.persistent && !this.persistentPush && !AgentServer.getTransaction().containsOperations()) {
            this.qin.pop();
            this.msg.delete();
            this.msg.free();
            Message msgToDispatch = null;
            while (!this.mq.isEmpty()) {
                try {
                    msgToDispatch = (Message)this.mq.get();
                }
                catch (InterruptedException exc) {
                    continue;
                }
                if (msgToDispatch.from == null) {
                    msgToDispatch.from = AgentId.localId;
                }
                MessageConsumer cons = AgentServer.getConsumer(msgToDispatch.to.getTo());
                cons.postAndValidate(msgToDispatch);
                this.mq.pop();
            }
        } else {
            AgentServer.getTransaction().begin();
            this.qin.pop();
            this.msg.delete();
            this.msg.free();
            this.dispatch();
            AgentServer.getTransaction().commit(false);
            Channel.validate();
            AgentServer.getTransaction().release();
        }
        this.persistentPush = false;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, this.getName() + ": commited");
        }
    }

    void abort(Exception exc) throws Exception {
        AgentServer.getTransaction().begin();
        try {
            this.agent = this.reload(this.msg.to);
        }
        catch (Exception exc2) {
            this.logmon.log(BasicLevel.ERROR, this.getName() + ", can't reload Agent" + this.msg.to, (Throwable)exc2);
            throw new Exception("Can't reload Agent" + this.msg.to);
        }
        this.qin.pop();
        this.msg.delete();
        this.msg.free();
        this.clean();
        this.push(AgentId.localId, this.msg.from, new ExceptionNotification(this.msg.to, this.msg.not, exc));
        this.dispatch();
        AgentServer.getTransaction().commit(false);
        Channel.validate();
        AgentServer.getTransaction().release();
    }

    @Override
    public final long getWorkInProgress() {
        return this.workInProgress;
    }

    @Override
    public final void incWorkInProgress() {
        ++this.workInProgress;
    }

    @Override
    public final int getAverageCPU() {
        if (this.averageCPUTask != null) {
            return this.averageCPUTask.getAverage();
        }
        return 0;
    }

    @Override
    public final void resetAverageLoad() {
        if (this.averageLoadTask != null) {
            this.averageLoadTask.reset();
        }
    }

    @Override
    public final float getAverageLoad1() {
        return this.averageLoadTask.getAverageLoad1();
    }

    @Override
    public final float getAverageLoad5() {
        return this.averageLoadTask.getAverageLoad5();
    }

    @Override
    public final float getAverageLoad15() {
        return this.averageLoadTask.getAverageLoad15();
    }

    @Override
    public String report() {
        return this.qin.report();
    }

    @Override
    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",name=").append(this.getName());
        strbuf.append(",running=").append(this.isRunning());
        strbuf.append(",agent=").append(this.agent).append(')');
        return strbuf.toString();
    }

    @Override
    public boolean isEngineThread() {
        return Thread.currentThread() == this.thread;
    }

    class EngineAverageLoadTask
    extends AverageLoadTask {
        public EngineAverageLoadTask(Timer timer) {
            this.start(timer);
        }

        protected long countActiveTasks() {
            return AgentServer.engine.getNbWaitingMessages();
        }
    }
}

