/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encodable;
import fr.dyade.aaa.common.encoding.EncodableFactory;
import fr.dyade.aaa.common.encoding.EncodableFactoryRepository;
import fr.dyade.aaa.common.encoding.Encoder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Notification
implements Serializable,
Cloneable,
Encodable {
    static final long serialVersionUID = 1L;
    protected transient boolean persistent = true;
    protected transient boolean detachable = false;
    protected transient boolean detached = false;
    long expiration = 0L;
    int priority = 4;
    AgentId deadNotificationAgentId = null;
    transient String messageId = null;
    private Object context;
    private static final byte ExpirationSet = 16;
    private static final byte ContextSet = 32;
    private static final byte DeadNotificationAgentIdSet = 64;

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setPriority(int priority) {
        if (priority >= 0 && priority <= 9) {
            this.priority = (byte)priority;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public final void setContext(Object context) {
        this.context = context;
    }

    public final Object getContext() {
        return this.context;
    }

    public synchronized Object clone() {
        try {
            Notification dup = (Notification)super.clone();
            dup.detached = false;
            dup.messageId = null;
            return dup;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public AgentId getDeadNotificationAgentId() {
        return this.deadNotificationAgentId;
    }

    public void setDeadNotificationAgentId(AgentId deadNotificationAgentId) {
        this.deadNotificationAgentId = deadNotificationAgentId;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.priority & 0xF | (this.expiration > 0L ? 16 : 0) | (this.context != null ? 32 : 0) | (this.deadNotificationAgentId != null ? 64 : 0));
        if (this.expiration > 0L) {
            out.writeLong(this.expiration);
        }
        if (this.context != null) {
            out.writeObject(this.context);
        }
        if (this.deadNotificationAgentId != null) {
            out.writeObject(this.deadNotificationAgentId);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte tmp = in.readByte();
        this.priority = tmp & 0xF;
        if ((tmp & 0x10) != 0) {
            this.expiration = in.readLong();
        }
        if ((tmp & 0x20) != 0) {
            this.context = in.readObject();
        }
        if ((tmp & 0x40) != 0) {
            this.deadNotificationAgentId = (AgentId)in.readObject();
        }
    }

    public StringBuffer toString(StringBuffer output) {
        output.append('(');
        output.append(super.toString());
        output.append(",messageId=").append(this.messageId);
        output.append(",persistent=").append(this.persistent);
        output.append(",detachable=").append(this.detachable);
        output.append(",detached=").append(this.detached);
        output.append(",context=").append(this.context);
        output.append(",expiration=").append(this.expiration);
        output.append(",priority=").append(this.priority);
        output.append(",deadNotificationAgentId=").append(this.deadNotificationAgentId);
        output.append(')');
        return output;
    }

    public final String toString() {
        StringBuffer output = new StringBuffer();
        return this.toString(output).toString();
    }

    public int getEncodableClassId() {
        return -1;
    }

    public int getEncodedSize() throws Exception {
        int encodedSize = 1;
        if (this.expiration > 0L) {
            encodedSize += 8;
        }
        if (this.context != null) {
            if (this.context instanceof Encodable) {
                encodedSize += 4;
                encodedSize += ((Encodable)this.context).getEncodedSize();
            } else {
                throw new Exception("Context is not Encodable");
            }
        }
        if (this.deadNotificationAgentId != null) {
            encodedSize += this.deadNotificationAgentId.getEncodedSize();
        }
        return encodedSize;
    }

    public void encode(Encoder encoder) throws Exception {
        encoder.encodeByte((byte)(this.priority & 0xF | (this.expiration > 0L ? 16 : 0) | (this.context != null ? 32 : 0) | (this.deadNotificationAgentId != null ? 64 : 0)));
        if (this.expiration > 0L) {
            encoder.encodeUnsignedLong(this.expiration);
        }
        if (this.context != null) {
            if (this.context instanceof Encodable) {
                Encodable encodable = (Encodable)this.context;
                encoder.encodeUnsignedInt(encodable.getEncodableClassId());
                encodable.encode(encoder);
            } else {
                throw new Exception("Context is not Encodable");
            }
        }
        if (this.deadNotificationAgentId != null) {
            this.deadNotificationAgentId.encode(encoder);
        }
    }

    public void decode(Decoder decoder) throws Exception {
        byte tmp = decoder.decodeByte();
        this.priority = tmp & 0xF;
        if ((tmp & 0x10) != 0) {
            this.expiration = decoder.decodeUnsignedLong();
        }
        if ((tmp & 0x20) != 0) {
            int classId = decoder.decodeUnsignedInt();
            EncodableFactory factory = EncodableFactoryRepository.getFactory((Integer)classId);
            Encodable encodable = factory.createEncodable();
            encodable.decode(decoder);
            this.context = encodable;
        }
        if ((tmp & 0x40) != 0) {
            this.deadNotificationAgentId = new AgentId();
            this.deadNotificationAgentId.decode(decoder);
        }
    }
}

