/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.conf;

import fr.dyade.aaa.agent.conf.A3CMLNat;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLService;
import fr.dyade.aaa.agent.conf.UnknownServiceException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class A3CMLServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public short sid = (short)-1;
    public String name = null;
    public String hostname = null;
    public String domain = null;
    public int port = -1;
    public Hashtable<Short, A3CMLNat> nat = null;
    public Vector<A3CMLNetwork> networks = null;
    public Vector<A3CMLService> services = null;
    public String jvmArgs = null;
    public Hashtable<String, A3CMLProperty> properties = null;
    public boolean visited = false;
    public short gateway = (short)-1;
    public int hops = -1;

    public A3CMLServer(short sid, String name, String hostname) throws Exception {
        this.sid = sid;
        this.name = name == null || name.length() == 0 ? "server" + sid : name;
        this.hostname = hostname;
        this.services = new Vector();
        this.networks = new Vector();
    }

    public void addNetwork(A3CMLNetwork newNetwork) throws Exception {
        for (int i = 0; i < this.networks.size(); ++i) {
            A3CMLNetwork network = this.networks.elementAt(i);
            if (!network.domain.equals(newNetwork.domain)) continue;
            throw new Exception("Network " + newNetwork.domain + " already exist.");
        }
        this.networks.addElement(newNetwork);
    }

    public void removeNetwork(String domainName) {
        for (int i = 0; i < this.networks.size(); ++i) {
            A3CMLNetwork network = this.networks.elementAt(i);
            if (!network.domain.equals(domainName)) continue;
            this.networks.removeElementAt(i);
        }
    }

    public void addService(A3CMLService newService) throws Exception {
        for (int i = 0; i < this.services.size(); ++i) {
            A3CMLService service = this.services.elementAt(i);
            if (!service.classname.equals(newService.classname)) continue;
            throw new Exception("Service " + newService.classname + " already exist.");
        }
        this.services.addElement(newService);
    }

    public void removeService(String serviceClassName) {
        for (int i = 0; i < this.services.size(); ++i) {
            A3CMLService service = this.services.elementAt(i);
            if (!service.classname.equals(serviceClassName)) continue;
            this.services.removeElementAt(i);
        }
    }

    public A3CMLProperty addProperty(A3CMLProperty prop) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties.put(prop.name, prop);
    }

    public A3CMLProperty getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public A3CMLProperty removeProperty(String name) {
        if (this.properties != null) {
            return this.properties.remove(name);
        }
        return null;
    }

    public boolean containsProperty(String name) {
        if (this.properties != null) {
            return this.properties.containsKey(name);
        }
        return false;
    }

    public A3CMLNat addNat(A3CMLNat natElement) {
        if (this.nat == null) {
            this.nat = new Hashtable();
        }
        return this.nat.put(natElement.sid, natElement);
    }

    public A3CMLNat getNat(short sid) {
        if (this.nat == null) {
            return null;
        }
        return this.nat.get(sid);
    }

    public A3CMLNat removeNat(short sid) {
        if (this.nat != null) {
            return this.nat.remove(sid);
        }
        return null;
    }

    public boolean containsNat(short sid) {
        if (this.nat != null) {
            return this.nat.containsKey(sid);
        }
        return false;
    }

    public final String getJvmArgs() {
        if (this.jvmArgs != null) {
            return this.jvmArgs;
        }
        return "";
    }

    public final A3CMLService getService(String classname) throws UnknownServiceException {
        if (this.services != null) {
            for (int i = this.services.size() - 1; i >= 0; --i) {
                A3CMLService service = this.services.elementAt(i);
                if (!service.classname.equals(classname)) continue;
                return service;
            }
        }
        throw new UnknownServiceException("Unknown service \"" + classname + "\" on server#" + this.sid);
    }

    public final String getServiceArgs(String classname) throws UnknownServiceException {
        if (this.services != null) {
            for (int i = this.services.size() - 1; i >= 0; --i) {
                A3CMLService service = this.services.elementAt(i);
                if (!service.classname.equals(classname)) continue;
                return service.args;
            }
        }
        throw new UnknownServiceException("Unknown service \"" + classname + "\" on server#" + this.sid);
    }

    public A3CMLNetwork getNetwork(String domainName) {
        for (int i = this.networks.size() - 1; i >= 0; --i) {
            A3CMLNetwork nw = this.networks.elementAt(i);
            if (!nw.domain.equals(domainName)) continue;
            return nw;
        }
        return null;
    }

    public A3CMLServer duplicate(Hashtable<Short, A3CMLServer> context) throws Exception {
        A3CMLServer clone = null;
        Short serverSid = this.sid;
        if (!context.containsKey(serverSid)) {
            clone = this.duplicate();
            context.put(serverSid, clone);
        } else {
            clone = context.get(serverSid);
        }
        return clone;
    }

    public A3CMLServer duplicate() throws Exception {
        Enumeration<Object> e;
        A3CMLServer clone = new A3CMLServer(this.sid, this.name, this.hostname);
        if (this.networks != null) {
            Enumeration<A3CMLNetwork> n = this.networks.elements();
            while (n.hasMoreElements()) {
                clone.networks.addElement(n.nextElement().duplicate());
            }
        }
        clone.gateway = this.gateway;
        clone.domain = this.domain;
        clone.port = this.port;
        clone.visited = this.visited;
        if (this.services != null) {
            e = this.services.elements();
            while (e.hasMoreElements()) {
                clone.services.addElement(((A3CMLService)e.nextElement()).duplicate());
            }
        }
        if (this.properties != null) {
            e = this.properties.keys();
            while (e.hasMoreElements()) {
                String pName = (String)e.nextElement();
                A3CMLProperty prop = this.properties.get(pName);
                if (prop == null) continue;
                if (clone.properties == null) {
                    clone.properties = new Hashtable();
                }
                clone.properties.put(pName, prop.duplicate());
            }
        }
        if (this.nat != null) {
            e = this.nat.elements();
            while (e.hasMoreElements()) {
                clone.addNat(((A3CMLNat)e.nextElement()).duplicate());
            }
        }
        clone.jvmArgs = this.jvmArgs;
        return clone;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(");
        strBuf.append(super.toString());
        strBuf.append(",name=").append(this.name);
        strBuf.append(",sid=").append(this.sid);
        strBuf.append(",hostname=").append(this.hostname);
        strBuf.append(",port=").append(this.port);
        strBuf.append(",domain=").append(this.domain);
        strBuf.append(",visited=").append(this.visited);
        strBuf.append(",networks=").append(this.networks);
        strBuf.append(",jvmArgs=").append(this.jvmArgs);
        strBuf.append(",services=").append(this.services);
        strBuf.append(",properties=").append(this.properties);
        strBuf.append(",nat=").append(this.nat);
        strBuf.append(",gateway=").append(this.gateway);
        strBuf.append(",hops=").append(this.hops);
        strBuf.append(")");
        return strBuf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof A3CMLServer) {
            A3CMLServer server = (A3CMLServer)obj;
            if (this.sid == server.sid && this.name.equals(server.name) && (this.hostname == server.hostname || this.hostname != null && this.hostname.equals(server.hostname)) && (this.domain == server.domain || this.domain != null && this.domain.equals(server.domain)) && this.port == server.port && this.services.equals(server.services) && (this.jvmArgs == server.jvmArgs || this.jvmArgs != null && this.jvmArgs.equals(server.jvmArgs)) && (this.properties == server.properties || this.properties != null && this.properties.equals(server.properties)) && (this.nat == server.nat || this.nat != null && this.nat.equals(server.nat)) && this.networks.equals(server.networks) && this.visited == server.visited && this.gateway == server.gateway) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + this.gateway;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.jvmArgs == null ? 0 : this.jvmArgs.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nat == null ? 0 : this.nat.hashCode());
        result = 31 * result + (this.networks == null ? 0 : this.networks.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.services == null ? 0 : this.services.hashCode());
        result = 31 * result + this.sid;
        result = 31 * result + (this.visited ? 1231 : 1237);
        return result;
    }
}

