/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.ext;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.ext.JDBCTransactionMBean;
import fr.dyade.aaa.util.DBTransaction;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;

public class JDBCTransaction
extends DBTransaction
implements JDBCTransactionMBean {
    public static final String JDBC_TRANSACTION_PREFIX = "org.ow2.joram.jdbc.transaction";
    public static final String JDBC_DRIVER_PROP = "org.ow2.joram.jdbc.transaction.driver";
    public static final String JDBC_URL_PROP = "org.ow2.joram.jdbc.transaction.url";
    public static final String JDBC_DB_PROTOCOL_PROP = "org.ow2.joram.jdbc.transaction.protocol";
    public static final String JDBC_DB_HOST_PROP = "org.ow2.joram.jdbc.transaction.host";
    public static final String JDBC_DB_PORT_PROP = "org.ow2.joram.jdbc.transaction.port";
    public static final String JDBC_DB_NAME_PROP = "org.ow2.joram.jdbc.transaction.dbname";
    public static final String DFLT_JDBC_DB_PREFIX = "JoramDB";
    public static final String JDBC_PROPS_FILE_PROP = "org.ow2.joram.jdbc.transaction.properties";
    public static final String JDBC_DB_USER_PROP = "org.ow2.joram.jdbc.transaction.user";
    public static final String JDBC_DB_PASS_PROP = "org.ow2.joram.jdbc.transaction.password";
    public static final String JDBC_CONNECT_RETRY_COUNT_PROP = "org.ow2.joram.jdbc.transaction.connect_retry_count";
    public static final String JDBC_CONNECT_RETRY_MIN_DELAY_PROP = "org.ow2.joram.jdbc.transaction.connect_retry_min_delay";
    public static final String JDBC_CONNECT_RETRY_MAX_PERIOD_PROP = "org.ow2.joram.jdbc.transaction.connect_retry_max_period";
    public static final String JDBC_DB_INIT_PROP = "org.ow2.joram.jdbc.transaction.dbinit";
    public static final String JDBC_DB_INSERT_PROP = "org.ow2.joram.jdbc.transaction.dbinsert";
    public static final String JDBC_DB_UPDATE_PROP = "org.ow2.joram.jdbc.transaction.dbupdate";
    public static final String JDBC_DB_LOAD_PROP = "org.ow2.joram.jdbc.transaction.dbload";
    public static final String JDBC_DB_DELETE_PROP = "org.ow2.joram.jdbc.transaction.dbdelete";
    public static final String JDBC_DB_CLOSE_PROP = "org.ow2.joram.jdbc.transaction.dbclose";
    private String driver;
    private String connurl;
    private String protocol;
    private String host;
    private String port;
    private String user;
    private String password;
    private String dbname;
    private String dbinit;
    private String path = null;
    private Properties props = null;

    @Override
    public String getDBName() {
        return this.dbname;
    }

    @Override
    public String getDBInitStatement() {
        return this.dbinit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initDB() throws IOException {
        this.driver = AgentServer.getProperty(JDBC_DRIVER_PROP);
        if (this.driver == null) {
            throw new IOException("Driver property is undefined");
        }
        this.connurl = AgentServer.getProperty(JDBC_URL_PROP);
        this.connurl = this.connurl.replaceAll("@@sid@@", "" + AgentServer.getServerId());
        this.protocol = AgentServer.getProperty(JDBC_DB_PROTOCOL_PROP);
        this.host = AgentServer.getProperty(JDBC_DB_HOST_PROP);
        this.port = AgentServer.getProperty(JDBC_DB_PORT_PROP);
        this.props = new Properties();
        this.path = AgentServer.getProperty(JDBC_PROPS_FILE_PROP);
        if (this.path != null) {
            try (FileInputStream fis = new FileInputStream(this.path);){
                this.props.load(fis);
            }
            catch (Exception exc) {
                logmon.log(BasicLevel.FATAL, "JDBCTransaction.initDB: Cannot load properties from " + this.path);
                throw new IOException("Bad JDBC configuration", exc);
            }
        }
        this.user = AgentServer.getProperty(JDBC_DB_USER_PROP);
        if (this.user != null) {
            if (this.props.containsKey("user")) {
                logmon.log(BasicLevel.WARN, "JDBCTransaction.initDB: user already defined in JDBC properties, cannot overload it.");
            } else {
                this.props.setProperty("user", this.user);
            }
        }
        this.password = AgentServer.getProperty(JDBC_DB_PASS_PROP);
        if (this.password != null) {
            if (this.props.containsKey("password")) {
                logmon.log(BasicLevel.WARN, "JDBCTransaction.initDB: password already defined in JDBC properties, cannot overload it.");
            } else {
                this.props.setProperty("password", this.password);
            }
        }
        if (this.props.getProperty("user") == null || this.props.getProperty("password") == null) {
            logmon.log(BasicLevel.FATAL, "JDBCTransaction.initDB: need to define authentication parameters.");
            throw new IOException("Bad JDBC configuration");
        }
        this.dbname = AgentServer.getProperty(JDBC_DB_NAME_PROP, DFLT_JDBC_DB_PREFIX + AgentServer.getServerId());
        this.dbname = this.dbname.replaceAll("@@sid@@", "" + AgentServer.getServerId());
        this.dbinit = AgentServer.getProperty(JDBC_DB_INIT_PROP);
        if (this.dbinit == null) {
            logmon.log(BasicLevel.FATAL, "JDBCTransaction.initDB: JDBC init statement not defined.");
            throw new IOException("Bad JDBC configuration");
        }
        this.dbinsert = AgentServer.getProperty(JDBC_DB_INSERT_PROP);
        this.dbupdate = AgentServer.getProperty(JDBC_DB_UPDATE_PROP);
        this.dbload = AgentServer.getProperty(JDBC_DB_LOAD_PROP);
        this.dbdelete = AgentServer.getProperty(JDBC_DB_DELETE_PROP);
        this.dbclose = AgentServer.getProperty(JDBC_DB_CLOSE_PROP);
        if (this.connurl != null) {
            if (this.protocol != null || this.host != null || this.port != null) {
                logmon.log(BasicLevel.WARN, "JDBCTransaction.initDB: JDBC URL defined, ignore other parameters (protocol, host and port).");
            }
        } else {
            if (this.protocol == null || this.host == null || this.port == null) {
                logmon.log(BasicLevel.FATAL, "JDBCTransaction.initDB: Should define JDBC URL or protocol, host and port parameters.");
                throw new IOException("Bad JDBC configuration");
            }
            StringBuffer strbuf = new StringBuffer(this.protocol).append("://");
            strbuf.append(this.host).append(':').append(this.port).append('/');
            strbuf.append(this.dbname);
            this.connurl = strbuf.toString();
        }
        this.connectRetryCount = AgentServer.getInteger(JDBC_CONNECT_RETRY_COUNT_PROP, 5);
        if (this.connectRetryCount < 0) {
            this.connectRetryCount = 0;
        }
        this.connectRetryMinDelay = AgentServer.getLong(JDBC_CONNECT_RETRY_MIN_DELAY_PROP, 1000L);
        if (this.connectRetryMinDelay < 0L) {
            this.connectRetryMinDelay = 0L;
        }
        this.connectRetryMaxPeriod = AgentServer.getLong(JDBC_CONNECT_RETRY_MAX_PERIOD_PROP, 60000L);
        if (this.connectRetryMaxPeriod < 0L) {
            this.connectRetryMaxPeriod = 0L;
        }
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.FATAL, "DBTransaction, init(): cannot load driver " + this.driver, (Throwable)exc);
            } else {
                logmon.log(BasicLevel.FATAL, "DBTransaction, init(): cannot load driver " + this.driver);
            }
            throw new IOException(exc.getMessage());
        }
        this.connectDB();
        Statement s = null;
        try {
            s = this.conn.createStatement();
            s.execute(this.dbinit);
        }
        catch (SQLException sqle) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.WARN, "DBTransaction, init(): DB already exists", (Throwable)sqle);
            } else {
                logmon.log(BasicLevel.WARN, "DBTransaction, init(): DB already exists");
            }
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
                this.conn.commit();
            }
            catch (SQLException sqle) {
                logmon.log(BasicLevel.WARN, "DBTransaction, init()", (Throwable)sqle);
            }
        }
        logmon.log(BasicLevel.INFO, "DBTransaction, init(): " + this.dumpProperties());
    }

    @Override
    protected void connectDB() throws IOException {
        try {
            this.conn = DriverManager.getConnection(this.connurl, this.props);
            this.conn.setAutoCommit(false);
        }
        catch (SQLException exc) {
            throw new IOException("JDBCTransaction.reconnectDB:", exc);
        }
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public String getURL() {
        return this.connurl;
    }

    @Override
    public Properties getClientInfo() {
        if (this.conn == null) {
            return null;
        }
        try {
            return this.conn.getClientInfo();
        }
        catch (SQLException sqle) {
            logmon.log(BasicLevel.WARN, "DBTransaction, getClientInfo(): ", (Throwable)sqle);
            return null;
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPropertiesPath() {
        return this.path;
    }

    @Override
    protected void dumpProperties(StringBuilder strbuf) {
        super.dumpProperties(strbuf);
        strbuf.append('(').append("driver=").append(this.driver).append(')');
        strbuf.append('(').append("url=").append(this.connurl).append(')');
        strbuf.append('(').append("dbtable=").append(this.dbtable).append(')');
        strbuf.append('(').append("dbname=").append(this.dbname).append(')');
        strbuf.append('(').append("user=").append(this.user).append(')');
        strbuf.append('(').append("password=").append("***").append(')');
        strbuf.append('(').append("connect_retry_count=").append(this.connectRetryCount).append(')');
        strbuf.append('(').append("connect_retry_min_delay=").append(this.connectRetryMinDelay).append(')');
        strbuf.append('(').append("connect_retry_max_period=").append(this.connectRetryMaxPeriod).append(')');
    }
}

