/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.common.Pool;
import fr.dyade.aaa.util.DBTransaction;
import java.io.Serializable;

final class DBOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int SAVE = 1;
    static final int CREATE = 4;
    static final int DELETE = 2;
    static final int NOOP = 5;
    static final int COMMIT = 3;
    static final int END = 127;
    int type;
    String name;
    byte[] value;
    private static Pool pool = null;

    private DBOperation(int type, String name, byte[] value) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",type=").append(this.type);
        strbuf.append(",name=").append(this.name);
        strbuf.append(')');
        return strbuf.toString();
    }

    static DBOperation alloc(int type, String name) {
        return DBOperation.alloc(type, name, null);
    }

    static DBOperation alloc(int type, String name, byte[] value) {
        DBOperation op = null;
        try {
            op = (DBOperation)pool.allocElement();
        }
        catch (Exception exc) {
            return new DBOperation(type, name, value);
        }
        op.type = type;
        op.name = name;
        op.value = value;
        return op;
    }

    void free() {
        this.name = null;
        this.value = null;
        pool.freeElement((Object)this);
    }

    static {
        pool = new Pool("DBTransaction$Operation", Integer.getInteger("DBLogThresholdOperation", DBTransaction.logThresholdOperation).intValue());
    }
}

