/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.common.Debug;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

@Deprecated
public class AdminProxy {
    static final Logger xlogmon = Debug.getLogger((String)AdminProxy.class.getName());
    static AdminProxy proxy = null;
    static final boolean debug = true;
    public static final String LISTENPORT = "fr.dyade.aaa.agent.AdminProxy.port";
    private static int port = 8091;
    public static final String NBMONITOR = "fr.dyade.aaa.agent.AdminProxy.nbm";
    private static int nbm;
    AdminMonitor[] monitors = null;
    ServerSocket listen = null;
    static final String HELP = "help";
    static final String NONE = "";
    public static final String STOP_SERVER = "halt";
    public static final String CRASH_SERVER = "crash";
    public static final String PING = "ping";
    public static final String CONFIG = "config";
    static final String GC = "gc";
    static final String THREADS = "threads";
    static final String LIST_MCONS = "consumers";
    static final String START_MCONS = "start";
    static final String STOP_MCONS = "stop";
    static final String LIST_SERVICE = "services";
    static final String ADD_SERVICE = "add";
    static final String REMOVE_SERVICE = "remove";
    static final String DUMP = "dump";
    public static final String LOG = "log";

    public static void init(String args, boolean firstTime) throws Exception {
        try {
            port = args.length() != 0 ? Integer.parseInt(args) : Integer.parseInt(AgentServer.getProperty(LISTENPORT, "8091"));
        }
        catch (NumberFormatException exc) {
            port = 8091;
        }
        try {
            nbm = Integer.parseInt(AgentServer.getProperty(NBMONITOR, "1"));
        }
        catch (NumberFormatException exc) {
            nbm = 1;
        }
        if (proxy != null) {
            xlogmon.log(BasicLevel.ERROR, "AdminProxy#" + AgentServer.getServerId() + ": already initialized.");
            throw new Exception("AdminProxy.#" + AgentServer.getServerId() + ": already initialized.");
        }
        try {
            proxy = new AdminProxy();
        }
        catch (IOException exc) {
            xlogmon.log(BasicLevel.ERROR, "AdminProxy#" + AgentServer.getServerId() + ", can't get listen port", (Throwable)exc);
            throw exc;
        }
        AdminProxy.start();
    }

    private AdminProxy() throws IOException {
        int i = 0;
        while (true) {
            try {
                this.listen = new ServerSocket(port);
            }
            catch (BindException exc) {
                if (i > 5) {
                    throw exc;
                }
                try {
                    Thread.sleep((long)i * 500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
        this.monitors = new AdminMonitor[nbm];
        for (i = 0; i < this.monitors.length; ++i) {
            this.monitors[i] = new AdminMonitor("AdminProxy#" + AgentServer.getServerId() + '.' + i, xlogmon);
        }
    }

    public static void start() {
        for (int i = 0; i < AdminProxy.proxy.monitors.length; ++i) {
            AdminProxy.proxy.monitors[i].start();
        }
    }

    public static void stopService() {
        for (int i = 0; i < AdminProxy.proxy.monitors.length; ++i) {
            if (AdminProxy.proxy.monitors[i] != null) {
                AdminProxy.proxy.monitors[i].stop();
            }
            AdminProxy.proxy.monitors[i] = null;
        }
        proxy = null;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(").append(super.toString());
        strBuf.append(",port=").append(port);
        strBuf.append(",monitors=[");
        for (int i = 0; i < this.monitors.length; ++i) {
            strBuf.append(this.monitors[i].toString()).append(",");
        }
        strBuf.append("]");
        strBuf.append(")");
        return strBuf.toString();
    }

    class AdminMonitor
    extends Daemon {
        Socket socket;
        BufferedReader reader;
        PrintWriter writer;

        protected AdminMonitor(String name, Logger logger) {
            super(name, logger);
            this.socket = null;
            this.reader = null;
            this.writer = null;
            this.setThreadGroup(AgentServer.getThreadGroup());
        }

        public String toString() {
            return "(" + super.toString() + ",socket=" + this.socket + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    block30: {
                        this.canStop = true;
                        try {
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", waiting: " + AdminProxy.this.listen);
                            this.socket = AdminProxy.this.listen.accept();
                            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", receiving.");
                            this.canStop = false;
                        }
                        catch (IOException exc) {
                            if (!this.running) break block30;
                            this.logmon.log(BasicLevel.ERROR, this.getName() + ", error during accept", (Throwable)exc);
                        }
                    }
                    if (!this.running) {
                        break;
                    }
                    try {
                        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                        this.writer = new PrintWriter(this.socket.getOutputStream(), true);
                        this.doRequest(this.reader.readLine());
                        this.writer.flush();
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, this.getName() + ", error during connection", (Throwable)exc);
                    }
                    finally {
                        try {
                            this.reader.close();
                        }
                        catch (Exception exception) {}
                        this.reader = null;
                        try {
                            this.writer.close();
                        }
                        catch (Exception exception) {}
                        this.writer = null;
                        try {
                            this.socket.close();
                        }
                        catch (Exception exception) {}
                        this.socket = null;
                    }
                }
            }
            finally {
                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", finishing.");
                this.finish();
            }
        }

        protected void close() {
            try {
                this.logmon.log(BasicLevel.DEBUG, this.getName() + ", closing: " + AdminProxy.this.listen);
                AdminProxy.this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AdminProxy.this.listen = null;
        }

        protected void shutdown() {
            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", close(): ");
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRequest(String request) {
            String cmd = null;
            this.logmon.log(BasicLevel.DEBUG, this.getName() + ", request=" + request);
            StringTokenizer st = new StringTokenizer(request);
            cmd = st.nextToken();
            if (cmd.equals(AdminProxy.STOP_SERVER)) {
                AgentServer.stop(false);
                this.logmon.log(BasicLevel.WARN, this.getName() + ", bye.");
            } else if (cmd.equals(AdminProxy.CRASH_SERVER)) {
                this.logmon.log(BasicLevel.WARN, this.getName() + ", crash!");
                System.exit(0);
            } else if (cmd.equals(AdminProxy.GC)) {
                Runtime runtime = Runtime.getRuntime();
                this.writer.println("before: " + runtime.freeMemory() + " octets free / " + runtime.totalMemory() + " octets.");
                runtime.gc();
                this.writer.println("after: " + runtime.freeMemory() + " octets free / " + runtime.totalMemory() + " octets.");
            } else if (cmd.equals(AdminProxy.LIST_MCONS)) {
                Enumeration<MessageConsumer> c = AgentServer.getConsumers();
                while (c.hasMoreElements()) {
                    MessageConsumer cons = c.nextElement();
                    this.writer.println("+----------------------------------------");
                    this.writer.println(cons);
                }
            } else if (cmd.equals(AdminProxy.START_MCONS)) {
                String domain = null;
                if (st.hasMoreTokens()) {
                    domain = st.nextToken();
                }
                Enumeration<MessageConsumer> c = AgentServer.getConsumers();
                while (c.hasMoreElements()) {
                    MessageConsumer cons = c.nextElement();
                    if (domain != null && !domain.equals(cons.getName())) continue;
                    try {
                        cons.start();
                        this.writer.println("start " + cons.getName() + " done.");
                    }
                    catch (Exception exc) {
                        this.writer.println("Can't start " + cons.getName() + ": " + exc.getMessage());
                        exc.printStackTrace(this.writer);
                    }
                }
            } else if (cmd.equals(AdminProxy.STOP_MCONS)) {
                String domain = null;
                if (st.hasMoreTokens()) {
                    domain = st.nextToken();
                }
                Enumeration<MessageConsumer> c = AgentServer.getConsumers();
                while (c.hasMoreElements()) {
                    MessageConsumer cons = c.nextElement();
                    if (domain != null && !domain.equals(cons.getName())) continue;
                    cons.stop();
                    this.writer.println("stop " + cons.getName() + " done.");
                }
            } else if (cmd.equals(AdminProxy.LIST_SERVICE)) {
                ServiceDesc[] services = ServiceManager.getServices();
                for (int i = 0; i < services.length; ++i) {
                    this.writer.println("+----------------------------------------");
                    this.writer.println(services[i].getClassName() + " (" + services[i].getArguments() + ")" + (services[i].isInitialized() ? " initialized " : AdminProxy.NONE) + (services[i].isRunning() ? " running" : AdminProxy.NONE));
                }
            } else if (cmd.equals(AdminProxy.ADD_SERVICE)) {
                try {
                    String sclass = null;
                    String args = null;
                    try {
                        sclass = st.nextToken();
                        if (st.hasMoreTokens()) {
                            args = st.nextToken();
                        }
                    }
                    catch (NoSuchElementException exc) {
                        throw new Exception("Usage: add <sclass> [<args>]");
                    }
                    try {
                        ServiceManager.register(sclass, args);
                        this.writer.println("Service <" + sclass + "> registred.");
                        ServiceManager.start(sclass);
                        this.writer.println("Service <" + sclass + "> started.");
                    }
                    catch (Exception exc) {
                        this.writer.println("Can't start service: " + exc.getMessage());
                        exc.printStackTrace(this.writer);
                    }
                }
                catch (Exception exc) {
                    this.writer.println(exc.getMessage());
                }
            } else if (cmd.equals(AdminProxy.REMOVE_SERVICE)) {
                String sclass = null;
                try {
                    sclass = st.nextToken();
                }
                catch (NoSuchElementException exc) {
                    this.writer.println("Usage: remove <sclass> [<args>]");
                    return;
                }
                try {
                    ServiceManager.stop(sclass);
                    this.writer.println("Service <" + sclass + "> stopped.");
                }
                catch (Exception exc) {
                    this.writer.println("Can't stop service: " + exc.getMessage());
                    exc.printStackTrace(this.writer);
                }
                try {
                    ServiceManager.unregister(sclass);
                    this.writer.println("Service <" + sclass + "> unregistred.");
                }
                catch (Exception exc) {
                    this.writer.println("Can't unregister service: " + exc.getMessage());
                    exc.printStackTrace(this.writer);
                }
            } else if (cmd.equals(AdminProxy.DUMP)) {
                AgentId id = null;
                try {
                    id = AgentId.fromString(st.nextToken());
                }
                catch (IllegalArgumentException exc) {
                    this.writer.println("Usage: dump #x.y.z");
                    return;
                }
                try {
                    this.writer.println(AgentServer.getEngine().dumpAgent(id));
                }
                catch (Exception exc) {
                    this.writer.println("Can't launch server: " + exc.getMessage());
                    exc.printStackTrace(this.writer);
                }
            } else if (!cmd.equals(AdminProxy.NONE)) {
                if (cmd.equals(AdminProxy.PING)) {
                    this.writer.println(AgentServer.getServerId());
                } else if (cmd.equals(AdminProxy.CONFIG)) {
                    try {
                        A3CMLConfig a3CMLConfig = AgentServer.getConfig();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        PrintWriter out = new PrintWriter(baos);
                        A3CML.toXML(a3CMLConfig, out);
                        out.flush();
                        baos.flush();
                        baos.close();
                        byte[] bytes = baos.toByteArray();
                        this.writer.println(new String(bytes));
                    }
                    catch (Exception exc) {
                        this.writer.println("Can't load configuration: " + exc.getMessage());
                        exc.printStackTrace(this.writer);
                    }
                } else if (cmd.equals(AdminProxy.LOG)) {
                    PrintStream oldErr = System.err;
                    try {
                        System.setErr(new PrintStream(this.socket.getOutputStream()));
                        String classname = st.nextToken();
                        String level = st.nextToken();
                        Debug.setLoggerLevel((String)classname, (String)level);
                        return;
                    }
                    catch (Exception exc) {
                        this.writer.println(exc.getMessage());
                    }
                    finally {
                        System.setErr(oldErr);
                        this.writer.println("OK");
                    }
                } else if (cmd.equals(AdminProxy.HELP)) {
                    this.writer.println("Description of available commands:\n\thelp\n\t\tGives the summary of the options.\n\thalt\n\t\tStops the server.\n\tgc\n\t\tRun the garbage collector in the specified A3 server.\n\tthreads [group]\n\t\tList all threads in server JVM.\n\tconsumers\n\t\tList all defined consumers.\n\tstart [domain]\n\t\tStarts the specified MessageConsumer.\n\tstop [domain]\n\t\tStops the specified MessageConsumer.\n\tservices\n\t\tList all registered services.\n\tadd classname arguments\n\t\tRegisters and starts the specified Service.\n\tremove classname\n\t\tStops then unregister the specified Service.\n\tconfig\n\t\tReturns the configuration of the server in XML format.\n");
                } else {
                    this.writer.println("unknown command:" + cmd);
                }
            }
        }
    }
}

