/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ServerLock {
    private static Logger logmon = Debug.getLogger((String)AgentServer.class.getName());
    private RandomAccessFile raf;
    private FileLock lock;

    public ServerLock(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.lock = this.raf.getChannel().tryLock();
        if (this.lock == null) {
            throw new IOException("Cannot acquire lock.");
        }
        file.deleteOnExit();
    }

    public void check() {
        if (this.lock != null) {
            logmon.log(BasicLevel.WARN, "AgentServer.lock -> " + this.lock.isValid() + '/' + this.lock.isShared());
        }
    }

    public void close() {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
        }
        catch (IOException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.WARN, "Cannot release AgentServer lock.", (Throwable)exc);
            } else {
                logmon.log(BasicLevel.WARN, "Cannot release AgentServer lock: " + exc.getMessage());
            }
        }
        finally {
            this.lock = null;
        }
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException exc) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.WARN, "Cannot close AgentServer lock.", (Throwable)exc);
            } else {
                logmon.log(BasicLevel.WARN, "Cannot close lock: " + exc.getMessage());
            }
        }
        finally {
            this.raf = null;
        }
    }
}

