/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;

public class SyncNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    private transient Context ctx;
    private Thread caller = null;

    protected SyncNotification() {
        this.persistent = false;
        this.ctx = new Context(this);
    }

    public void invokeNoWait(AgentId to) throws InterruptedException, Exception {
        try {
            this.caller = Thread.currentThread();
            this.ctx.invoke(to, -1L);
            return;
        }
        finally {
            this.caller = null;
        }
    }

    public Object[] invoke(AgentId to) throws InterruptedException, Exception {
        try {
            this.caller = Thread.currentThread();
            Object[] objectArray = this.ctx.invoke(to, 0L);
            return objectArray;
        }
        finally {
            this.caller = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] invoke(AgentId to, long timeout) throws InterruptedException, Exception {
        try {
            this.caller = Thread.currentThread();
            Object[] objectArray = this.ctx.invoke(to, timeout);
            return objectArray;
        }
        finally {
            this.caller = null;
        }
    }

    public void interupt() {
        this.caller.interrupt();
    }

    public void wakeup() {
        this.ctx.wakeup();
    }

    public void Throw(Exception exc) {
        if (this.ctx != null) {
            this.ctx.Throw(exc);
        }
    }

    public void Return(Object[] values) {
        if (this.ctx != null) {
            this.ctx.Return(values);
        }
    }

    public Object getValue(int index) {
        if (this.ctx != null) {
            return this.ctx.getValue(index);
        }
        return null;
    }

    public final Exception getException() {
        if (this.ctx != null) {
            return this.ctx.getException();
        }
        return null;
    }

    public static class Context {
        private Notification syncRequest;
        private Result res;

        public Context(Notification syncRequest) {
            this.syncRequest = syncRequest;
            this.res = new Result();
        }

        public final synchronized Object[] invoke(AgentId to, long timeout) throws InterruptedException, Exception {
            if (timeout > 0L) {
                this.syncRequest.setExpiration(System.currentTimeMillis() + timeout);
            }
            Channel.sendTo(to, this.syncRequest);
            if (timeout < 0L) {
                return null;
            }
            if (timeout == 0L) {
                this.wait();
            } else {
                this.wait(timeout);
            }
            if (this.res.exc != null) {
                throw this.res.exc;
            }
            return this.res.values;
        }

        public synchronized void wakeup() {
            this.notify();
        }

        public synchronized void Throw(Exception exc) {
            this.res.exc = exc;
            this.notify();
        }

        public synchronized void Return(Object[] values) {
            this.res.values = values;
            this.notify();
        }

        public Object getValue(int index) {
            if (this.res.values != null) {
                return this.res.values[index];
            }
            return null;
        }

        public final Exception getException() {
            return this.res.exc;
        }
    }

    static class Result {
        Object[] values = null;
        Exception exc = null;

        Result() {
        }
    }
}

