/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.conf;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNat;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import fr.dyade.aaa.agent.conf.A3CMLWrapper;
import fr.dyade.aaa.agent.conf.Log;
import fr.dyade.aaa.agent.conf.ParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.Enumeration;
import org.objectweb.util.monolog.api.BasicLevel;

public class A3CML {
    static final String ELT_CONFIG = "config";
    static final String ELT_DOMAIN = "domain";
    static final String ELT_SERVER = "server";
    static final String ELT_NETWORK = "network";
    static final String ELT_SERVICE = "service";
    static final String ELT_PROPERTY = "property";
    static final String ELT_NAT = "nat";
    static final String ATT_ID = "id";
    static final String ATT_NAME = "name";
    static final String ATT_DOMAIN = "domain";
    static final String ATT_NETWORK = "network";
    static final String ATT_HOSTNAME = "hostname";
    static final String ATT_PORT = "port";
    static final String ATT_SERVER = "server";
    static final String ATT_CLASS = "class";
    static final String ATT_ARGS = "args";
    static final String ATT_VALUE = "value";
    static final String ELT_JVM_ARGS = "jvmArgs";
    static final String ATT_SID = "sid";
    static final String TAB = "  ";
    static final String TAB2 = "    ";

    public static final void toXML(A3CMLConfig config, String cfgDir, String xmlFileName) throws Exception {
        File xmlFile = new File(cfgDir, xmlFileName);
        PrintWriter out = new PrintWriter(new FileWriter(xmlFile));
        A3CML.toXML(config, out);
    }

    public static final void toXML(A3CMLConfig config, PrintWriter out) throws Exception {
        out.write("\n<config>\n\n");
        Enumeration<Serializable> e = config.properties.elements();
        while (e.hasMoreElements()) {
            A3CMLProperty p = e.nextElement();
            out.write("  <property name=\"");
            out.write(p.name);
            out.write("\" value=\"");
            out.write(p.value);
            out.write("\"/>\n");
        }
        out.write("\n");
        e = config.domains.elements();
        while (e.hasMoreElements()) {
            A3CMLDomain d = (A3CMLDomain)e.nextElement();
            out.write("  <domain name=\"");
            out.write(d.name);
            out.write("\" network=\"");
            out.write(d.network);
            out.write("\"/>\n");
        }
        out.write("\n");
        e = config.servers.elements();
        while (e.hasMoreElements()) {
            Serializable obj = e.nextElement();
            if (obj instanceof A3CMLServer) {
                A3CML.writeToXMLServer(obj, out);
            }
            out.write("\n");
        }
        out.write("</config>\n");
        out.flush();
    }

    private static final void writeToXMLServer(Object obj, PrintWriter out) {
        if (obj instanceof A3CMLServer) {
            Serializable n;
            Enumeration<Serializable> e;
            A3CMLServer server = (A3CMLServer)obj;
            out.write("  <server hostname=\"");
            out.write(server.hostname);
            out.write("\" id=\"");
            out.write(Short.toString(server.sid));
            out.write("\" name=\"");
            out.write(server.name);
            out.write("\">\n");
            if (server.jvmArgs != null && server.jvmArgs.length() > 0) {
                out.write("    <jvmArgs value=\"");
                out.write(server.jvmArgs);
                out.write("\"/>\n");
            }
            if (server.properties != null) {
                e = server.properties.elements();
                while (e.hasMoreElements()) {
                    A3CMLProperty p = (A3CMLProperty)e.nextElement();
                    out.write("    <property name=\"");
                    out.write(p.name);
                    out.write("\" value=\"");
                    out.write(p.value);
                    out.write("\"/>\n");
                }
            }
            if (server.nat != null) {
                e = server.nat.elements();
                while (e.hasMoreElements()) {
                    n = (A3CMLNat)e.nextElement();
                    out.write("    <nat sid=\"");
                    out.write(Short.toString(n.sid));
                    out.write("\" hostname=\"");
                    out.write(n.host);
                    out.write("\" port=\"");
                    out.write(Integer.toString(n.port));
                    out.write("\"/>\n");
                }
            }
            if (server.networks != null) {
                e = server.networks.elements();
                while (e.hasMoreElements()) {
                    n = (A3CMLNetwork)e.nextElement();
                    out.write("    <network domain=\"");
                    out.write(((A3CMLNetwork)n).domain);
                    out.write("\" port=\"");
                    out.write(Integer.toString(((A3CMLNetwork)n).port));
                    out.write("\"/>\n");
                }
            }
            if (server.services != null) {
                e = server.services.elements();
                while (e.hasMoreElements()) {
                    A3CMLService service = (A3CMLService)e.nextElement();
                    out.write("    <service class=\"");
                    out.write(service.classname);
                    out.write("\" args=\"");
                    if (service.args != null && service.args.length() > 0) {
                        out.write(service.args);
                    }
                    out.write("\"/>\n");
                }
            }
            out.write("  </server>\n");
        }
    }

    public static A3CMLConfig getXMLConfig() throws Exception {
        String cfgDir = System.getProperty("fr.dyade.aaa.agent.A3CONF_DIR", AgentServer.DEFAULT_CFG_DIR);
        String cfgFile = System.getProperty("fr.dyade.aaa.agent.A3CONF_FILE", "a3servers.xml");
        return A3CML.getXMLConfig(cfgDir, cfgFile);
    }

    public static A3CMLConfig getXMLConfig(String cfgDir, String cfgFileName) throws Exception {
        return A3CML.getXMLConfig(new File(cfgDir, cfgFileName).getPath());
    }

    public static A3CMLConfig getXMLConfig(String path) throws Exception {
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, "Config.getXMLConfig(" + path + ")");
        }
        A3CMLConfig a3cmlconfig = null;
        FileReader reader = null;
        File cfgFile = new File(path);
        try {
            if (!cfgFile.exists() || !cfgFile.isFile() || cfgFile.length() == 0L) {
                throw new IOException();
            }
            reader = new FileReader(cfgFile);
        }
        catch (IOException exc) {
            Log.logger.log(BasicLevel.DEBUG, "Unable to find configuration file \"" + cfgFile.getPath() + "\".");
            reader = null;
        }
        if (reader == null) {
            ClassLoader classLoader = null;
            InputStream is = null;
            try {
                classLoader = A3CMLConfig.class.getClassLoader();
                if (classLoader != null) {
                    Log.logger.log(BasicLevel.DEBUG, "Trying to find [" + path + "] using " + classLoader + " class loader.");
                    is = classLoader.getResourceAsStream(path);
                }
            }
            catch (Throwable t) {
                Log.logger.log(BasicLevel.DEBUG, "Can't find [" + path + "] using " + classLoader + " class loader.");
                is = null;
            }
            if (is == null) {
                Log.logger.log(BasicLevel.DEBUG, "Trying to find [" + path + "] using ClassLoader.getSystemResource().");
                is = ClassLoader.getSystemResourceAsStream(path);
            }
            if (is != null) {
                try {
                    a3cmlconfig = A3CML.getConfig(new InputStreamReader(is));
                }
                catch (ParseException exc) {
                    exc.setFileName(path + " as ClassLoader ressource");
                    throw exc;
                }
            }
        } else {
            try {
                a3cmlconfig = A3CML.getConfig(reader);
            }
            catch (ParseException exc) {
                exc.setFileName(path);
                throw exc;
            }
        }
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, "a3cmlconfig = " + a3cmlconfig);
        }
        if (a3cmlconfig == null) {
            throw new FileNotFoundException("xml configuration file " + path + " not found.");
        }
        return a3cmlconfig;
    }

    public static A3CMLConfig getConfig(Reader reader) throws Exception {
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, "Config.getConfig(" + reader + ")");
        }
        String cfgName = System.getProperty("fr.dyade.aaa.agent.A3CONF_NAME", "default");
        String wrpCName = System.getProperty("fr.dyade.aaa.agent.A3CMLWrapper", "fr.dyade.aaa.agent.conf.A3CMLSaxWrapper");
        Class<?> wrpClass = Class.forName(wrpCName);
        A3CMLWrapper wrapper = (A3CMLWrapper)wrpClass.newInstance();
        A3CMLConfig a3config = null;
        a3config = wrapper.parse(reader, cfgName);
        if (a3config == null || a3config.servers == null) {
            throw new ParseException("Empty configuration");
        }
        return a3config;
    }
}

