/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.conf;

import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.Log;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;

public class A3CMLDomain
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name = null;
    public String network = null;
    public Vector<A3CMLServer> servers = null;
    public short gateway = (short)-1;
    public int hops = -1;

    public A3CMLDomain(String name, String network) throws Exception {
        if (name.equals("local")) {
            throw new Exception("Domain name \"" + name + "\" is reserved.");
        }
        this.name = name;
        this.network = network == null || network.equals("") ? "fr.dyade.aaa.agent.SimpleNetwork" : network;
    }

    public void addServer(A3CMLServer server) {
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, "A3CMLDomain.addServer(" + server + ')');
        }
        if (this.servers == null) {
            this.servers = new Vector();
        }
        this.servers.addElement(server);
    }

    public void removeServer(A3CMLServer server) {
        if (this.servers == null) {
            return;
        }
        this.servers.removeElement(server);
    }

    public void removeServer(short sid) {
        if (this.servers == null) {
            return;
        }
        for (int i = 0; i < this.servers.size(); ++i) {
            A3CMLServer serv = this.servers.elementAt(i);
            if (serv.sid != sid) continue;
            this.servers.removeElementAt(i);
        }
    }

    public short[] getServersId() {
        if (this.servers != null) {
            short[] domainSids = new short[this.servers.size()];
            for (int i = 0; i < domainSids.length; ++i) {
                domainSids[i] = this.servers.elementAt((int)i).sid;
            }
            return domainSids;
        }
        return new short[0];
    }

    public A3CMLDomain duplicate() throws Exception {
        A3CMLDomain clone = new A3CMLDomain(this.name, this.network);
        if (this.servers != null) {
            Enumeration<A3CMLServer> s = this.servers.elements();
            while (s.hasMoreElements()) {
                clone.addServer(s.nextElement().duplicate());
            }
        }
        clone.gateway = this.gateway;
        return clone;
    }

    public A3CMLDomain duplicate(Hashtable<Short, A3CMLServer> context) throws Exception {
        A3CMLDomain clone = new A3CMLDomain(this.name, this.network);
        if (this.servers != null) {
            Enumeration<A3CMLServer> s = this.servers.elements();
            while (s.hasMoreElements()) {
                clone.addServer(s.nextElement().duplicate(context));
            }
        }
        clone.gateway = this.gateway;
        return clone;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(").append(super.toString());
        strBuf.append(",name=").append(this.name);
        strBuf.append(",network=").append(this.network);
        strBuf.append(",servers=").append(this.servers);
        strBuf.append(",gateway=").append(this.gateway);
        strBuf.append(",hops=").append(this.hops);
        strBuf.append(")");
        return strBuf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof A3CMLDomain) {
            A3CMLDomain domain = (A3CMLDomain)obj;
            if (this.name.equals(domain.name) && this.network.equals(domain.network) && (this.servers == domain.servers || this.servers != null && this.servers.equals(domain.servers)) && this.gateway == domain.gateway) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.gateway;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        result = 31 * result + (this.servers == null ? 0 : this.servers.hashCode());
        return result;
    }
}

