/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.common.encoding.ByteBufferDecoder;
import fr.dyade.aaa.common.encoding.ByteBufferEncoder;
import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encodable;
import fr.dyade.aaa.common.encoding.EncodableFactory;
import fr.dyade.aaa.common.encoding.EncodableFactoryRepository;
import fr.dyade.aaa.common.encoding.Encoder;
import fr.dyade.aaa.util.BaseTransaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Map;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class AbstractTransaction
extends BaseTransaction {
    private static final byte JAVA_SERIALIZATION_TAG = 0;
    private static final byte ENCODING_TAG = 1;
    private boolean onlyUseJavaSerialization;
    protected long startTime = 0L;
    protected int phase;
    protected File dir = null;
    protected ThreadLocal<Context> perThreadContext = null;
    protected static final byte[] OOS_STREAM_HEADER = new byte[]{-84, -19, 0, 5};

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public final boolean isPersistent() {
        return true;
    }

    @Override
    public final int getPhase() {
        return this.phase;
    }

    @Override
    public final String getPhaseInfo() {
        return PhaseInfo[this.phase];
    }

    protected abstract void setPhase(int var1) throws IOException;

    public abstract void initRepository() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void init(String path) throws IOException {
        this.phase = 0;
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, "Transaction, init():");
        }
        this.dir = new File(path);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        if (!this.dir.isDirectory()) {
            throw new FileNotFoundException(path + " is not a directory.");
        }
        try (FilterOutputStream ldos = null;){
            File tfc = new File(this.dir, "TFC");
            if (!tfc.exists()) {
                ldos = new DataOutputStream(new FileOutputStream(tfc));
                ((DataOutputStream)ldos).writeUTF(this.getClass().getName());
                ((DataOutputStream)ldos).flush();
            }
        }
        this.loadProperties(this.dir);
        this.onlyUseJavaSerialization = this.getBoolean("Transaction.OnlyUseJavaSerialization");
        this.initRepository();
        this.saveProperties(this.dir);
        this.perThreadContext = new ThreadLocal<Context>(){

            @Override
            protected synchronized Context initialValue() {
                return new Context();
            }
        };
        this.startTime = System.currentTimeMillis();
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, "Transaction, initialized " + this.startTime);
        }
        this.setPhase(1);
    }

    @Override
    public final synchronized void begin() throws IOException {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(2);
    }

    @Override
    public final void create(Serializable obj, String name) throws IOException {
        this.save(obj, null, name, true);
    }

    @Override
    public final void create(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name, true);
    }

    @Override
    public final void save(Serializable obj, String name) throws IOException {
        this.save(obj, null, name, false);
    }

    @Override
    public final void save(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name, false);
    }

    private Encodable isEncodable(Object object) {
        if (object instanceof Encodable) {
            Encodable encodable = (Encodable)object;
            if (encodable.getEncodableClassId() >= 0) {
                return encodable;
            }
            return null;
        }
        return null;
    }

    private byte[] serialize(Serializable obj, Context ctx) throws IOException {
        if (ctx.oos == null) {
            ctx.bos.reset();
            if (!this.onlyUseJavaSerialization) {
                ctx.bos.write(0);
            }
            ctx.oos = new ObjectOutputStream(ctx.bos);
        } else {
            ctx.oos.reset();
            ctx.bos.reset();
            if (!this.onlyUseJavaSerialization) {
                ctx.bos.write(0);
            }
            ctx.bos.write(OOS_STREAM_HEADER, 0, 4);
        }
        ctx.oos.writeObject(obj);
        ctx.oos.flush();
        return ctx.bos.toByteArray();
    }

    @Override
    public final void save(Serializable obj, String dirName, String name, boolean first) throws IOException {
        byte[] encodedObject;
        Context ctx = this.perThreadContext.get();
        if (this.onlyUseJavaSerialization) {
            encodedObject = this.serialize(obj, ctx);
        } else {
            Encodable encodable = this.isEncodable(obj);
            if (encodable == null) {
                encodedObject = this.serialize(obj, ctx);
            } else {
                try {
                    encodedObject = new byte[5 + encodable.getEncodedSize()];
                    ByteBuffer buf = ByteBuffer.wrap(encodedObject);
                    ByteBufferEncoder encoder = new ByteBufferEncoder(buf);
                    encoder.encodeByte((byte)1);
                    encoder.encode32(encodable.getEncodableClassId());
                    encodable.encode((Encoder)encoder);
                }
                catch (Exception exc) {
                    throw new IOException(exc);
                }
            }
        }
        this.saveInLog(encodedObject, dirName, name, ctx.log, false, first);
    }

    @Override
    public final void createByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name, true, true);
    }

    @Override
    public final void createByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.saveByteArray(buf, dirName, name, true, true);
    }

    @Override
    public final void saveByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name, true, false);
    }

    @Override
    public final void saveByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.saveByteArray(buf, dirName, name, true, false);
    }

    @Override
    public final void saveByteArray(byte[] buf, String dirName, String name, boolean copy, boolean first) throws IOException {
        this.saveInLog(buf, dirName, name, this.perThreadContext.get().log, copy, first);
    }

    protected abstract void saveInLog(byte[] var1, String var2, String var3, Hashtable var4, boolean var5, boolean var6) throws IOException;

    @Override
    public final Object load(String name) throws IOException, ClassNotFoundException {
        return this.load(null, name);
    }

    @Override
    public final Object load(String dirName, String name) throws IOException, ClassNotFoundException {
        return this.loadFromByteArray(this.loadByteArray(dirName, name));
    }

    @Override
    public boolean useLoadAll() {
        return false;
    }

    @Override
    public void loadAll(String prefix, Map map) {
        String[] names;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, "Transaction, loadAll(" + prefix + ")");
        }
        for (String name : names = this.getList(prefix)) {
            try {
                map.put(name, this.load(name));
            }
            catch (IOException | ClassNotFoundException exc) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.WARN, "Transaction, loadAll: cannot retrieve content for " + name, (Throwable)exc);
                    continue;
                }
                logmon.log(BasicLevel.WARN, "Transaction, loadAll: cannot retrieve content for " + name + " - " + exc.getMessage());
            }
        }
    }

    protected final Object loadFromByteArray(byte[] buf) throws IOException, ClassNotFoundException {
        if (buf != null) {
            if (this.onlyUseJavaSerialization) {
                return this.deserialize(buf, 0);
            }
            if (buf.length > 0) {
                byte tag = buf[0];
                switch (tag) {
                    case 0: {
                        return this.deserialize(buf, 1);
                    }
                    case 1: {
                        return this.decode(buf, 1);
                    }
                }
                throw new IOException("Unexpected tag: " + tag);
            }
            throw new IOException("Unexpected empty byte array");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserialize(byte[] buf, int offset) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(buf, offset, buf.length - offset);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            ois.close();
            bis.close();
        }
    }

    private Object decode(byte[] buf, int offset) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf, offset, buf.length - offset);
        ByteBufferDecoder decoder = new ByteBufferDecoder(byteBuffer);
        try {
            int classId = decoder.decode32();
            EncodableFactory factory = EncodableFactoryRepository.getFactory((Integer)classId);
            if (factory == null) {
                throw new Exception("Unknown factory: " + classId);
            }
            Encodable encodable = factory.createEncodable();
            encodable.decode((Decoder)decoder);
            return encodable;
        }
        catch (Exception exc) {
            throw new IOException(exc);
        }
    }

    @Override
    public final byte[] loadByteArray(String name) throws IOException {
        return this.loadByteArray(null, name);
    }

    @Override
    public final void delete(String name) {
        this.delete(null, name);
    }

    @Override
    public synchronized void release() throws IOException {
        if (this.phase != 2 && this.phase != 3 && this.phase != 4) {
            throw new IllegalStateException("Can not release transaction: " + this.getPhaseInfo() + '.');
        }
        this.setPhase(1);
        this.notify();
    }

    @Override
    public boolean containsOperations() {
        return this.perThreadContext.get().getLog().size() > 0;
    }

    @Override
    public int getOperationCount() {
        return this.perThreadContext.get().getLog().size();
    }

    public class Context {
        private Hashtable log = new Hashtable(15);
        private ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        private ObjectOutputStream oos = null;

        public final Hashtable getLog() {
            return this.log;
        }

        Context() {
        }
    }
}

