/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.common.BinaryDump;
import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class BaseTransaction
implements Transaction {
    protected static Logger logmon = Debug.getLogger((String)Transaction.class.getName());
    private Properties props = new Properties();

    @Override
    public synchronized void freeze(long timeout) throws InterruptedException {
        logmon.log(BasicLevel.WARN, "Transaction.freeze " + timeout, (Throwable)new Exception());
        Thread.sleep(timeout);
    }

    public void loadProperties(File dir) throws InvalidPropertiesFormatException, FileNotFoundException, IOException {
        File tpf = new File(dir, "TPF");
        if (tpf.exists()) {
            this.props.loadFromXML(new FileInputStream(tpf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties(File dir) throws IOException {
        File tpf = new File(dir, "TPF");
        if (!tpf.exists()) {
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(tpf);
                this.props.storeToXML(fos, "Transaction properties");
            }
        }
    }

    @Override
    public String getProperty(String key) {
        String value = this.props.getProperty(key);
        if (value == null && (value = Configuration.getProperty((String)key)) != null) {
            this.props.setProperty(key, value);
        }
        return value;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public Integer getInteger(String key) {
        try {
            return Integer.valueOf(this.getProperty(key));
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public Integer getInteger(String key, int value) {
        Integer result = this.getInteger(key);
        return result == null ? new Integer(value) : result;
    }

    @Override
    public boolean getBoolean(String key) {
        String result = this.getProperty(key);
        return result != null && result.equalsIgnoreCase("true");
    }

    @Override
    public String getObject(String dirname, String name) {
        try {
            byte[] bytes = this.loadByteArray(dirname, name);
            if (bytes != null) {
                return BinaryDump.toHex((byte[])bytes);
            }
            return "null";
        }
        catch (IOException exc) {
            return exc.getMessage();
        }
    }

    @Override
    public String dumpObjectList(String prefix) {
        Object[] list = this.getList(prefix);
        Arrays.sort(list);
        StringBuilder strbuf = new StringBuilder();
        int subidx = prefix.length();
        strbuf.append("TxObjectsX(").append(prefix).append(")[").append(list.length).append("]={");
        for (Object name : list) {
            strbuf.append(((String)name).substring(subidx)).append(", ");
        }
        strbuf.append('}');
        return strbuf.toString();
    }

    @Override
    public String[] getObjectList(String prefix) {
        return this.getList(prefix);
    }
}

