/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.Repository;
import fr.dyade.aaa.util.StartWithFilter;
import fr.dyade.aaa.util.Transaction;
import fr.dyade.aaa.util.backup.BackupFile;
import fr.dyade.aaa.util.backup.BackupRecord;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileRepository
implements Repository {
    File dir = null;
    private int nbsaved = 0;
    private int nbdeleted = 0;
    private int baddeleted = 0;
    private int nbloaded = 0;
    private boolean useFileOutputStream;
    private boolean syncOnWrite = false;
    private String mode = "rw";

    @Override
    public int getNbSavedObjects() {
        return this.nbsaved;
    }

    @Override
    public int getNbDeletedObjects() {
        return this.nbdeleted;
    }

    @Override
    public int getNbBadDeletedObjects() {
        return this.baddeleted;
    }

    @Override
    public int getNbLoadedObjects() {
        return this.nbloaded;
    }

    @Override
    public void init(Transaction transaction, File dir) throws IOException {
        this.dir = dir;
        this.useFileOutputStream = transaction.getBoolean("FileRepository.useRandomAccessFile");
        this.syncOnWrite = transaction.getBoolean("Transaction.SyncOnWrite");
        if (this.syncOnWrite) {
            this.mode = "rwd";
        }
    }

    @Override
    public String[] list(String prefix) throws IOException {
        return this.dir.list(new StartWithFilter(prefix));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void save(String dirName, String name, byte[] content) throws IOException {
        if (dirName == null) {
            file = new File(this.dir, name);
        } else {
            parentDir = new File(this.dir, dirName);
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            file = new File(parentDir, name);
        }
        if (this.useFileOutputStream) {
            fos = new FileOutputStream(file);
            try {
                fos.write(content);
                if (!this.syncOnWrite) ** GOTO lbl26
                fos.getFD().sync();
            }
            finally {
                fos.close();
            }
        } else {
            raf = new RandomAccessFile(file, this.mode);
            try {
                raf.write(content);
            }
            finally {
                raf.close();
            }
        }
        ++this.nbsaved;
    }

    @Override
    public byte[] load(String dirName, String name) throws IOException {
        File file;
        if (dirName == null) {
            file = new File(this.dir, name);
        } else {
            File parentDir = new File(this.dir, dirName);
            file = new File(parentDir, name);
        }
        byte[] buf = null;
        try (FileInputStream fis = new FileInputStream(file);){
            int ret;
            buf = new byte[(int)file.length()];
            for (int nb = 0; nb < buf.length; nb += ret) {
                ret = fis.read(buf, nb, buf.length - nb);
                if (ret != -1) continue;
                throw new EOFException();
            }
        }
        ++this.nbloaded;
        return buf;
    }

    @Override
    public void delete(String dirName, String name) throws IOException {
        if (dirName == null) {
            if (!new File(this.dir, name).delete()) {
                ++this.baddeleted;
            }
        } else {
            File parentDir = new File(this.dir, dirName);
            if (!new File(parentDir, name).delete()) {
                ++this.baddeleted;
            }
            this.deleteDir(parentDir);
        }
        ++this.nbdeleted;
    }

    private final void deleteDir(File dir) {
        String[] children = dir.list();
        if (children != null && children.length == 0) {
            dir.delete();
            if (dir.getAbsolutePath().length() > this.dir.getAbsolutePath().length()) {
                this.deleteDir(dir.getParentFile());
            }
        }
    }

    @Override
    public void commit() throws IOException {
    }

    @Override
    public void backup(BackupFile backup) throws IOException {
        this.backupDir(backup, this.dir, null);
    }

    private void backupDir(BackupFile backup, File currentDir, String path) throws IOException {
        File[] files;
        for (File file : files = currentDir.listFiles()) {
            if (file.isDirectory()) {
                if (path == null) {
                    if (file.getName().equals("felix-cache")) continue;
                    this.backupDir(backup, file, file.getName());
                    continue;
                }
                this.backupDir(backup, file, path + '/' + file.getName());
                continue;
            }
            if (path == null && file.getName().startsWith("log#")) continue;
            this.backupFile(backup, file, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupFile(BackupFile backup, File file, String path) throws IOException {
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(file, "r");
            byte[] buf = new byte[(int)raf.length()];
            raf.readFully(buf);
            backup.backup(new BackupRecord(path, file.getName(), buf));
        }
    }

    @Override
    public void close() throws IOException {
    }
}

