/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class MessageOutputStream
extends OutputStream {
    protected ObjectOutputStream oos;
    protected byte[] buf;
    protected int count;
    protected boolean compressedFlows = false;
    protected static Logger logmon = null;
    private static final byte STREAM_MAGIC1 = -84;
    private static final byte STREAM_MAGIC2 = -19;
    private static final byte STREAM_VERSION1 = 0;
    private static final byte STREAM_VERSION2 = 5;

    protected static Logger getLogger() {
        if (logmon == null) {
            logmon = Debug.getLogger("fr.dyade.aaa.agent.MessageOutputStream");
        }
        return logmon;
    }

    public MessageOutputStream() throws IOException {
        this(8192);
    }

    public MessageOutputStream(int size) throws IOException {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        if (!this.compressedFlows) {
            this.oos = new ObjectOutputStream(this);
        }
        this.count = 0;
    }

    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    protected final void writeShort(short s) {
        this.buf[this.count++] = (byte)(s >>> 8);
        this.buf[this.count++] = (byte)(s >>> 0);
    }

    protected final void writeInt(int i) {
        this.buf[this.count++] = (byte)(i >>> 24);
        this.buf[this.count++] = (byte)(i >>> 16);
        this.buf[this.count++] = (byte)(i >>> 8);
        this.buf[this.count++] = (byte)(i >>> 0);
    }

    protected abstract void writeHeader() throws IOException;

    protected final void writeMessageHeader(Message msg) {
        if (MessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)"writeMessageHeader()");
        }
        this.writeShort(msg.from.from);
        this.writeShort(msg.from.to);
        this.writeInt(msg.from.stamp);
        this.writeShort(msg.to.from);
        this.writeShort(msg.to.to);
        this.writeInt(msg.to.stamp);
        this.writeShort(msg.source);
        this.writeShort(msg.dest);
        this.writeInt(msg.stamp);
        if (MessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)"writeMessageHeader returns");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeMessage(Message msg, long time) throws IOException {
        if (MessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)"writeMessage()");
        }
        this.writeHeader();
        if (msg != null) {
            this.writeMessageHeader(msg);
            if (msg.not == null) {
                if (MessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    MessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)"writeMessage - 1");
                }
                this.buf[this.count++] = 0;
                this.flush();
            } else {
                if (MessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    MessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)"writeMessage - 2");
                }
                this.buf[this.count++] = msg.optToByte();
                try {
                    if (msg.not.expiration > 0L) {
                        msg.not.expiration -= time;
                    }
                    if (this.compressedFlows) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        GZIPOutputStream gzipos = new GZIPOutputStream(baos);
                        this.oos = new ObjectOutputStream(gzipos);
                        this.oos.writeObject(msg.not);
                        this.oos.reset();
                        this.oos.flush();
                        gzipos.finish();
                        gzipos.flush();
                        if (MessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                            MessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)("writeNotification - size=" + baos.size()));
                        }
                        this.writeInt(baos.size());
                        baos.writeTo(this);
                        this.flush();
                        this.oos = null;
                    }
                    this.buf[this.count++] = -84;
                    this.buf[this.count++] = -19;
                    this.buf[this.count++] = 0;
                    this.buf[this.count++] = 5;
                    this.oos.writeObject(msg.not);
                    this.oos.reset();
                    this.oos.flush();
                }
                finally {
                    if (msg.not != null && msg.not.expiration > 0L) {
                        msg.not.expiration += time;
                    }
                }
            }
        } else {
            this.flush();
        }
        if (MessageOutputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            MessageOutputStream.getLogger().log(BasicLevel.DEBUG, (Object)"writeMessage returns");
        }
    }
}

