/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.SCServerMBean;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.monitoring.DumpAttributes;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SCServer
implements SCServerMBean {
    public static Logger logger = Debug.getLogger(SCServer.class.getName());

    @Override
    public short getServerId() {
        return AgentServer.getServerId();
    }

    @Override
    public String getName() {
        return AgentServer.getName();
    }

    @Override
    public void start() {
        try {
            AgentServer.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        AgentServer.stop(false);
    }

    @Override
    public void shutdown() {
        AgentServer.shutdown();
    }

    @Override
    public int getStatus() {
        return AgentServer.getStatus();
    }

    @Override
    public String getStatusInfo() {
        return AgentServer.getStatusInfo();
    }

    @Override
    public String[] getServers() {
        Enumeration<ServerDesc> e = AgentServer.elementsServerDesc();
        String[] servers = new String[AgentServer.getServerNb()];
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        while (e.hasMoreElements()) {
            ServerDesc server = e.nextElement();
            strBuf.append("sid=").append(server.sid);
            strBuf.append(",name=").append(server.name);
            if (server.gateway == -1) {
                strBuf.append(",gateway=").append(server.gateway);
            } else {
                strBuf.append(",host=").append(server.getHostname()).append(':').append(server.getPort());
                strBuf.append(",active=").append(server.active);
                strBuf.append(",last=").append(server.last);
            }
            servers[i] = strBuf.toString();
            strBuf.setLength(0);
            ++i;
        }
        return servers;
    }

    @Override
    public void dumpServerState(String path) {
        SCServer.dumpServerState(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpServerState(String path, String cause) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(path, true);
            StringBuffer strbuf = new StringBuffer();
            if (cause != null) {
                writer.write("\n===== Dump cause =====\n\n");
                writer.write(cause);
                writer.write("\n");
            }
            writer.write("\n===== MBean's attributes =====\n\n");
            DumpAttributes.dumpAttributes("*:*", strbuf);
            writer.write(strbuf.toString());
            writer.flush();
            strbuf.setLength(0);
            writer.write("\n===== Thread's stack traces =====\n\n");
            DumpAttributes.dumpAllStackTraces(strbuf);
            writer.write(strbuf.toString());
            writer.flush();
            strbuf.setLength(0);
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)("MqttCheckActivator.dumpServerState, cannot open dump file \"" + path + "\""), (Throwable)exc);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void dumpAttributes(String name, String path, boolean threaddump) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(path, true);
            StringBuffer strbuf = new StringBuffer();
            DumpAttributes.dumpAttributes(name, strbuf);
            if (threaddump) {
                DumpAttributes.dumpAllStackTraces(strbuf);
            }
            writer.write(strbuf.toString());
            writer.close();
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)("SCServer.dumpAttributes, cannot open dump file \"" + path + "\""), (Throwable)exc);
        }
    }

    @Override
    public void debug(String classname) {
        Debug.getLogger(classname).setIntLevel(BasicLevel.DEBUG);
    }

    @Override
    public void info(String classname) {
        Debug.getLogger(classname).setIntLevel(BasicLevel.INFO);
    }

    @Override
    public void warn(String classname) {
        Debug.getLogger(classname).setIntLevel(BasicLevel.WARN);
    }

    @Override
    public void error(String classname) {
        Debug.getLogger(classname).setIntLevel(BasicLevel.ERROR);
    }

    @Override
    public void fatal(String classname) {
        Debug.getLogger(classname).setIntLevel(BasicLevel.FATAL);
    }

    @Override
    public void clear(String classname) {
        Debug.getLogger(classname).setIntLevel(BasicLevel.INHERIT);
    }

    @Override
    public String backup(String path) throws Exception {
        if (AgentServer.getTransaction() != null) {
            return AgentServer.getTransaction().backup(path);
        }
        throw new IllegalStateException("Can't backup, Transaction module is not initialized.");
    }
}

