/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.ServerDesc;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ServersHT {
    private transient ServerDescEntry[] table = new ServerDescEntry[13];
    private transient int count;
    private static final int initialCapacity = 13;
    private static final float loadFactor = 0.75f;
    private int threshold = 9;
    private static final int KEYS = 0;
    private static final int VALUES = 1;

    public synchronized int size() {
        return this.count;
    }

    public synchronized Enumeration<Short> keys() {
        return new Enumerator(0);
    }

    public synchronized Enumeration<ServerDesc> elements() {
        return new Enumerator(1);
    }

    public synchronized ServerDesc get(short sid) {
        ServerDescEntry[] tab = this.table;
        int index = (sid & Short.MAX_VALUE) % tab.length;
        ServerDescEntry e = tab[index];
        while (e != null) {
            if (e.desc.sid == sid) {
                return e.desc;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        ServerDescEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        ServerDescEntry[] newMap = new ServerDescEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            ServerDescEntry old = oldMap[i];
            while (old != null) {
                ServerDescEntry e = old;
                old = old.next;
                int index = (e.desc.sid & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized ServerDesc put(ServerDesc desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        ServerDescEntry[] tab = this.table;
        int index = (desc.sid & Short.MAX_VALUE) % tab.length;
        ServerDescEntry e = tab[index];
        while (e != null) {
            if (e.desc.sid == desc.sid) {
                ServerDesc old = e.desc;
                e.desc = desc;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (desc.sid & Short.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new ServerDescEntry(desc, tab[index]);
        ++this.count;
        return null;
    }

    public synchronized ServerDesc remove(short sid) {
        ServerDescEntry[] tab = this.table;
        int index = (sid & Short.MAX_VALUE) % tab.length;
        ServerDescEntry e = tab[index];
        ServerDescEntry prev = null;
        while (e != null) {
            if (e.desc.sid == sid) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                ServerDesc oldDesc = e.desc;
                e.desc = null;
                return oldDesc;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        ServerDescEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(").append(super.toString());
        buf.append(")");
        return buf.toString();
    }

    private class Enumerator
    implements Enumeration {
        ServerDescEntry[] table;
        int index;
        ServerDescEntry entry;
        int type;

        Enumerator(int type) {
            this.table = ServersHT.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            ServerDescEntry e = this.entry;
            int i = this.index;
            ServerDescEntry[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        public Object nextElement() {
            ServerDescEntry et = this.entry;
            int i = this.index;
            ServerDescEntry[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                ServerDescEntry e = this.entry;
                this.entry = e.next;
                return this.type == 0 ? new Short(e.desc.sid) : e.desc;
            }
            throw new NoSuchElementException("ServersHT Enumerator");
        }
    }

    private static final class ServerDescEntry {
        ServerDesc desc;
        ServerDescEntry next;

        protected ServerDescEntry(ServerDesc desc, ServerDescEntry next) {
            this.desc = desc;
            this.next = next;
        }

        public String toString() {
            return this.desc.toString();
        }
    }
}

