/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import fr.dyade.aaa.common.Debug;
import java.lang.management.ManagementFactory;
import java.util.Timer;
import java.util.TimerTask;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class AverageCPUTask
extends TimerTask {
    private Logger logger;
    long[] cpuTime;
    int idx;
    int nb;
    private long id;
    private String name;
    private int average;

    public int getAverage() {
        return this.average;
    }

    public AverageCPUTask(long id, int nb) {
        this.id = id;
        this.name = ManagementFactory.getThreadMXBean().getThreadInfo(id).getThreadName();
        this.logger = Debug.getLogger(AverageCPUTask.class.getName() + '.' + this.name);
        this.nb = nb;
        this.cpuTime = new long[nb];
        this.idx = 0;
    }

    @Override
    public void run() {
        try {
            this.cpuTime[this.idx % this.nb] = ManagementFactory.getThreadMXBean().getThreadCpuTime(this.id);
            this.average = (int)((this.cpuTime[this.idx % this.nb] - this.cpuTime[(this.idx + 1) % this.nb]) / 600000000L);
            this.logger.log(BasicLevel.DEBUG, (Object)("AverageCPUTask: " + this.name + " CPU Time: " + this.cpuTime[this.idx % this.nb] + "ns -> " + this.average));
            ++this.idx;
        }
        catch (Throwable t) {
            this.logger.log(BasicLevel.WARN, (Object)"AverageCPUTask.run", t);
        }
    }

    public void start(Timer timer) {
        long period = 60000L / (long)this.nb;
        timer.scheduleAtFixedRate((TimerTask)this, period, period);
    }
}

