/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.encoding;

import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encodable;
import fr.dyade.aaa.common.encoding.EncodableFactory;
import fr.dyade.aaa.common.encoding.EncodedString;
import fr.dyade.aaa.common.encoding.Encoder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EncodedStringList
implements Serializable,
Encodable {
    private List<EncodedString> list = new ArrayList<EncodedString>();

    public List<EncodedString> getList() {
        return this.list;
    }

    @Override
    public int getEncodableClassId() {
        return 4;
    }

    @Override
    public int getEncodedSize() throws Exception {
        int res = 4;
        for (EncodedString str : this.list) {
            res += str.getEncodedSize();
        }
        return res;
    }

    @Override
    public void encode(Encoder encoder) throws Exception {
        encoder.encode32(this.list.size());
        for (EncodedString str : this.list) {
            str.encode(encoder);
        }
    }

    @Override
    public void decode(Decoder decoder) throws Exception {
        int l = decoder.decode32();
        this.list = new ArrayList<EncodedString>(l);
        for (int i = 0; i < l; ++i) {
            EncodedString str = new EncodedString();
            this.list.add(str);
            str.decode(decoder);
        }
    }

    public static class Factory
    implements EncodableFactory {
        @Override
        public Encodable createEncodable() {
            return new EncodedStringList();
        }
    }
}

