/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.net;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.net.SocketFactory13;
import fr.dyade.aaa.common.net.SocketFactory14;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class SocketFactory {
    static Logger logger = Debug.getLogger(SocketFactory.class.getName());
    public static final String DefaultFactory = SocketFactory14.class.getName();
    private static String[] factoryClasses = new String[]{DefaultFactory, SocketFactory13.class.getName()};
    private static SocketFactory factory;

    public static SocketFactory getDefaultFactory() {
        SocketFactory socketFactory = null;
        try {
            Class<?> factoryClass = Class.forName(DefaultFactory);
            Method method = factoryClass.getMethod("getFactory", null);
            socketFactory = (SocketFactory)method.invoke(null, (Object[])null);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to instantiate default SocketFactory: " + DefaultFactory), (Throwable)exc);
        }
        return socketFactory;
    }

    public static SocketFactory getFactory(String sfcn) {
        SocketFactory socketFactory = null;
        try {
            Class<?> factoryClass = Class.forName(sfcn);
            Method method = factoryClass.getMethod("getFactory", null);
            socketFactory = (SocketFactory)method.invoke(null, (Object[])null);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)("Use default SocketFactory, unable to instantiate : " + sfcn), (Throwable)exc);
            socketFactory = SocketFactory.getDefaultFactory();
        }
        return socketFactory;
    }

    public abstract Socket createSocket(InetAddress var1, int var2, int var3) throws IOException;

    public abstract Socket createSocket(InetAddress var1, int var2, InetAddress var3, int var4, int var5) throws IOException;

    public static SocketFactory getSocketFactory() throws Exception {
        if (factory == null) {
            Class<?> clazz = null;
            for (int i = 0; i < factoryClasses.length; ++i) {
                try {
                    clazz = Class.forName(factoryClasses[i]);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz != null) {
                Method method = clazz.getMethod("getFactory", null);
                factory = (SocketFactory)method.invoke(null, (Object[])null);
            } else {
                throw new Exception("Socket factory class not found");
            }
        }
        return factory;
    }
}

