/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.stream;

import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encodable;
import fr.dyade.aaa.common.encoding.EncodableHelper;
import fr.dyade.aaa.common.encoding.Encoder;
import fr.dyade.aaa.common.stream.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;

public class Properties
implements Serializable,
Cloneable,
Encodable {
    private transient int count;
    private transient Entry[] table;
    private transient int threshold;
    private transient float loadFactor;
    private transient int modCount = 0;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static EmptyEnumerator emptyEnumerator = new EmptyEnumerator();

    public Properties(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        this.initialize(initialCapacity, loadFactor);
    }

    private void initialize(int initialCapacity, float loadFactor) {
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Properties(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Properties() {
        this(11, 0.75f);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return this.getEnumeration(0);
    }

    public synchronized Enumeration elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean containsKey(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object setProperty(String key, Object value) throws ClassCastException {
        if (value instanceof Boolean || value instanceof Number || value instanceof String) {
            return this.put(key, value);
        }
        throw new ClassCastException("Bad property value: " + value.getClass());
    }

    public synchronized Object put(String key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public synchronized Object remove(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            Properties t = (Properties)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(").append(super.toString());
        buf.append("}");
        return buf.toString();
    }

    private Enumeration getEnumeration(int type) {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(type, false);
    }

    public synchronized int hashCode() {
        int h = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return h;
        }
        this.loadFactor = -this.loadFactor;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                h += e.key.hashCode() ^ e.value.hashCode();
                e = e.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return h;
    }

    public void copyInto(Map h) {
        if (this.count > 0) {
            for (int index = this.table.length - 1; index >= 0; --index) {
                Entry entry = this.table[index];
                while (entry != null) {
                    h.put(entry.key, entry.value);
                    entry = entry.next;
                }
            }
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        StreamUtil.writeTo(this.count, os);
        if (this.count == 0) {
            return;
        }
        for (int index = this.table.length - 1; index >= 0; --index) {
            Entry entry = this.table[index];
            while (entry != null) {
                StreamUtil.writeTo(entry.key, os);
                StreamUtil.writeObjectTo(entry.value, os);
                entry = entry.next;
            }
        }
    }

    public static Properties readFrom(InputStream is) throws IOException {
        int count = StreamUtil.readIntFrom(is);
        if (count == -1) {
            return null;
        }
        Properties p = new Properties(4 * count / 3 + 1);
        p.readFrom(is, count);
        return p;
    }

    public void readFrom(InputStream is, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            String key = StreamUtil.readStringFrom(is);
            Object value = StreamUtil.readObjectFrom(is);
            this.put(key, value);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int count = StreamUtil.readIntFrom(in);
        if (count <= 0) {
            return;
        }
        this.initialize(4 * count / 3 + 1, 0.75f);
        this.readFrom(in, count);
    }

    @Override
    public int getEncodedSize() throws IOException {
        int size = 0;
        size += 4;
        for (int index = this.table.length - 1; index >= 0; --index) {
            Entry entry = this.table[index];
            while (entry != null) {
                size += EncodableHelper.getStringEncodedSize(entry.key);
                size += StreamUtil.getEncodedSize(entry.value);
                entry = entry.next;
            }
        }
        return size;
    }

    @Override
    public int getEncodableClassId() {
        return 3;
    }

    @Override
    public void encode(Encoder encoder) throws Exception {
        encoder.encodeUnsignedInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            Entry entry = this.table[index];
            while (entry != null) {
                encoder.encodeString(entry.key);
                StreamUtil.encodeValue(entry.value, encoder);
                entry = entry.next;
            }
        }
    }

    @Override
    public void decode(Decoder decoder) throws Exception {
        int count = decoder.decodeUnsignedInt();
        if (count == -1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            String key = decoder.decodeString();
            Object value = StreamUtil.decodeValue(decoder);
            this.put(key, value);
        }
    }

    private static class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("Properties Enumerator");
        }
    }

    private class Enumerator
    implements Enumeration {
        Entry[] table;
        int index;
        Entry entry;
        int type;

        Enumerator(int type, boolean iterator) {
            this.table = Properties.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            Entry e = this.entry;
            int i = this.index;
            Entry[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        public Object nextElement() {
            Entry et = this.entry;
            int i = this.index;
            Entry[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                Entry e = this.entry;
                this.entry = e.next;
                return this.type == 0 ? e.key : (this.type == 1 ? e.value : e);
            }
            throw new NoSuchElementException("Properties Enumerator");
        }
    }

    private static class Entry {
        int hash;
        String key;
        Object value;
        Entry next;

        protected Entry(int hash, String key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value.toString();
        }
    }
}

