/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.ATransactionMBean;
import fr.dyade.aaa.util.AbstractTransaction;
import fr.dyade.aaa.util.Operation;
import fr.dyade.aaa.util.OperationKey;
import fr.dyade.aaa.util.StartWithFilter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.util.monolog.api.BasicLevel;

public final class ATransaction
extends AbstractTransaction
implements ATransactionMBean,
Runnable {
    static final int CLEANUP_THRESHOLD_COMMIT = 9600;
    static final int CLEANUP_THRESHOLD_OPERATION = 36000;
    static final int CLEANUP_THRESHOLD_SIZE = 0x800000;
    private int operationCount = 0;
    private int cumulativeSize = 0;
    private int commitCount = 0;
    private Hashtable clog = null;
    private Hashtable plog = null;
    private static final String LOG = "log";
    private static final String PLOG = "plog";
    protected File logFilePN = null;
    protected File plogFilePN = null;
    private boolean garbage;
    private Object lock = null;
    private boolean isRunning;
    private Thread gThread = null;
    static final boolean debug = false;
    private static final byte[] emptyUTFString = new byte[]{0, 0};
    private static ByteArrayOutputStream baos = null;
    private static DataOutputStream dos = null;
    protected RandomAccessFile logFile = null;
    protected FileDescriptor logFD = null;

    @Override
    public final int getCommitCount() {
        return this.commitCount;
    }

    @Override
    public final void initRepository() throws IOException {
        Operation.initPool(36000);
        this.logFilePN = new File(this.dir, LOG);
        this.plogFilePN = new File(this.dir, PLOG);
        Hashtable tempLog = new Hashtable();
        this.restart(tempLog, this.logFilePN);
        this.restart(tempLog, this.plogFilePN);
        this.commit(tempLog);
        this.plogFilePN.delete();
        this.logFilePN.delete();
        this.clog = new Hashtable(18000);
        this.plog = new Hashtable(18000);
        baos = new ByteArrayOutputStream(10240);
        dos = new DataOutputStream(baos);
        this.newLogFile();
        this.lock = new Object();
        this.garbage = false;
        this.gThread = new Thread((Runnable)this, "TGarbage");
        this.gThread.start();
    }

    private final void restart(Hashtable log, File logFilePN) throws IOException {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"ATransaction, restart");
        }
        if (logFilePN.exists() && logFilePN.length() > 0L) {
            RandomAccessFile logFile = new RandomAccessFile(logFilePN, "r");
            try {
                Hashtable<Object, Operation> templog = new Hashtable<Object, Operation>();
                while (true) {
                    int optype;
                    if ((optype = logFile.read()) != 3) {
                        String dirName = logFile.readUTF();
                        if (dirName.length() == 0) {
                            dirName = null;
                        }
                        String name = logFile.readUTF();
                        Object key = OperationKey.newKey(dirName, name);
                        Operation op = null;
                        if (optype == 1) {
                            byte[] buf = new byte[logFile.readInt()];
                            logFile.readFully(buf);
                            op = Operation.alloc(optype, dirName, name, buf);
                            op = templog.put(key, op);
                        } else {
                            op = Operation.alloc(optype, dirName, name);
                            op = templog.put(key, op);
                        }
                        if (op == null) continue;
                        op.free();
                        continue;
                    }
                    log.putAll(templog);
                    templog.clear();
                }
            }
            catch (EOFException exc) {
                logFile.close();
            }
            catch (IOException exc) {
                logFile.close();
                throw exc;
            }
        }
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"ATransaction, started");
        }
    }

    public final File getDir() {
        return this.dir;
    }

    @Override
    protected final void setPhase(int newPhase) {
        this.phase = newPhase;
    }

    @Override
    public final String[] getList(String prefix) {
        return this.dir.list(new StartWithFilter(prefix));
    }

    @Override
    protected final void saveInLog(byte[] buf, String dirName, String name, Hashtable log, boolean copy, boolean first) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("ATransaction, saveInLog(" + dirName + '/' + name + ", " + copy + ", " + first + ")"));
        }
        Object key = OperationKey.newKey(dirName, name);
        Operation op = Operation.alloc(1, dirName, name, buf);
        Operation old = log.put(key, op);
        if (copy) {
            op.value = old != null && old.type == 1 && old.value.length == buf.length ? old.value : new byte[buf.length];
            System.arraycopy(buf, 0, op.value, 0, buf.length);
        }
        if (old != null) {
            old.free();
        }
    }

    private final byte[] getFromLog(Hashtable log, Object key) throws IOException {
        Operation op = (Operation)log.get(key);
        if (op != null) {
            if (op.type == 1) {
                return op.value;
            }
            if (op.type == 2) {
                throw new FileNotFoundException();
            }
        }
        return null;
    }

    private final byte[] getFromLog(String dirName, String name) throws IOException {
        Object key = OperationKey.newKey(dirName, name);
        byte[] buf = this.getFromLog(((AbstractTransaction.Context)this.perThreadContext.get()).getLog(), key);
        if (buf != null) {
            return buf;
        }
        buf = this.getFromLog(this.clog, key);
        if (buf != null || (buf = this.getFromLog(this.plog, key)) != null) {
            return buf;
        }
        return null;
    }

    @Override
    public final byte[] loadByteArray(String dirName, String name) throws IOException {
        try {
            int ret;
            File file;
            byte[] buf = this.getFromLog(dirName, name);
            if (buf != null) {
                return buf;
            }
            if (dirName == null) {
                file = new File(this.dir, name);
            } else {
                File parentDir = new File(this.dir, dirName);
                file = new File(parentDir, name);
            }
            FileInputStream fis = new FileInputStream(file);
            buf = new byte[(int)file.length()];
            for (int nb = 0; nb < buf.length; nb += ret) {
                ret = fis.read(buf, nb, buf.length - nb);
                if (ret != -1) continue;
                throw new EOFException();
            }
            fis.close();
            return buf;
        }
        catch (FileNotFoundException exc) {
            return null;
        }
    }

    @Override
    public final void delete(String dirName, String name) {
        Object key = OperationKey.newKey(dirName, name);
        Hashtable log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog();
        Operation op = Operation.alloc(2, dirName, name);
        if ((op = log.put(key, op)) != null) {
            op.free();
        }
    }

    @Override
    public void commit(boolean release) throws IOException {
        if (this.phase != 2) {
            throw new IllegalStateException("Can not commit.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"ATransaction, commit");
        }
        ++this.commitCount;
        Hashtable log = ((AbstractTransaction.Context)this.perThreadContext.get()).getLog();
        if (!log.isEmpty()) {
            Operation op = null;
            Enumeration e = log.elements();
            while (e.hasMoreElements()) {
                op = (Operation)e.nextElement();
                ++this.operationCount;
                dos.write(op.type);
                if (op.dirName != null) {
                    dos.writeUTF(op.dirName);
                } else {
                    dos.write(emptyUTFString);
                }
                dos.writeUTF(op.name);
                if (op.type == 1) {
                    dos.writeInt(op.value.length);
                    dos.write(op.value);
                    this.cumulativeSize += op.value.length;
                }
                if ((op = this.clog.put(OperationKey.newKey(op.dirName, op.name), op)) == null) continue;
                op.free();
            }
            dos.writeByte(3);
            dos.flush();
            this.logFile.write(baos.toByteArray());
            baos.reset();
            this.syncLogFile();
            log.clear();
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"ATransaction, committed");
        }
        this.setPhase(3);
        if (release) {
            this.release();
        }
    }

    protected void newLogFile() throws IOException {
        this.logFile = new RandomAccessFile(this.logFilePN, "rw");
        this.logFD = this.logFile.getFD();
    }

    protected void syncLogFile() throws IOException {
        this.logFD.sync();
    }

    public final synchronized void rollback() {
        if (this.phase != 2) {
            throw new IllegalStateException("Can not rollback.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"ATransaction, rollback");
        }
        this.setPhase(4);
        ((AbstractTransaction.Context)this.perThreadContext.get()).getLog().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void release() throws IOException {
        if (this.phase != 2 && this.phase != 3 && this.phase != 4) {
            throw new IllegalStateException("Can not release transaction.");
        }
        if (!(this.commitCount <= 9600 && this.operationCount <= 36000 && this.cumulativeSize <= 0x800000 || this.garbage)) {
            Object object = this.lock;
            synchronized (object) {
                this.garbage = true;
                this.setPhase(5);
                this.lock.notify();
            }
        } else {
            this.setPhase(1);
            this.notify();
        }
    }

    private final void commit(Hashtable log) throws IOException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("ATransaction, Commit(" + log + ")"));
        }
        Operation op = null;
        Enumeration e = log.elements();
        while (e.hasMoreElements()) {
            File file;
            op = (Operation)e.nextElement();
            if (op.type == 1) {
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("ATransaction, Save (" + op.dirName + ',' + op.name + ')'));
                }
                if (op.dirName == null) {
                    file = new File(this.dir, op.name);
                } else {
                    File parentDir = new File(this.dir, op.dirName);
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    file = new File(parentDir, op.name);
                }
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(op.value);
                fos.getFD().sync();
                fos.close();
            } else if (op.type == 2) {
                boolean deleted;
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)("ATransaction, Delete (" + op.dirName + ',' + op.name + ')'));
                }
                if (op.dirName == null) {
                    file = new File(this.dir, op.name);
                    deleted = file.delete();
                } else {
                    File parentDir = new File(this.dir, op.dirName);
                    file = new File(parentDir, op.name);
                    deleted = file.delete();
                    this.deleteDir(parentDir);
                }
                if (!deleted && file.exists()) {
                    logmon.log(BasicLevel.ERROR, (Object)("ATransaction, can't delete " + file.getCanonicalPath()));
                }
            }
            op.free();
        }
        ++this.commitCount;
        log.clear();
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)"ATransaction, Committed");
        }
    }

    private final void deleteDir(File dir) {
        String[] children = dir.list();
        if (children != null && children.length == 0) {
            dir.delete();
            if (dir.getAbsolutePath().length() > this.dir.getAbsolutePath().length()) {
                this.deleteDir(dir.getParentFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void _stop() {
        Object object = this.lock;
        synchronized (object) {
            while (this.phase != 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setPhase(6);
            this.isRunning = false;
            this.garbage = true;
            this.lock.notify();
        }
    }

    @Override
    public final void stop() {
        block4: {
            if (logmon.isLoggable(BasicLevel.INFO)) {
                logmon.log(BasicLevel.INFO, (Object)"ATransaction, stops");
            }
            this._stop();
            try {
                this.gThread.join();
            }
            catch (InterruptedException exc3) {
                if (!logmon.isLoggable(BasicLevel.WARN)) break block4;
                logmon.log(BasicLevel.WARN, (Object)"ATransaction, interrupted");
            }
        }
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"ATransaction, stopped");
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            while (this.isRunning || this.garbage) {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.garbage) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.garbage = false;
                }
                this.wakeup();
            }
        }
        catch (IOException exc) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"ATransaction, tgarbage", (Throwable)exc);
            }
            exc.printStackTrace();
        }
        finally {
            this.isRunning = false;
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)"ATransaction, ends");
            }
            try {
                this.logFile.close();
            }
            catch (IOException exc) {
                logmon.log(BasicLevel.WARN, (Object)"ATransaction, can't close logfile", (Throwable)exc);
            }
            if (logmon.isLoggable(BasicLevel.INFO)) {
                logmon.log(BasicLevel.INFO, (Object)"ATransaction, exits.");
            }
        }
    }

    private synchronized void _release() throws IOException {
        this.setPhase(1);
        this.notify();
    }

    private final void wakeup() throws IOException {
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)("ATransaction, Wakeup: " + this.commitCount + ", " + this.operationCount + ", " + this.cumulativeSize));
        }
        this.cumulativeSize = 0;
        this.operationCount = 0;
        this.commitCount = 0;
        Hashtable templog = this.plog;
        this.plog = this.clog;
        this.clog = templog;
        this.logFile.close();
        this.logFilePN.renameTo(this.plogFilePN);
        this.newLogFile();
        this._release();
        this.commit(this.plog);
        this.plogFilePN.delete();
        if (logmon.isLoggable(BasicLevel.INFO)) {
            logmon.log(BasicLevel.INFO, (Object)"ATransaction, Wakeup: end");
        }
    }

    @Override
    public String backup(String path) throws Exception {
        throw new UnsupportedOperationException("Backup operation not already implemented.");
    }
}

