/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.util.HashMap;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;
import org.objectweb.util.monolog.wrapper.common.RelatifEnvironmentPathGetter;
import org.objectweb.util.monolog.wrapper.log4j.PatternConverter;

public class JMXHandler
extends AppenderSkeleton
implements NotificationEmitter,
Handler {
    protected HashMap prop = null;
    CustomNotificationBroadcasterSupport emitter = new CustomNotificationBroadcasterSupport();
    private long notificationSequence = 0L;

    public JMXHandler() {
    }

    public JMXHandler(String name) {
        this.setName(name);
        this.prop = new HashMap();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.emitter.getNotificationInfo();
    }

    public Map getAttributes() {
        return this.prop;
    }

    public void setAttributes(Map attributes) {
        this.prop.clear();
        this.prop.putAll(attributes);
        Object mf = this.prop.get("activation");
        if (mf != null) {
            this.prop.remove("activation");
            this.setAttribute("activation", mf);
        }
    }

    public String getType() {
        return "jmx";
    }

    public String[] getAttributeNames() {
        return this.prop.keySet().toArray(new String[0]);
    }

    public Object getAttribute(String key) {
        return this.prop.get(key);
    }

    public Object setAttribute(String key, Object value) {
        String level;
        if (this.prop == null) {
            this.prop = new HashMap();
        }
        if (!key.equalsIgnoreCase("activation")) {
            return this.prop.put(key, value);
        }
        if (this.prop.containsKey(key)) {
            return null;
        }
        MonologFactory mf = (MonologFactory)value;
        String pattern = (String)this.prop.get("pattern");
        if (pattern != null) {
            this.setLayout((Layout)new PatternLayout(PatternConverter.monolog2log4j(pattern)));
        }
        if ((level = (String)this.prop.get("level")) != null && level.length() > 0) {
            int levelVal = LevelImpl.evaluate(level, mf);
            this.setThreshold((Priority)Level.toLevel((int)levelVal));
        }
        String output = (String)this.prop.get("output");
        output = RelatifEnvironmentPathGetter.getRealPath(output);
        super.activateOptions();
        return null;
    }

    public void doAppend(LoggingEvent event) {
        Notification notification = new Notification("Monolog.JMXHandler.Log", "JMXHandler:Type=Log4j", ++this.notificationSequence, System.currentTimeMillis(), event.getMessage().toString());
        notification.setUserData(event);
        this.emitter.sendNotification(notification);
    }

    protected void append(LoggingEvent event) {
        this.append(event);
    }

    public void close() {
        if (this != null) {
            this.close();
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    class CustomNotificationBroadcasterSupport
    extends NotificationBroadcasterSupport {
        CustomNotificationBroadcasterSupport() {
        }

        public void sendNotification(Notification notification) {
            super.sendNotification(notification);
        }
    }
}

