/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.remote.lib;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;
import org.objectweb.util.monolog.wrapper.remote.api.LoggerInfo;
import org.objectweb.util.monolog.wrapper.remote.api.MonologFactoryProxy;

public class MonologFactoryProxyImpl
extends UnicastRemoteObject
implements MonologFactoryProxy {
    private MonologFactory mf;

    public MonologFactoryProxyImpl() throws RemoteException {
        this(Monolog.initialize());
    }

    public MonologFactoryProxyImpl(MonologFactory mf) throws RemoteException {
        this.mf = mf;
    }

    public MonologFactoryProxyImpl(MonologFactory mf, String rmiName) throws RemoteException {
        this.mf = mf;
        this.register(rmiName);
    }

    public void register(String name) throws RemoteException {
        try {
            this.register(InetAddress.getLocalHost(), name);
        }
        catch (UnknownHostException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void register(InetAddress host, String name) throws RemoteException {
        try {
            Naming.rebind("rmi://" + host + "/" + name, this);
        }
        catch (MalformedURLException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean defineLevel(String name, int value) throws RemoteException {
        return this.mf.defineLevel(name, value) != null;
    }

    public boolean defineLevel(String name, String value) throws RemoteException {
        return this.mf.defineLevel(name, value) != null;
    }

    public void removeLevel(String name) throws RemoteException {
        this.mf.removeLevel(name);
    }

    public Level getLevel(String name) throws RemoteException {
        return this.mf.getLevel(name);
    }

    public Level getLevel(int value) throws RemoteException {
        return this.mf.getLevel(value);
    }

    public Level[] getLevels() throws RemoteException {
        return this.mf.getLevels();
    }

    public int compareTo(String levelname1, String levelname2) throws RemoteException {
        Level l1 = this.mf.getLevel(levelname1);
        if (l1 == null) {
            return Integer.MAX_VALUE;
        }
        Level l2 = this.mf.getLevel(levelname2);
        if (l1 == null) {
            return Integer.MIN_VALUE;
        }
        return l1.compareTo(l2);
    }

    public boolean createHandler(String hn, String handlertype) throws RemoteException {
        return this.mf.createHandler(hn, handlertype) != null;
    }

    public boolean removeHandler(String handlername) throws RemoteException {
        return this.mf.removeHandler(handlername) == null;
    }

    public String[] getHandlerNames() throws RemoteException {
        Handler[] hs = this.mf.getHandlers();
        String[] hns = new String[hs.length];
        for (int i = 0; i < hs.length; ++i) {
            hns[i] = hs[i].getName();
        }
        return hns;
    }

    public Map getHandlerAttributes(String handlername) throws RemoteException {
        Handler h = this.mf.getHandler(handlername);
        String[] ans = h.getAttributeNames();
        HashMap<String, Object> m = new HashMap<String, Object>(ans.length);
        for (int i = 0; i < ans.length; ++i) {
            m.put(ans[i], h.getAttribute(ans[i]));
        }
        return m;
    }

    public Map getAllHandlerAttributes() throws RemoteException {
        Handler[] hs = this.mf.getHandlers();
        HashMap<Handler, Map> m = new HashMap<Handler, Map>(hs.length);
        for (int i = 0; i < hs.length; ++i) {
            m.put(hs[i], this.getHandlerAttributes(hs[i].getName()));
        }
        return m;
    }

    public void setHandlerAttribute(String handlername, String attributeName, String value) throws RemoteException {
        Handler h = this.mf.getHandler(handlername);
        if (h == null) {
            throw new RemoteException("No handler '" + handlername + "' found.");
        }
        h.setAttribute(attributeName, value);
    }

    public LoggerInfo getLogger(String loggername) throws RemoteException {
        return new LoggerInfo((TopicalLogger)this.mf.getLogger(loggername));
    }

    public LoggerInfo getLogger(String loggername, String resourceBundleName) throws RemoteException {
        return new LoggerInfo((TopicalLogger)this.mf.getLogger(loggername, resourceBundleName));
    }

    public String getResourceBundleName() throws RemoteException {
        return this.mf.getResourceBundleName();
    }

    public void setResourceBundleName(String resourceBundleName) throws RemoteException {
        this.mf.setResourceBundleName(resourceBundleName);
    }

    public LoggerInfo[] getLoggers() throws RemoteException {
        Logger[] ls = this.mf.getLoggers();
        LoggerInfo[] lis = new LoggerInfo[ls.length];
        for (int i = 0; i < ls.length; ++i) {
            lis[i] = new LoggerInfo((TopicalLogger)ls[i]);
        }
        return lis;
    }

    public void addHandlerToLogger(String handlername, String loggerName) throws RemoteException {
        Handler h = this.mf.getHandler(handlername);
        if (h == null) {
            throw new RemoteException("No handler '" + handlername + "' found.");
        }
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.addHandler(h);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void removeHandlerFromLogger(String handlerName, String loggerName) throws RemoteException {
        Handler h = this.mf.getHandler(handlerName);
        if (h == null) {
            return;
        }
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.removeHandler(h);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void removeAllHandlersFromLogger(String loggerName) throws RemoteException {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.removeAllHandlers();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void setAdditivity(boolean a, String loggerName) throws RemoteException {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        l.setAdditivity(a);
    }

    public void setLoggerLevel(int level, String loggerName) throws RemoteException {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        l.setIntLevel(level);
    }

    public void setLoggerLevel(String levelName, String loggerName) throws RemoteException {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        Level level = this.mf.getLevel(levelName);
        if (level != null) {
            l.setLevel(level);
        }
    }

    public void addTopicToLogger(String topic, String loggerName) throws RemoteException {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.addTopic(topic);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void removeTopicFromLogger(String topic, String loggerName) throws RemoteException {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.removeTopic(topic);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public Properties getMonologProperties() throws RemoteException {
        Properties p = new Properties();
        try {
            PropertiesConfAccess.store(p, this.mf);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return p;
    }

    public void setMonologProperties(Properties p) throws RemoteException {
        try {
            PropertiesConfAccess.load(p, this.mf);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }
}

