/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.client;

import fr.dyade.aaa.jndi2.client.NamingConnection;
import fr.dyade.aaa.jndi2.client.NamingContextImpl;
import fr.dyade.aaa.jndi2.client.SimpleNamingConnection;
import fr.dyade.aaa.jndi2.client.Trace;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.objectweb.util.monolog.api.BasicLevel;

public class NamingContextFactory
implements InitialContextFactory {
    public static final String JAVA_PORT_PROPERTY = "java.naming.factory.port";
    public static final String JAVA_HOST_PROPERTY = "java.naming.factory.host";
    public static final String SCN_PORT_PROPERTY = "scn.naming.factory.port";
    public static final String SCN_HOST_PROPERTY = "scn.naming.factory.host";
    public static final String SCN_PROVIDER_URL = "scn.naming.provider.url";

    public Context getInitialContext(Hashtable env) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextFactory.getInitialContext(" + env + ')'));
        }
        return new NamingContextImpl(NamingContextFactory.getNamingConnection(env), new CompositeName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamingConnection getNamingConnection(Hashtable env) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextFactory.getNamingConnection(" + env + ')'));
        }
        try {
            int port;
            String host;
            String url = (String)env.get(SCN_PROVIDER_URL);
            if (url == null) {
                url = (String)env.get("java.naming.provider.url");
            }
            if (url != null && !url.equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(url, "/:,");
                if (!tokenizer.hasMoreElements()) {
                    throw new NamingException("URL not valid:" + url);
                }
                String protocol = tokenizer.nextToken();
                if (!protocol.equals("scn")) throw new NamingException("Unknown protocol:" + protocol);
                host = tokenizer.nextToken();
                String portStr = tokenizer.nextToken();
                port = Integer.parseInt(portStr);
                return new SimpleNamingConnection(host, port, env);
            } else {
                String portStr;
                host = (String)env.get(SCN_HOST_PROPERTY);
                if (host == null) {
                    host = System.getProperty(SCN_HOST_PROPERTY);
                }
                if (host == null) {
                    host = (String)env.get(JAVA_HOST_PROPERTY);
                }
                if (host == null) {
                    host = System.getProperty(JAVA_HOST_PROPERTY);
                }
                if (host == null) {
                    host = "localhost";
                }
                if ((portStr = (String)env.get(SCN_PORT_PROPERTY)) == null) {
                    portStr = System.getProperty(SCN_PORT_PROPERTY);
                }
                if (portStr == null) {
                    portStr = (String)env.get(JAVA_PORT_PROPERTY);
                }
                if (portStr == null) {
                    portStr = System.getProperty(JAVA_PORT_PROPERTY);
                }
                if (portStr == null) {
                    portStr = "16400";
                }
                port = Integer.parseInt(portStr);
            }
            return new SimpleNamingConnection(host, port, env);
        }
        catch (NumberFormatException e) {
            NamingException nx = new NamingException();
            nx.setRootCause(e);
            throw nx;
        }
        catch (Exception e) {
            NamingException nx = new NamingException();
            nx.setRootCause(e);
            throw nx;
        }
    }
}

