/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.server;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.jndi2.impl.Trace;
import fr.dyade.aaa.jndi2.server.AgentEntryPoint;
import fr.dyade.aaa.jndi2.server.Container;
import fr.dyade.aaa.jndi2.server.RequestManager;
import fr.dyade.aaa.jndi2.server.TcpEntryPoint;
import fr.dyade.aaa.jndi2.server.TcpServer;
import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ServerSocket;
import org.objectweb.util.monolog.api.BasicLevel;

public class JndiServer {
    @Deprecated
    public static final String SO_TIMEOUT_PROP = "fr.dyade.aaa.jndi2.server.soTimeout";
    public static final String POOL_SIZE_PROP = "fr.dyade.aaa.jndi2.server.poolSize";
    public static final int DEFAULT_POOL_SIZE = 3;
    private static TcpServer tcpServer;

    public static void init(String args, boolean firstTime) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("JndiServer.init(" + args + ',' + firstTime + ')'));
        }
        int port = Integer.parseInt(args);
        ServerSocket serverSocket = new ServerSocket(port);
        int poolSize = AgentServer.getInteger((String)POOL_SIZE_PROP, (int)3);
        if (AgentServer.getInteger((String)SO_TIMEOUT_PROP, (int)-1) != -1) {
            Trace.logger.log(BasicLevel.WARN, (Object)"\n!! Be careful, property \"fr.dyade.aaa.jndi2.server.soTimeout\" is no longer used.\n!! Please use property \"fr.dyade.aaa.jndi2.socketTimeOut\" instead.");
        }
        tcpServer = new TcpServer(serverSocket, poolSize, JndiServer.getDefault());
        if (firstTime) {
            RequestManager manager = new RequestManager();
            AgentEntryPoint agentEP = new AgentEntryPoint();
            agentEP.setRequestManager(manager);
            TcpEntryPoint tcpEP = new TcpEntryPoint();
            tcpEP.setRequestManager(manager);
            Container container = new Container();
            container.addEntryPoint(agentEP);
            container.addEntryPoint(tcpEP);
            container.setLifeCycleListener(manager);
            manager.setContainer(container);
            container.deploy();
        }
        try {
            MXWrapper.registerMBean((Object)tcpServer, (String)"JNDI", (String)"service=tcp");
        }
        catch (Exception exc) {
            Trace.logger.log(BasicLevel.WARN, (Object)" JNDI server jmx failed", (Throwable)exc);
        }
        tcpServer.start();
    }

    public static void stopService() {
        try {
            MXWrapper.unregisterMBean((String)"JNDI", (String)"service=tcp");
        }
        catch (Exception exc) {
            Trace.logger.log(BasicLevel.WARN, (Object)"JNDI server jmx failed", (Throwable)exc);
        }
        tcpServer.stop();
    }

    public static AgentId getDefault() {
        return JndiServer.getDefault(AgentServer.getServerId());
    }

    public static AgentId getDefault(short serverId) {
        return new AgentId(serverId, serverId, AgentId.LocalJndiServiceStamp);
    }
}

