/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.server;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import fr.dyade.aaa.jndi2.server.AgentRequestContext;
import fr.dyade.aaa.jndi2.server.EntryPoint;
import fr.dyade.aaa.jndi2.server.JndiScriptReplyNot;
import fr.dyade.aaa.jndi2.server.JndiScriptRequestNot;
import fr.dyade.aaa.jndi2.server.RequestManager;
import fr.dyade.aaa.jndi2.server.Trace;
import org.objectweb.util.monolog.api.BasicLevel;

public class AgentEntryPoint
implements EntryPoint {
    private static final long serialVersionUID = 1L;
    private RequestManager manager;

    public void setRequestManager(RequestManager manager) {
        this.manager = manager;
    }

    @Override
    public boolean accept(AgentId from, Notification not) throws Exception {
        if (!(not instanceof JndiScriptRequestNot)) {
            return false;
        }
        this.doReact(from, (JndiScriptRequestNot)not);
        return true;
    }

    private void doReact(AgentId from, JndiScriptRequestNot not) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("AgentEntryPoint[" + this.manager.getId() + "].doReact(" + from + ",(JndiScriptRequestNot)" + (Object)((Object)not) + ')'));
        }
        JndiRequest[] requests = not.getRequests();
        JndiReply[] replies = new JndiReply[requests.length];
        for (int i = 0; i < requests.length; ++i) {
            AgentRequestContext reqCtx = new AgentRequestContext(requests[i], from, not.reply());
            replies[i] = this.manager.invoke(reqCtx);
        }
        if (not.reply()) {
            this.manager.sendTo(from, new JndiScriptReplyNot(replies));
        }
    }
}

