/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.impl;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Strings;
import fr.dyade.aaa.jndi2.impl.ContextRecord;
import fr.dyade.aaa.jndi2.impl.NamingContextId;
import fr.dyade.aaa.jndi2.impl.NamingContextMBean;
import fr.dyade.aaa.jndi2.impl.ObjectRecord;
import fr.dyade.aaa.jndi2.impl.Record;
import fr.dyade.aaa.jndi2.impl.Trace;
import fr.dyade.aaa.jndi2.msg.ChangeOwnerRequest;
import fr.dyade.aaa.jndi2.msg.CreateSubcontextRequest;
import fr.dyade.aaa.jndi2.msg.DestroySubcontextRequest;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import fr.dyade.aaa.jndi2.msg.UnbindRequest;
import fr.dyade.aaa.jndi2.server.JndiScriptRequestNot;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.objectweb.util.monolog.api.BasicLevel;

public class NamingContext
implements NamingContextMBean,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private NamingContextId id;
    private Object ownerId;
    private Vector records;
    private CompositeName contextName;

    public NamingContext(NamingContextId id, Object ownerId, CompositeName contextName) {
        this.id = id;
        this.ownerId = ownerId;
        this.records = new Vector();
        this.contextName = contextName;
    }

    public final NamingContextId getId() {
        return this.id;
    }

    public final Object getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Object ownerId) {
        this.ownerId = ownerId;
    }

    public Record getRecord(String name) {
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public Enumeration getEnumRecord() {
        Vector<Record> elt = new Vector<Record>();
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            elt.add(r);
        }
        return elt.elements();
    }

    public void addRecord(Record record) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "\nadd record : " + record + " vector record : " + this.records + "\n");
        }
        this.records.addElement(record);
    }

    public boolean removeRecord(String name) {
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            if (!r.getName().equals(name)) continue;
            this.records.removeElementAt(i);
            return true;
        }
        return false;
    }

    public int size() {
        return this.records.size();
    }

    public NameClassPair[] getNameClassPairs() {
        NameClassPair[] res = new NameClassPair[this.records.size()];
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            if (r instanceof ObjectRecord) {
                ObjectRecord or = (ObjectRecord)r;
                res[i] = new NameClassPair(or.getName(), NamingContext.getClassName(or.getObject()), true);
                continue;
            }
            if (!(r instanceof ContextRecord)) continue;
            res[i] = new NameClassPair(r.getName(), Context.class.getName(), true);
        }
        return res;
    }

    public Binding[] getBindings() {
        Binding[] res = new Binding[this.records.size()];
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            if (r instanceof ObjectRecord) {
                ObjectRecord or = (ObjectRecord)r;
                res[i] = new Binding(or.getName(), NamingContext.getClassName(or.getObject()), or.getObject(), true);
                continue;
            }
            if (!(r instanceof ContextRecord)) continue;
            res[i] = new Binding(r.getName(), Context.class.getName(), null, true);
        }
        return res;
    }

    private static String getClassName(Object obj) {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            return ref.getClassName();
        }
        return obj.getClass().getName();
    }

    public Object clone() {
        try {
            NamingContext clone = (NamingContext)super.clone();
            clone.records = (Vector)this.records.clone();
            return clone;
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('(' + super.toString());
        buf.append(",id=" + this.id);
        buf.append(",ownerId=" + this.ownerId);
        buf.append(",name=" + this.contextName);
        buf.append(",records=");
        Strings.toString((StringBuffer)buf, (List)this.records);
        buf.append(')');
        return buf.toString();
    }

    public CompositeName getContextName() {
        return this.contextName;
    }

    @Override
    public String[] getNamingContext() {
        String[] array = new String[this.records.size()];
        for (int i = 0; i < this.records.size(); ++i) {
            Record r = (Record)this.records.elementAt(i);
            array[i] = r instanceof ObjectRecord ? r.getName() : "(javax.naming.Context)- " + r.getName();
        }
        return array;
    }

    @Override
    public String getStrOwnerId() {
        return this.ownerId.toString();
    }

    @Override
    public void setStrOwnerId(String strOwnerId) {
        if (!strOwnerId.equals(this.ownerId.toString())) {
            this.sendTo((JndiRequest)new ChangeOwnerRequest((CompositeName)this.contextName.clone(), strOwnerId));
        }
    }

    @Override
    public void createSubcontext(String ctxName) throws NamingException {
        CompositeName cn = (CompositeName)this.contextName.clone();
        if (this.contextName != null) {
            cn.add(ctxName);
        } else {
            cn = this.getCompositeName(ctxName);
        }
        this.sendTo((JndiRequest)new CreateSubcontextRequest(cn));
    }

    @Override
    public void destroySubcontext() throws NamingException {
        this.sendTo((JndiRequest)new DestroySubcontextRequest(this.contextName));
    }

    @Override
    public String lookup(String name) throws NamingException {
        Record rec = this.getRecord(name);
        if (rec != null) {
            return rec.toString();
        }
        return null;
    }

    @Override
    public void unbind(String name) throws NamingException {
        CompositeName cn = (CompositeName)this.contextName.clone();
        if (this.contextName != null) {
            cn.add(name);
        } else {
            cn = this.getCompositeName(name);
        }
        this.sendTo((JndiRequest)new UnbindRequest(cn));
    }

    @Override
    public Properties getProperties(String name) throws NamingException {
        Properties prop = new Properties();
        Record rec = this.getRecord(name);
        if (rec instanceof ObjectRecord) {
            Reference ref = (Reference)((ObjectRecord)rec).getObject();
            String className = ref.getClassName();
            prop.setProperty("className", className);
            if (className.equals("org.objectweb.joram.client.jms.Topic") || className.equals("org.objectweb.joram.client.jms.Queue")) {
                prop.setProperty("agentId", (String)ref.get("dest.agentId").getContent());
                prop.setProperty("name", (String)ref.get("dest.adminName").getContent());
            } else if (className.equals("org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory") || className.equals("org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory") || className.equals("org.objectweb.joram.client.jms.tcp.TcpConnectionFactory")) {
                prop.setProperty("host", (String)ref.get("cf.host").getContent());
                prop.setProperty("port", (String)ref.get("cf.port").getContent());
            }
        }
        return prop;
    }

    private CompositeName getCompositeName(String path) throws InvalidNameException {
        if (path.startsWith("/")) {
            return new CompositeName(path.substring(1, path.length()));
        }
        return new CompositeName(path);
    }

    private void sendTo(JndiRequest request) {
        Channel.sendTo((AgentId)((AgentId)this.ownerId), (Notification)new JndiScriptRequestNot(new JndiRequest[]{request}));
    }
}

