/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.impl;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.jndi2.impl.BindEvent;
import fr.dyade.aaa.jndi2.impl.ChangeOwnerEvent;
import fr.dyade.aaa.jndi2.impl.ContextManager;
import fr.dyade.aaa.jndi2.impl.ContextRecord;
import fr.dyade.aaa.jndi2.impl.CreateSubcontextEvent;
import fr.dyade.aaa.jndi2.impl.DestroySubcontextEvent;
import fr.dyade.aaa.jndi2.impl.MissingRecordException;
import fr.dyade.aaa.jndi2.impl.NamingContext;
import fr.dyade.aaa.jndi2.impl.NamingContextId;
import fr.dyade.aaa.jndi2.impl.NamingContextInfo;
import fr.dyade.aaa.jndi2.impl.NotOwnerException;
import fr.dyade.aaa.jndi2.impl.ObjectRecord;
import fr.dyade.aaa.jndi2.impl.RebindEvent;
import fr.dyade.aaa.jndi2.impl.Record;
import fr.dyade.aaa.jndi2.impl.Trace;
import fr.dyade.aaa.jndi2.impl.UnbindEvent;
import fr.dyade.aaa.jndi2.impl.UpdateListener;
import fr.dyade.aaa.util.Transaction;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.objectweb.util.monolog.api.BasicLevel;

public class ServerImpl {
    public static final String LOOSE_COUPLING = "fr.dyade.aaa.jndi2.impl.LooseCoupling";
    public static boolean looseCoupling;
    private Object serverId;
    private Object rootOwnerId;
    private UpdateListener updateListener;
    private ContextManager contextManager;

    public ServerImpl(Transaction transaction, Object serverId, Object rootOwnerId) {
        this.serverId = serverId;
        this.rootOwnerId = rootOwnerId;
        this.contextManager = new ContextManager(transaction, serverId, rootOwnerId);
        looseCoupling = AgentServer.getBoolean((String)LOOSE_COUPLING);
    }

    public void setUpdateListener(UpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    public void initialize() throws Exception {
        this.contextManager.initialize();
        if (this.rootOwnerId.equals(this.serverId) || looseCoupling) {
            NamingContext rootNc;
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.initialize : create root NamingContext");
            }
            if ((rootNc = this.contextManager.getRootNamingContext()) == null) {
                NamingContext namingContext = this.contextManager.newNamingContext(this.serverId, null, new CompositeName());
            }
        }
    }

    public void bind(CompositeName path, Object obj) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.bind(" + path + ',' + obj + ',' + ')');
        }
        if (path.size() == 0) {
            throw new NameAlreadyBoundException();
        }
        path = (CompositeName)path.clone();
        String lastName = (String)path.remove(path.size() - 1);
        NamingContext nc = this.contextManager.getNamingContext(path);
        this.bind(nc, lastName, obj, this.serverId);
        if (this.updateListener != null) {
            this.updateListener.onUpdate(new BindEvent(path, nc.getId(), lastName, obj));
        }
    }

    public void bind(NamingContext nc, String lastName, Object obj, Object ownerId) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.bind(" + nc + ',' + lastName + ',' + obj + ',' + ownerId + ')');
        }
        if (!nc.getOwnerId().equals(ownerId) && !looseCoupling) {
            throw new NotOwnerException(nc.getOwnerId());
        }
        Record r = nc.getRecord(lastName);
        if (r != null) {
            throw new NameAlreadyBoundException();
        }
        nc.addRecord(new ObjectRecord(lastName, obj));
        this.contextManager.storeNamingContext(nc);
    }

    public void rebind(CompositeName path, Object obj) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.rebind(" + path + ',' + obj + ',' + ')');
        }
        if (path.size() == 0) {
            throw new NamingException("Cannot rebind the root context");
        }
        path = (CompositeName)path.clone();
        String lastName = (String)path.remove(path.size() - 1);
        NamingContext nc = this.contextManager.getNamingContext(path);
        this.rebind(nc, lastName, obj, this.serverId);
        if (this.updateListener != null) {
            this.updateListener.onUpdate(new RebindEvent(path, nc.getId(), lastName, obj));
        }
    }

    public void rebind(NamingContext nc, String lastName, Object obj, Object ownerId) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.rebind(" + nc + ',' + lastName + ',' + obj + ',' + ownerId + ')');
        }
        if (!nc.getOwnerId().equals(ownerId) && !looseCoupling) {
            throw new NotOwnerException(nc.getOwnerId());
        }
        Record r = nc.getRecord(lastName);
        if (r != null) {
            if (r instanceof ContextRecord) {
                throw new NamingException("Cannot rebind a context");
            }
            ObjectRecord or = (ObjectRecord)r;
            or.setObject(obj);
        } else {
            nc.addRecord(new ObjectRecord(lastName, obj));
        }
        this.contextManager.storeNamingContext(nc);
    }

    public Record lookup(CompositeName path) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.lookup(" + path + ')');
        }
        if (path.size() == 0) {
            return null;
        }
        path = (CompositeName)path.clone();
        String lastName = (String)path.remove(path.size() - 1);
        NamingContext nc = this.contextManager.getNamingContext(path);
        Record r = nc.getRecord(lastName);
        if (r == null) {
            NameNotFoundException nnfe = new NameNotFoundException();
            nnfe.setResolvedName(path);
            throw new MissingRecordException(nc.getId(), nc.getOwnerId(), nnfe);
        }
        if (r instanceof ObjectRecord) {
            return r;
        }
        return null;
    }

    public void unbind(CompositeName path) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.unbind(" + path + ')');
        }
        if (path.size() == 0) {
            throw new NamingException("Cannot unbind the root context");
        }
        path = (CompositeName)path.clone();
        String lastName = (String)path.remove(path.size() - 1);
        NamingContext nc = this.contextManager.getNamingContext(path);
        if (this.unbind(nc, lastName, this.serverId) && this.updateListener != null) {
            this.updateListener.onUpdate(new UnbindEvent(path, nc.getId(), lastName));
        }
    }

    public boolean unbind(NamingContext nc, String lastName, Object ownerId) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.unbind(" + nc + ',' + lastName + ',' + ownerId + ')');
        }
        if (!nc.getOwnerId().equals(ownerId) && !looseCoupling) {
            throw new NotOwnerException(nc.getOwnerId());
        }
        Record r = nc.getRecord(lastName);
        if (r != null) {
            if (r instanceof ContextRecord) {
                throw new NamingException("Cannot unbind a context");
            }
            nc.removeRecord(lastName);
            this.contextManager.storeNamingContext(nc);
            return true;
        }
        return false;
    }

    public NameClassPair[] list(CompositeName path) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.list(" + path + ')');
        }
        NamingContext nc = this.contextManager.getNamingContext(path);
        return nc.getNameClassPairs();
    }

    public Binding[] listBindings(CompositeName path) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.listBindings(" + path + ')');
        }
        NamingContext nc = this.contextManager.getNamingContext(path);
        return nc.getBindings();
    }

    public void createSubcontext(CompositeName path) throws NamingException {
        this.createSubcontext(path, this.serverId);
    }

    public void createSubcontext(CompositeName path, Object subcontextOwnerId) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.createSubcontext(" + path + ',' + subcontextOwnerId + ')');
        }
        if (path.size() == 0) {
            throw new NameAlreadyBoundException();
        }
        CompositeName parentPath = (CompositeName)path.clone();
        String lastName = (String)parentPath.remove(parentPath.size() - 1);
        NamingContext parentNc = this.contextManager.getNamingContext(parentPath);
        NamingContextId ncid = this.createSubcontext(parentNc, lastName, path, null, subcontextOwnerId, this.serverId);
        if (this.updateListener != null) {
            this.updateListener.onUpdate(new CreateSubcontextEvent(parentNc.getId(), lastName, path, ncid, subcontextOwnerId));
        }
    }

    public NamingContextId createSubcontext(NamingContext parentNc, String lastName, CompositeName path, NamingContextId ncid, Object subcontextOwnerId, Object ownerId) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.createSubcontext(" + parentNc + ',' + lastName + ',' + path + ',' + ncid + ',' + subcontextOwnerId + ',' + ownerId + ')');
        }
        if (!parentNc.getOwnerId().equals(ownerId) && !looseCoupling) {
            throw new NotOwnerException(parentNc.getOwnerId());
        }
        if (parentNc.getRecord(lastName) != null) {
            throw new NameAlreadyBoundException();
        }
        NamingContext nc = !looseCoupling ? this.contextManager.newNamingContext(subcontextOwnerId, ncid, path) : this.contextManager.newNamingContext(subcontextOwnerId, null, path);
        parentNc.addRecord(new ContextRecord(lastName, nc.getId()));
        this.contextManager.storeNamingContext(parentNc);
        return nc.getId();
    }

    public void destroySubcontext(CompositeName path) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.destroySubcontext(" + path + ')');
        }
        if (path.size() == 0) {
            throw new NamingException("Cannot delete root context.");
        }
        CompositeName parentPath = (CompositeName)path.clone();
        String lastName = (String)parentPath.remove(parentPath.size() - 1);
        NamingContext parentNc = this.contextManager.getNamingContext(parentPath);
        try {
            NamingContext nc = this.contextManager.getNamingContext(path);
            if (nc.size() > 0) {
                if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                    Trace.logger.log(BasicLevel.DEBUG, " -> not empty: nc = " + nc);
                }
                throw new ContextNotEmptyException();
            }
        }
        catch (MissingRecordException exc) {
            return;
        }
        if (this.destroySubcontext(parentNc, lastName, path, this.serverId) && this.updateListener != null) {
            this.updateListener.onUpdate(new DestroySubcontextEvent(parentNc.getId(), lastName, path));
        }
    }

    public boolean destroySubcontext(NamingContext parentNc, String lastName, CompositeName path, Object ownerId) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.destroySubcontext(" + parentNc + ',' + lastName + ',' + path + ',' + ownerId + ')');
        }
        if (!parentNc.getOwnerId().equals(ownerId) && !looseCoupling) {
            throw new NotOwnerException(parentNc.getOwnerId());
        }
        Record r = parentNc.getRecord(lastName);
        if (r != null) {
            if (r instanceof ContextRecord) {
                ContextRecord cr = (ContextRecord)r;
                NamingContextId ctxId = cr.getId();
                this.contextManager.delete(ctxId, path);
                parentNc.removeRecord(lastName);
                this.contextManager.storeNamingContext(parentNc);
                return true;
            }
            throw new NotContextException();
        }
        return false;
    }

    public NamingContextInfo[] copyNamingContexts(Object serverId) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.copyNamingContexts(" + serverId + ')');
        }
        return this.contextManager.copyNamingContexts(serverId);
    }

    public NamingContext getNamingContext(NamingContextId ncid) throws NamingException {
        return this.contextManager.getNamingContext(ncid);
    }

    public NamingContext getNamingContext(CompositeName name) throws NamingException {
        return this.contextManager.getNamingContext(name);
    }

    public void storeNamingContext(NamingContext nc) throws NamingException {
        this.contextManager.storeNamingContext(nc);
    }

    public void addNamingContext(NamingContextInfo ncInfo) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.addNamingContext(" + ncInfo + ')');
        }
        this.contextManager.addNamingContext(ncInfo);
    }

    public NamingContext newNamingContext(Object ownerId, NamingContextId ncid, CompositeName name) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "ServerImpl.newNamingContext(" + name + ')');
        }
        return this.contextManager.newNamingContext(ownerId, ncid, name);
    }

    public void changeOwner(CompositeName name, Object newOwnerId) throws NamingException {
        NamingContextInfo[] contexts = this.contextManager.changeOwner(name, this.serverId, newOwnerId);
        if (this.updateListener != null) {
            this.updateListener.onUpdate(new ChangeOwnerEvent(newOwnerId, contexts));
        }
    }

    public void resetNamingContext(NamingContext context) throws NamingException {
        this.contextManager.resetNamingContext(context);
    }
}

