/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.msg;

import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.jndi2.shared.Trace;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import org.objectweb.util.monolog.api.BasicLevel;

public class IOControl {
    public static final String SO_TIMEOUT_PROP = "fr.dyade.aaa.jndi2.socketTimeOut";
    public static final int DEFAULT_SO_TIMEOUT = 5000;
    private static int socketTimeOut = Configuration.getInteger((String)"fr.dyade.aaa.jndi2.socketTimeOut", (int)5000);
    public static final String SO_LINGER_PROP = "fr.dyade.aaa.jndi2.socketLinger";
    private static int socketLinger = Configuration.getInteger((String)"fr.dyade.aaa.jndi2.socketLinger", (int)-1);
    public static final String SO_REUSE_ADDRESS_PROP = "fr.dyade.aaa.jndi2.socketReuseAddress";
    private static boolean socketReuseAddress = Configuration.getBoolean((String)"fr.dyade.aaa.jndi2.socketReuseAddress");
    private Socket socket;
    private BufferedInputStream bis;
    private NetOutputStream nos;

    public IOControl(Socket socket, Hashtable env) throws IOException {
        this.socket = socket;
        int socketTimeOut = IOControl.socketTimeOut;
        int socketLinger = IOControl.socketLinger;
        boolean socketReuseAddress = IOControl.socketReuseAddress;
        if (env != null) {
            Object value = env.get(SO_TIMEOUT_PROP);
            if (value != null && value instanceof String) {
                socketTimeOut = Integer.valueOf((String)value);
            }
            if ((value = env.get(SO_LINGER_PROP)) != null && value instanceof String) {
                socketLinger = Integer.valueOf((String)value);
            }
            if ((value = env.get(SO_REUSE_ADDRESS_PROP)) != null && value instanceof String) {
                socketReuseAddress = Boolean.valueOf((String)value);
            }
        }
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(socketTimeOut);
        if (socketLinger >= 0) {
            socket.setSoLinger(true, socketLinger);
        }
        socket.setReuseAddress(socketReuseAddress);
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, "Create transport: SO_TIMEOUT=" + socketTimeOut + ", SO_LINGER=" + socketLinger + ", SO_REUSEADDR=" + socketReuseAddress);
        }
        this.nos = new NetOutputStream(socket);
        this.bis = new BufferedInputStream(socket.getInputStream());
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(this.bis);
        return ois.readObject();
    }

    public int readInt() throws IOException {
        DataInputStream dis = new DataInputStream(this.bis);
        return dis.readInt();
    }

    public void writeObject(Object obj) throws IOException {
        this.nos.send(obj);
    }

    public void writeInt(int i) throws IOException {
        this.nos.send(i);
    }

    public void close() {
        try {
            this.socket.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final Socket getSocket() {
        return this.socket;
    }

    static class NetOutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        private ObjectOutputStream oos = new ObjectOutputStream(this.baos);
        private OutputStream os = null;
        private static final byte[] streamHeader = new byte[]{-84, -19, 0, 5};

        NetOutputStream(Socket sock) throws IOException {
            this.baos.reset();
            this.os = sock.getOutputStream();
        }

        void send(Object msg) throws IOException {
            try {
                this.baos.write(streamHeader, 0, 4);
                this.oos.writeObject(msg);
                this.oos.flush();
                this.baos.writeTo(this.os);
                this.os.flush();
            }
            finally {
                this.oos.reset();
                this.baos.reset();
            }
        }

        void send(int i) throws IOException {
            DataOutputStream daos = new DataOutputStream(this.os);
            daos.writeInt(i);
            daos.flush();
        }
    }
}

